/*
 * Decompiled with CFR 0.152.
 */
package com.wondertrademod.wondertrade.commands;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.wondertrademod.wondertrade.TickHandler;
import com.wondertrademod.wondertrade.Utilities;
import com.wondertrademod.wondertrade.WonderTrades;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class WonderTrade
extends CommandBase {
    public static String strColorRed = EnumChatFormatting.RED + "";
    public static String strColorGreen = EnumChatFormatting.GREEN + "";
    public static String strColorYellow = EnumChatFormatting.YELLOW + "";
    public static String strColorBlue = EnumChatFormatting.AQUA + "";
    public static String strColorWhite = EnumChatFormatting.WHITE + "";
    public static List<String> aliases = new ArrayList<String>();
    public static ArrayList<String> numbers;

    public String func_71517_b() {
        return "wondertrade";
    }

    public List func_71514_a() {
        return aliases;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/wondertrade <slot # to give to wondertrade> - give pokemon to wondertrade";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        String username = par1ICommandSender.func_70005_c_();
        EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)par1ICommandSender);
        if (par2ArrayOfStr.length < 1 || par2ArrayOfStr.length > 2) {
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "Invalid Arguments.");
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + this.func_71518_a(par1ICommandSender));
            return;
        }
        if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "Cannot use WonderTrade while in battle!");
            return;
        }
        if (player.field_70170_p.field_73011_w.field_76574_g != 0) {
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "Can only use WonderTrade when in the overworld!");
            return;
        }
        if (par2ArrayOfStr.length >= 1 && par2ArrayOfStr.length <= 2) {
            long intCooldownRemaining = Utilities.cooldownRemaining(username);
            if (intCooldownRemaining > 0L) {
                Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "You can't use this again command for " + strColorYellow + intCooldownRemaining + " more minutes!");
                return;
            }
            if (!numbers.contains(par2ArrayOfStr[0])) {
                Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "Invalid Slot Number (must be 1-6)");
                Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + this.func_71518_a(par1ICommandSender));
                return;
            }
            Integer intPartySlot = Integer.parseInt(par2ArrayOfStr[0]);
            Integer intCountPokemon = 0;
            try {
                NBTTagCompound[] all_nbt;
                PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                for (NBTTagCompound nbt : all_nbt = storage.getList()) {
                    if (nbt == null) continue;
                    Integer n = intCountPokemon;
                    Integer n2 = intCountPokemon = Integer.valueOf(intCountPokemon + 1);
                }
                if (intCountPokemon <= 1) {
                    Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "You can't trade away your last Pixelmon!");
                    return;
                }
                if (all_nbt[intPartySlot - 1] == null) {
                    Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "There is no Pixelmon in that party slot!");
                    return;
                }
                boolean isConfirmed = WonderTrade.getConfirmationFromPlayer(par1ICommandSender, par2ArrayOfStr);
                if (!isConfirmed) {
                    return;
                }
                storage.recallAllPokemon();
                NBTTagCompound n1 = null;
                NBTTagCompound nbtFromPlayer = all_nbt[intPartySlot - 1];
                EntityPixelmon sentPokemon = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT((NBTTagCompound)nbtFromPlayer, (World)WonderTrades.world);
                Utilities.writeToLog(username, username + " put a " + sentPokemon.getNature().name() + " " + sentPokemon.getName() + " lvl: " + sentPokemon.getLvl().getLevel() + (sentPokemon.getIsShiny() ? " (s)" : "") + " into the WonderTrade Pool");
                storage.changePokemonAndAssignID(intPartySlot - 1, n1);
                storage.sendUpdatedList();
                EntityPixelmon pokemon = TickHandler.exchangePokemon(username, sentPokemon);
                storage.addToParty(pokemon);
                storage.sendUpdatedList();
                Utilities.sendMessageToCommandSender(par1ICommandSender, strColorGreen + "You recieved a " + (pokemon.getIsShiny() ? strColorYellow + "SHINY " : strColorBlue + "") + pokemon.getName() + strColorGreen + " from WonderTrade!");
                Utilities.writeToLog(username, username + " recived a " + pokemon.getNature().name() + " " + pokemon.getName() + " lvl: " + pokemon.getLvl().getLevel() + (pokemon.getIsShiny() ? " (s)" : "") + " from the WonderTrade Pool");
                Utilities.saveTime(username);
                TickHandler.checkPoolSize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List func_71516_a(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        return WonderTrade.func_71530_a((String[])par2ArrayOfStr, (String[])numbers.toArray(new String[0]));
    }

    public static boolean getConfirmationFromPlayer(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        boolean isConfirmed = false;
        String strConfirm = "";
        for (String arg : par2ArrayOfStr) {
            strConfirm = strConfirm + arg + " ";
            if (!arg.equalsIgnoreCase("confirm")) continue;
            isConfirmed = true;
        }
        if (isConfirmed) {
            return true;
        }
        Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "NOTICE:" + strColorYellow + " Using this command will take your Pokemon away. To confirm your selection type:");
        Utilities.sendMessageToCommandSender(par1ICommandSender, strColorYellow + "/wt " + strConfirm + "confirm");
        return false;
    }

    static {
        aliases.add("wt");
        numbers = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5", "6"));
    }
}

