/*
 * Decompiled with CFR 0.152.
 */
package com.wondertrademod.wondertrade.commands;

import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.wondertrademod.wondertrade.TickHandler;
import com.wondertrademod.wondertrade.Utilities;
import com.wondertrademod.wondertrade.WonderTrades;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class WonderTradeAdmin
extends CommandBase {
    public static String strColorRed = EnumChatFormatting.RED + "";
    public static String strColorGreen = EnumChatFormatting.GREEN + "";
    public static String strColorYellow = EnumChatFormatting.YELLOW + "";
    public static String strColorBlue = EnumChatFormatting.AQUA + "";
    public static String strColorWhite = EnumChatFormatting.WHITE + "";
    public static ArrayList<String> commands = new ArrayList<String>(Arrays.asList("add", "list", "purge", "remove", "print"));
    public static ArrayList<String> legendaries = new ArrayList<String>(Arrays.asList("articuno", "zapdos", "moltres", "mewtwo", "mew", "entei", "raikou", "suicune", "ho-oh", "lugia", "celebi", "regirock", "regice", "registeel", "latios", "latias", "groudon", "kyogre", "rayquaza", "jirachi", "deoxys", "uxie", "azelf", "mesprit", "dialga", "palkia", "giratina", "cresselia", "darkrai", "manaphy", "phione", "heatran", "regigigas", "shaymin", "arceus", "victini", "cobalion", "terrakion", "virizion", "keldeo", "thundurus", "tornadus", "landorus", "zekrom", "reshiram", "kyurem", "genesect", "meloetta", "xerneas", "yveltal", "zygarde"));
    public static ArrayList<String> pokemon = new ArrayList();

    public String func_71517_b() {
        return "wtadmin";
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        Utilities.sendMessageToCommandSender(par1ICommandSender, "/wtadmin add <pixelmonname> <s>)");
        Utilities.sendMessageToCommandSender(par1ICommandSender, "/wtadmin remove <pixelmonname>");
        Utilities.sendMessageToCommandSender(par1ICommandSender, "/wtadmin purge - clear pool and regenerate");
        Utilities.sendMessageToCommandSender(par1ICommandSender, "/wtadmin list - list pokemon in pool");
        Utilities.sendMessageToCommandSender(par1ICommandSender, "/wtadmin print - prints announcement message to whole server");
        return "/wtadmin <command> <arguments>";
    }

    public int func_82362_a() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_71515_b(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        if (par2ArrayOfStr.length <= 0) {
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "Invalid Arguments.");
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + this.func_71518_a(par1ICommandSender));
            return;
        }
        if (par2ArrayOfStr[0].equals("add")) {
            this.addPokemon(par1ICommandSender, par2ArrayOfStr);
            return;
        }
        if (par2ArrayOfStr[0].equals("remove")) {
            this.removePokemon(par1ICommandSender, par2ArrayOfStr);
            return;
        }
        if (par2ArrayOfStr[0].equals("list")) {
            WonderTradeAdmin.listPokemon(par1ICommandSender);
            return;
        }
        if (par2ArrayOfStr[0].equals("purge")) {
            this.purge(par1ICommandSender);
            return;
        }
        if (par2ArrayOfStr[0].equals("print")) {
            TickHandler.doPoolAnnouncement(false);
            return;
        }
        Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "Invalid Arguments.");
        Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + this.func_71518_a(par1ICommandSender));
    }

    public void addPokemon(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        if (par2ArrayOfStr.length >= 2) {
            String name = par2ArrayOfStr[1];
            if (EnumPokemon.hasPokemon((String)name)) {
                EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName((String)name, (World)WonderTrades.world);
                if (par2ArrayOfStr.length > 2 && par2ArrayOfStr[2].equalsIgnoreCase("s")) {
                    pokemon.setIsShiny(true);
                }
                if (pokemon != null) {
                    TickHandler.addPokemon(par1ICommandSender, pokemon);
                    Utilities.sendMessageToCommandSender(par1ICommandSender, strColorGreen + "You have added " + name + " to the pool of pokemon!");
                }
            } else {
                Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + name + " does not exist!");
            }
        } else {
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "/wtadmin add <pixelmon>");
        }
    }

    public void removePokemon(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        Integer intCountRemoved = 0;
        boolean removeOnlyShiny = false;
        if (par2ArrayOfStr.length == 2 || par2ArrayOfStr.length == 3) {
            String name = par2ArrayOfStr[1];
            if (!EnumPokemon.hasPokemon((String)name)) {
                Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + name + " does not exist!");
            } else {
                if (par2ArrayOfStr.length > 2 && par2ArrayOfStr[2].equalsIgnoreCase("s")) {
                    removeOnlyShiny = true;
                }
                for (int i = 0; i < TickHandler.pokemonPool.size(); ++i) {
                    Integer n;
                    Integer n2;
                    EntityPixelmon pokemon2;
                    if (TickHandler.pokemonPool.get(i) == null || !(pokemon2 = TickHandler.pokemonPool.get(i)).getName().equalsIgnoreCase(name)) continue;
                    if (removeOnlyShiny) {
                        if (!pokemon2.getIsShiny()) continue;
                        TickHandler.pokemonPool.remove(i);
                        --i;
                        n2 = intCountRemoved;
                        n = intCountRemoved = Integer.valueOf(intCountRemoved + 1);
                        continue;
                    }
                    TickHandler.pokemonPool.remove(i);
                    --i;
                    n2 = intCountRemoved;
                    n = intCountRemoved = Integer.valueOf(intCountRemoved + 1);
                }
                if (intCountRemoved == 0) {
                    Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + name + " is not in the pool!");
                } else {
                    Utilities.sendMessageToCommandSender(par1ICommandSender, strColorGreen + "You have removed " + intCountRemoved + "x " + name + " from the pool of pokemon!");
                }
            }
        } else {
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "/wtadmin remove <pixelmon> <s>");
        }
    }

    public static void listPokemon(ICommandSender par1ICommandSender) {
        Utilities.sendMessageToCommandSender(par1ICommandSender, strColorBlue + "Pokemon In WonderTrade Pool:");
        for (int i = 0; i < TickHandler.pokemonPool.size(); ++i) {
            if (TickHandler.pokemonPool.get(i) == null) continue;
            EntityPixelmon pokemon = TickHandler.pokemonPool.get(i);
            Utilities.sendMessageToCommandSender(par1ICommandSender, strColorRed + "#" + i + ": " + strColorBlue + pokemon.getName() + strColorGreen + " lvl: " + pokemon.getLvl().getLevel() + strColorYellow + (pokemon.getIsShiny() ? " (s)" : ""));
        }
    }

    public void purge(ICommandSender par1ICommandSender) {
        TickHandler.initializePool();
        Utilities.sendMessageToCommandSender(par1ICommandSender, strColorGreen + "You have regenerated all entries in the pool!");
    }

    public List func_71516_a(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        if (par2ArrayOfStr.length == 1) {
            return WonderTradeAdmin.func_71530_a((String[])par2ArrayOfStr, (String[])commands.toArray(new String[0]));
        }
        if (par2ArrayOfStr.length == 2) {
            return WonderTradeAdmin.func_71530_a((String[])par2ArrayOfStr, (String[])pokemon.toArray(new String[0]));
        }
        return null;
    }

    static {
        for (EnumPokemon p : EnumPokemon.values()) {
            pokemon.add(p.name);
        }
    }
}

