/*
 * Decompiled with CFR 0.152.
 */
package com.wondertrademod.wondertrade.config;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class WonderTradeConfig {
    public static Configuration config;
    public static Integer intTimeLimitMinutes;
    public static Integer intLegendaryRate;
    public static Integer intMaxLevel;
    public static Integer intMinLevel;
    public static Integer intShinyRate;
    public static Integer intPoolSize;
    public static Integer intAnnouncementFrequency;
    public static boolean boolInvertShinyAnnouncement;
    public static String strTutorialURL;

    public static void loadConfig(Configuration configuration) {
        config = configuration;
        config.addCustomCategoryComment("general", "General Settings For Wondertrade");
        Property propTimeLimit = config.get("general", "Time Between Uses: ", 60);
        intTimeLimitMinutes = Math.max(0, propTimeLimit.getInt(60));
        propTimeLimit.comment = "Sets the minimum time that a player must wait between uses of /wondertrade (in Minutes)";
        Property propAnnouncementFrequency = config.get("general", "Time Between Announcements: ", 60);
        intAnnouncementFrequency = Math.min(60, Math.max(0, propAnnouncementFrequency.getInt(60)));
        propAnnouncementFrequency.comment = "Sets the time between Server-wide announcements about WonderTrade (in Minutes) - will run at least once per hour";
        config.addCustomCategoryComment("pixelmon", "Settings for Auto-generated Pixelmon in Wondertrade Pool on server start");
        Property propPoolSize = config.get("pixelmon", "Pool Size: ", 100);
        intPoolSize = propPoolSize.getInt(100);
        propPoolSize.comment = "Sets the size of the pool of Pixelmon wondertrade generates at startup and selects from during play";
        Property propLegendaryRate = config.get("pixelmon", "Legendary Rate: ", 1500);
        intLegendaryRate = propLegendaryRate.getInt(1500);
        propLegendaryRate.comment = "Sets the chances of a generated Pixelmon in the pool being a Legendary (higher values = less legendary chance) (0 = no chance)";
        Property propShinyRate = config.get("pixelmon", "Shiny Rate: ", 8192);
        intShinyRate = propShinyRate.getInt(8192);
        propShinyRate.comment = "Sets the chances of a generated Pixelmon in the pool being shiny (higher values = less shiny chance) (0 = no chance)";
        Property propMaxLevel = config.get("pixelmon", "Max Level: ", 40);
        intMaxLevel = Math.min(Math.max(propMaxLevel.getInt(40), 2), 99);
        propMaxLevel.comment = "Sets the max level to generate Pixelmon at for the pool at (2-100)";
        Property propMinLevel = config.get("pixelmon", "Min Level: ", 5);
        intMinLevel = Math.min(Math.max(propMinLevel.getInt(5), 2), 99);
        if (intMinLevel >= intMaxLevel) {
            intMinLevel = Math.max(2, intMaxLevel - 1);
        }
        propMinLevel.comment = "Sets the min level to generate Pixelmon at for the pool at (2-100)";
        config.save();
    }

    static {
        intTimeLimitMinutes = -1;
        intLegendaryRate = -1;
        intMaxLevel = -1;
        intMinLevel = -1;
        intShinyRate = -1;
        intPoolSize = -1;
        intAnnouncementFrequency = -1;
        boolInvertShinyAnnouncement = false;
        strTutorialURL = "https://www.youtube.com/ghostwolfgames";
    }
}

