/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockAreaIterator;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockMapper;
import ivorius.ivtoolkit.raytracing.IvRaytraceableAxisAlignedBox;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import ivorius.ivtoolkit.raytracing.IvRaytracer;
import ivorius.ivtoolkit.tools.MCRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class IvBlockCollection
implements Iterable<BlockCoord> {
    private final Block[] blocks;
    private final byte[] metas;
    public final int width;
    public final int height;
    public final int length;

    public IvBlockCollection(int width, int height, int length) {
        this(IvBlockCollection.airArray(width, height, length), new byte[width * height * length], width, height, length);
    }

    private static Block[] airArray(int width, int height, int length) {
        Object[] blocks = new Block[width * height * length];
        Arrays.fill(blocks, Blocks.field_150350_a);
        return blocks;
    }

    public IvBlockCollection(Block[] blocks, byte[] metas, int width, int height, int length) {
        if (blocks.length != width * height * length || metas.length != blocks.length) {
            throw new IllegalArgumentException();
        }
        this.blocks = blocks;
        this.metas = metas;
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public IvBlockCollection(NBTTagCompound compound, MCRegistry registry) {
        this.width = compound.func_74762_e("width");
        this.height = compound.func_74762_e("height");
        this.length = compound.func_74762_e("length");
        this.metas = compound.func_74770_j("metadata");
        IvBlockMapper mapper = new IvBlockMapper(compound, "mapping", registry);
        this.blocks = mapper.createBlocksFromNBT(compound.func_74775_l("blocks"));
        if (this.blocks.length != this.width * this.height * this.length) {
            throw new RuntimeException("Block collection length is " + this.blocks.length + " but should be " + this.width + " * " + this.height + " * " + this.length);
        }
    }

    public Block getBlock(BlockCoord coord) {
        if (!this.hasCoord(coord)) {
            return Blocks.field_150350_a;
        }
        return this.blocks[this.indexFromCoord(coord)];
    }

    public byte getMetadata(BlockCoord coord) {
        if (!this.hasCoord(coord)) {
            return 0;
        }
        return this.metas[this.indexFromCoord(coord)];
    }

    public void setBlockAndMetadata(BlockCoord coord, Block block, byte meta) {
        if (!this.hasCoord(coord)) {
            return;
        }
        int index = this.indexFromCoord(coord);
        this.blocks[index] = block;
        this.metas[index] = meta;
    }

    public void setBlock(BlockCoord coord, Block block) {
        if (!this.hasCoord(coord)) {
            return;
        }
        this.blocks[this.indexFromCoord((BlockCoord)coord)] = block;
    }

    public void setMetadata(BlockCoord coord, byte meta) {
        if (!this.hasCoord(coord)) {
            return;
        }
        this.metas[this.indexFromCoord((BlockCoord)coord)] = meta;
    }

    private int indexFromCoord(BlockCoord coord) {
        return (coord.z * this.height + coord.y) * this.width + coord.x;
    }

    public boolean hasCoord(BlockCoord coord) {
        return coord.x >= 0 && coord.x < this.width && coord.y >= 0 && coord.y < this.height && coord.z >= 0 && coord.z < this.length;
    }

    public boolean shouldRenderSide(BlockCoord coord, ForgeDirection side) {
        BlockCoord sideCoord = coord.add(side.offsetX, side.offsetY, side.offsetZ);
        Block block = this.getBlock(sideCoord);
        return !block.func_149662_c();
    }

    public MovingObjectPosition rayTrace(Vec3 position, Vec3 direction) {
        IvRaytraceableAxisAlignedBox containingBox = new IvRaytraceableAxisAlignedBox(null, 0.001, 0.001, 0.001, (double)this.width - 0.002, (double)this.height - 0.002, (double)this.length - 0.002);
        IvRaytracedIntersection intersection = IvRaytracer.getFirstIntersection(Arrays.asList(containingBox), position.field_72450_a, position.field_72448_b, position.field_72449_c, direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        if (intersection != null) {
            position = Vec3.func_72443_a((double)intersection.getX(), (double)intersection.getY(), (double)intersection.getZ());
            BlockCoord curCoord = new BlockCoord(MathHelper.func_76128_c((double)position.field_72450_a), MathHelper.func_76128_c((double)position.field_72448_b), MathHelper.func_76128_c((double)position.field_72449_c));
            ForgeDirection hitSide = ((ForgeDirection)intersection.getHitInfo()).getOpposite();
            while (this.hasCoord(curCoord)) {
                double dirLength;
                if (this.getBlock(curCoord).func_149688_o() != Material.field_151579_a) {
                    return new MovingObjectPosition(curCoord.x, curCoord.y, curCoord.z, hitSide.getOpposite().ordinal(), position);
                }
                hitSide = this.getExitSide(position, direction);
                if (hitSide.offsetX != 0) {
                    double offX = hitSide.offsetX > 0 ? 1.0001 : -1.0E-4;
                    dirLength = ((double)curCoord.x + offX - position.field_72450_a) / direction.field_72450_a;
                    position = Vec3.func_72443_a((double)((double)curCoord.x + offX), (double)(position.field_72448_b + direction.field_72448_b * dirLength), (double)(position.field_72449_c + direction.field_72449_c * dirLength));
                } else if (hitSide.offsetY != 0) {
                    double offY = hitSide.offsetY > 0 ? 1.0001 : -1.0E-4;
                    dirLength = ((double)curCoord.y + offY - position.field_72448_b) / direction.field_72448_b;
                    position = Vec3.func_72443_a((double)(position.field_72450_a + direction.field_72450_a * dirLength), (double)((double)curCoord.y + offY), (double)(position.field_72449_c + direction.field_72449_c * dirLength));
                } else {
                    double offZ = hitSide.offsetZ > 0 ? 1.0001 : -1.0E-4;
                    dirLength = ((double)curCoord.z + offZ - position.field_72449_c) / direction.field_72449_c;
                    position = Vec3.func_72443_a((double)(position.field_72450_a + direction.field_72450_a * dirLength), (double)(position.field_72448_b + direction.field_72448_b * dirLength), (double)((double)curCoord.z + offZ));
                }
                curCoord = curCoord.add(hitSide.offsetX, hitSide.offsetY, hitSide.offsetZ);
            }
        }
        return null;
    }

    private ForgeDirection getExitSide(Vec3 position, Vec3 direction) {
        double zDist;
        double innerX = (position.field_72450_a % 1.0 + 1.0) % 1.0;
        double innerY = (position.field_72448_b % 1.0 + 1.0) % 1.0;
        double innerZ = (position.field_72449_c % 1.0 + 1.0) % 1.0;
        double xDist = direction.field_72450_a > 0.0 ? (1.0 - innerX) / direction.field_72450_a : innerX / -direction.field_72450_a;
        double yDist = direction.field_72448_b > 0.0 ? (1.0 - innerY) / direction.field_72448_b : innerY / -direction.field_72448_b;
        double d = zDist = direction.field_72449_c > 0.0 ? (1.0 - innerZ) / direction.field_72449_c : innerZ / -direction.field_72449_c;
        if (xDist < yDist && xDist < zDist) {
            return direction.field_72450_a > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        if (yDist < zDist) {
            return direction.field_72448_b > 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        return direction.field_72449_c > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
    }

    public int getBlockMultiplicity() {
        HashSet blockSet = new HashSet();
        Collections.addAll(blockSet, this.blocks);
        return blockSet.size();
    }

    public NBTTagCompound createTagCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        IvBlockMapper mapper = new IvBlockMapper();
        compound.func_74768_a("width", this.width);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("length", this.length);
        compound.func_74773_a("metadata", this.metas);
        mapper.addMapping(this.blocks);
        compound.func_74782_a("mapping", (NBTBase)mapper.createTagList());
        compound.func_74782_a("blocks", (NBTBase)mapper.createNBTForBlocks(this.blocks));
        return compound;
    }

    public String toString() {
        return "IvBlockCollection{length=" + this.length + ", height=" + this.height + ", width=" + this.width + '}';
    }

    @Override
    public Iterator<BlockCoord> iterator() {
        return new BlockAreaIterator(new BlockCoord(0, 0, 0), new BlockCoord(this.width - 1, this.height - 1, this.length - 1));
    }
}

