/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.raytracing.IvRaytraceableAxisAlignedBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Vector3f;

public class IvMultiBlockHelper
implements Iterable<int[]> {
    private Iterator<int[]> iterator;
    private List<int[]> childLocations;
    private IvTileEntityMultiBlock parentTileEntity = null;
    private World world;
    private Block block;
    private int metadata;
    private int direction;
    private double[] center;
    private double[] size;

    public boolean beginPlacing(List<int[]> positions, World world, int x, int y, int z, int blockSide, ItemStack itemStack, EntityPlayer player, Block block, int metadata, int direction) {
        List<int[]> validLocations = IvMultiBlockHelper.getBestPlacement(positions, world, x, y, z, blockSide, itemStack, player, block);
        if (validLocations == null) {
            return false;
        }
        return this.beginPlacing(validLocations, world, block, metadata, direction);
    }

    public boolean beginPlacing(List<int[]> validLocations, World world, Block block, int metadata, int direction) {
        this.world = world;
        this.block = block;
        this.metadata = metadata;
        this.parentTileEntity = null;
        this.direction = direction;
        this.center = IvMultiBlockHelper.getTileEntityCenter(validLocations);
        this.size = IvMultiBlockHelper.getTileEntitySize(validLocations);
        this.childLocations = validLocations;
        this.iterator = validLocations.iterator();
        return true;
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.iterator;
    }

    public IvTileEntityMultiBlock placeBlock(int[] blockCoords) {
        return this.placeBlock(blockCoords, this.parentTileEntity == null);
    }

    private IvTileEntityMultiBlock placeBlock(int[] blockCoords, boolean parent) {
        this.world.func_147465_d(blockCoords[0], blockCoords[1], blockCoords[2], this.block, this.metadata, 3);
        TileEntity tileEntity = this.world.func_147438_o(blockCoords[0], blockCoords[1], blockCoords[2]);
        if (tileEntity instanceof IvTileEntityMultiBlock) {
            IvTileEntityMultiBlock tileEntityMB = (IvTileEntityMultiBlock)tileEntity;
            if (parent) {
                this.parentTileEntity = tileEntityMB;
                this.childLocations.remove(new int[]{this.parentTileEntity.field_145851_c, this.parentTileEntity.field_145848_d, this.parentTileEntity.field_145849_e});
                this.parentTileEntity.becomeParent(this.childLocations);
            } else {
                tileEntityMB.becomeChild(this.parentTileEntity);
            }
            tileEntityMB.direction = this.direction;
            tileEntityMB.centerCoords = new double[]{this.center[0] - (double)blockCoords[0], this.center[1] - (double)blockCoords[1], this.center[2] - (double)blockCoords[2]};
            tileEntityMB.centerCoordsSize = this.size;
            return tileEntityMB;
        }
        return null;
    }

    public static double[] getTileEntityCenter(List<int[]> positions) {
        double[] result = IvMultiBlockHelper.getCenter(positions);
        return new double[]{result[0] + 0.5, result[1] + 0.5, result[2] + 0.5};
    }

    public static double[] getTileEntitySize(List<int[]> positions) {
        return IvMultiBlockHelper.getSize(positions);
    }

    public static double[] getCenter(List<int[]> positions) {
        if (positions.size() > 0) {
            int[] min = IvMultiBlockHelper.getExtremeCoords(positions, true);
            int[] max = IvMultiBlockHelper.getExtremeCoords(positions, false);
            double[] result = new double[min.length];
            for (int i = 0; i < min.length; ++i) {
                result[i] = (float)(min[i] + max[i]) * 0.5f;
            }
            return result;
        }
        return null;
    }

    public static double[] getSize(List<int[]> positions) {
        if (positions.size() > 0) {
            int[] min = IvMultiBlockHelper.getExtremeCoords(positions, true);
            int[] max = IvMultiBlockHelper.getExtremeCoords(positions, false);
            double[] result = new double[min.length];
            for (int i = 0; i < min.length; ++i) {
                result[i] = (float)(max[i] - min[i] + 1) * 0.5f;
            }
            return result;
        }
        return null;
    }

    public static int[] getExtremeCoords(List<int[]> positions, boolean min) {
        if (positions.size() > 0) {
            int[] selectedPos = (int[])positions.get(0).clone();
            for (int n = 1; n < positions.size(); ++n) {
                int[] position = positions.get(n);
                for (int i = 0; i < selectedPos.length; ++i) {
                    selectedPos[i] = min ? Math.min(position[i], selectedPos[i]) : Math.max(position[i], selectedPos[i]);
                }
            }
            return selectedPos;
        }
        return null;
    }

    public static int[] getLengths(List<int[]> positions) {
        int[] min = IvMultiBlockHelper.getExtremeCoords(positions, true);
        int[] max = IvMultiBlockHelper.getExtremeCoords(positions, false);
        return new int[]{max[0] - min[0], max[1] - min[1], max[2] - min[2]};
    }

    public static boolean canPlace(World world, Block block, List<int[]> positions, Entity entity, ItemStack stack) {
        for (int[] position : positions) {
            if (world.func_147472_a(block, position[0], position[1], position[2], false, 0, entity, stack)) continue;
            return false;
        }
        return true;
    }

    public static List<List<int[]>> getValidPlacements(List<int[]> positions, World world, int x, int y, int z, int blockSide, ItemStack itemStack, EntityPlayer player, Block block) {
        Block var11 = world.func_147439_a(x, y, z);
        if (var11 == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            blockSide = 1;
        } else if (var11 != Blocks.field_150395_bd && var11 != Blocks.field_150329_H && var11 != Blocks.field_150330_I && !var11.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (blockSide == 0) {
                --y;
            } else if (blockSide == 1) {
                ++y;
            } else if (blockSide == 2) {
                --z;
            } else if (blockSide == 3) {
                ++z;
            } else if (blockSide == 4) {
                --x;
            } else if (blockSide == 5) {
                ++x;
            }
        }
        if (!player.func_82247_a(x, y, z, blockSide, itemStack)) {
            return new ArrayList<List<int[]>>();
        }
        if (y == world.func_72800_K() && block.func_149688_o().func_76220_a()) {
            return new ArrayList<List<int[]>>();
        }
        int[] lengths = IvMultiBlockHelper.getLengths(positions);
        int[] min = IvMultiBlockHelper.getExtremeCoords(positions, true);
        ArrayList<List<int[]>> validPlacements = new ArrayList<List<int[]>>();
        for (int xShift = min[0] - lengths[0]; xShift <= min[0]; ++xShift) {
            for (int yShift = min[1] - lengths[1]; yShift <= min[1]; ++yShift) {
                for (int zShift = min[2] - lengths[2]; zShift <= min[2]; ++zShift) {
                    ArrayList<int[]> validPositions = new ArrayList<int[]>();
                    for (int[] position : positions) {
                        validPositions.add(new int[]{position[0] + x + xShift, position[1] + y + yShift, position[2] + z + zShift});
                    }
                    if (!IvMultiBlockHelper.canPlace(world, block, validPositions, null, itemStack)) continue;
                    validPlacements.add(validPositions);
                }
            }
        }
        return validPlacements;
    }

    public static List<int[]> getBestPlacement(List<int[]> positions, World world, int x, int y, int z, int blockSide, ItemStack itemStack, EntityPlayer player, Block block) {
        int[] lengths = IvMultiBlockHelper.getLengths(positions);
        List<List<int[]>> validPlacements = IvMultiBlockHelper.getValidPlacements(positions, world, x, y, z, blockSide, itemStack, player, block);
        if (validPlacements.size() > 0) {
            float[] center = new float[]{(float)x - (float)lengths[0] * 0.5f, (float)y - (float)lengths[1] * 0.5f, (float)z - (float)lengths[2] * 0.5f};
            List<int[]> preferredPositions = validPlacements.get(0);
            for (int i = 1; i < validPlacements.size(); ++i) {
                int[] referenceBlock = validPlacements.get(i).get(0);
                int[] referenceBlockOriginal = preferredPositions.get(0);
                if (!(IvMultiBlockHelper.distanceSquared(referenceBlock, center) < IvMultiBlockHelper.distanceSquared(referenceBlockOriginal, center))) continue;
                preferredPositions = validPlacements.get(i);
            }
            return preferredPositions;
        }
        return null;
    }

    private static float distanceSquared(int[] referenceBlock, float[] center) {
        float distX = (float)referenceBlock[0] - center[0];
        float distY = (float)referenceBlock[1] - center[1];
        float distZ = (float)referenceBlock[2] - center[2];
        return distX * distX + distY * distY + distZ * distZ;
    }

    public static List<int[]> getRotatedPositions(List<int[]> positions, int rotation) {
        ArrayList<int[]> returnList = new ArrayList<int[]>(positions.size());
        for (int[] position : positions) {
            if (rotation == 0) {
                returnList.add(new int[]{position[0], position[1], position[2]});
            }
            if (rotation == 1) {
                returnList.add(new int[]{position[2], position[1], position[0]});
            }
            if (rotation == 2) {
                returnList.add(new int[]{position[0], position[1], position[2]});
            }
            if (rotation != 3) continue;
            returnList.add(new int[]{position[2], position[1], position[0]});
        }
        return returnList;
    }

    public static IvRaytraceableAxisAlignedBox getRotatedBox(Object userInfo, double x, double y, double z, double width, double height, double depth, int direction, double[] centerCoords) {
        IvRaytraceableAxisAlignedBox box = null;
        if (direction == 0) {
            box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] - x - width, centerCoords[1] + y, centerCoords[2] + z, width, height, depth);
        }
        if (direction == 1) {
            box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] - z - depth, centerCoords[1] + y, centerCoords[2] - x - width, depth, height, width);
        }
        if (direction == 2) {
            box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] + x, centerCoords[1] + y, centerCoords[2] - z - depth, width, height, depth);
        }
        if (direction == 3) {
            box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] + z, centerCoords[1] + y, centerCoords[2] + x, depth, height, width);
        }
        return box;
    }

    public static AxisAlignedBB getRotatedBB(double x, double y, double z, double width, double height, double depth, int direction, double[] centerCoords) {
        AxisAlignedBB box = null;
        if (direction == 0) {
            box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] + x, centerCoords[1] + y, centerCoords[2] + z, width, height, depth);
        }
        if (direction == 1) {
            box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] - z - depth, centerCoords[1] + y, centerCoords[2] + x, depth, height, width);
        }
        if (direction == 2) {
            box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] - x - width, centerCoords[1] + y, centerCoords[2] - z - depth, width, height, depth);
        }
        if (direction == 3) {
            box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] + z, centerCoords[1] + y, centerCoords[2] - x - width, depth, height, width);
        }
        return box;
    }

    public static Vector3f getRotatedVector(Vector3f vector3f, int rotation) {
        if (rotation == 0) {
            return new Vector3f(vector3f.x, vector3f.y, vector3f.z);
        }
        if (rotation == 1) {
            return new Vector3f(-vector3f.z, vector3f.y, vector3f.x);
        }
        if (rotation == 2) {
            return new Vector3f(-vector3f.x, vector3f.y, -vector3f.z);
        }
        if (rotation == 3) {
            return new Vector3f(vector3f.z, vector3f.y, -vector3f.x);
        }
        return null;
    }

    public static Vec3 getRotatedVector(Vec3 vec3, int rotation) {
        if (rotation == 0) {
            return Vec3.func_72443_a((double)vec3.field_72450_a, (double)vec3.field_72448_b, (double)vec3.field_72449_c);
        }
        if (rotation == 1) {
            return Vec3.func_72443_a((double)(-vec3.field_72449_c), (double)vec3.field_72448_b, (double)vec3.field_72450_a);
        }
        if (rotation == 2) {
            return Vec3.func_72443_a((double)(-vec3.field_72450_a), (double)vec3.field_72448_b, (double)(-vec3.field_72449_c));
        }
        if (rotation == 3) {
            return Vec3.func_72443_a((double)vec3.field_72449_c, (double)vec3.field_72448_b, (double)(-vec3.field_72450_a));
        }
        return null;
    }

    public static AxisAlignedBB getBBWithLengths(double x, double y, double z, double width, double height, double depth) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + width), (double)(y + height), (double)(z + depth));
    }

    public static int getRotation(Entity entity) {
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static List<int[]> getRotatedPositions(int rotation, int width, int height, int length) {
        boolean affectsX = rotation == 0 || rotation == 2;
        return IvMultiBlockHelper.getPositions(affectsX ? width : length, height, affectsX ? length : width);
    }

    public static List<int[]> getPositions(int width, int height, int length) {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int z = 0;
                while (z < length) {
                    positions.add(new int[]{x, y, z++});
                }
            }
        }
        return positions;
    }
}

