/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.logic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReferenceCounter<V> {
    private Map<V, Integer> map = new HashMap<V, Integer>();
    private Set<V> freeObjects = new HashSet<V>();

    public int getRetainCount(V object) {
        Integer val = this.map.get(object);
        return val != null ? val : 0;
    }

    public boolean hasObject(V object) {
        return this.getRetainCount(object) > 0;
    }

    public void retain(V object, int retainCount) {
        int newCount = this.getRetainCount(object) + retainCount;
        this.map.put((Integer)object, newCount);
    }

    public boolean release(V object, int releaseCount) {
        int newCount = this.getRetainCount(object) - releaseCount;
        if (newCount < 0) {
            throw new RuntimeException("Trying to release a freed object!");
        }
        if (newCount == 0) {
            this.freeObjects.add(object);
            this.map.remove(object);
        } else {
            this.map.put((Integer)object, newCount);
        }
        return newCount > 0;
    }

    public Set<V> deallocateAllFreeObjects() {
        if (this.freeObjects.size() == 0) {
            return Collections.emptySet();
        }
        Set<V> freeObjects = this.freeObjects;
        this.freeObjects = new HashSet<V>();
        return freeObjects;
    }

    public int numberOfRetainedObjects() {
        return this.map.size();
    }

    public int numberOfFreeObjects() {
        return this.freeObjects.size();
    }

    public Set<V> getFreeObjects() {
        return Collections.unmodifiableSet(this.freeObjects);
    }

    public Set<V> getAllRetainedObjects() {
        return this.map.keySet();
    }
}

