/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class IvMatrixHelper {
    public static Matrix4f getProjectionMatrix(float fov, float aspect, float nearPlane, float farPlane) {
        Matrix4f projectionMatrix = new Matrix4f();
        float y_scale = IvMatrixHelper.coTangent(fov / 2.0f);
        float x_scale = y_scale / aspect;
        float frustum_length = farPlane - nearPlane;
        projectionMatrix.m00 = x_scale;
        projectionMatrix.m11 = y_scale;
        projectionMatrix.m22 = -((farPlane + nearPlane) / frustum_length);
        projectionMatrix.m23 = -1.0f;
        projectionMatrix.m32 = -(2.0f * nearPlane * farPlane / frustum_length);
        projectionMatrix.m33 = 0.0f;
        return projectionMatrix;
    }

    public static Matrix4f getOrthographicMatrix(float left, float right, float bottom, float top, float zNear, float zFar) {
        Matrix4f projectionMatrix = new Matrix4f();
        projectionMatrix.m00 = 2.0f / (right - left);
        projectionMatrix.m11 = 2.0f / (top - bottom);
        projectionMatrix.m22 = -2.0f / (zFar - zNear);
        projectionMatrix.m30 = -(right + left) / (right - left);
        projectionMatrix.m31 = -(top + bottom) / (top - bottom);
        projectionMatrix.m32 = -(zFar + zNear) / (zFar - zNear);
        projectionMatrix.m33 = 1.0f;
        return projectionMatrix;
    }

    public static float coTangent(float f) {
        return 1.0f / (float)Math.tan(f);
    }

    public static Matrix4f lookFrom(float posX, float posY, float posZ, float yaw, float pitch, float roll, Matrix4f src, Matrix4f dest) {
        Matrix4f.rotate((float)roll, (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)src, (Matrix4f)dest);
        Matrix4f.rotate((float)pitch, (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)src, (Matrix4f)dest);
        Matrix4f.rotate((float)yaw, (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)src, (Matrix4f)dest);
        Matrix4f.translate((Vector3f)new Vector3f(-posX, -posY, -posZ), (Matrix4f)src, (Matrix4f)dest);
        return dest;
    }

    public static Vector3f projectPoint(Matrix4f projectionMatrix, float posX, float posY, float posZ, float yaw, float pitch, float roll, Vector3f point) {
        Matrix4f lookProjectionMatrix = IvMatrixHelper.lookFrom(posX, posY, posZ, yaw, pitch, roll, projectionMatrix, projectionMatrix);
        Vector4f clippedPoint = new Vector4f(point.x, point.y, point.z, 1.0f);
        Matrix4f.transform((Matrix4f)lookProjectionMatrix, (Vector4f)clippedPoint, (Vector4f)clippedPoint);
        return new Vector3f(clippedPoint.x, clippedPoint.y, clippedPoint.z);
    }
}

