/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.network;

import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.channel.Channel;
import ivorius.ivtoolkit.network.PacketEntityData;
import ivorius.ivtoolkit.network.PacketExtendedEntityPropertiesData;
import ivorius.ivtoolkit.network.PacketTileEntityData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class IvNetworkHelperServer {
    public static void sendEEPUpdatePacket(Entity entity, String eepKey, String context, SimpleNetworkWrapper network) {
        IvNetworkHelperServer.sendToPlayersWatchingEntity(entity, PacketExtendedEntityPropertiesData.packetEntityData(entity, eepKey, context), network);
    }

    public static <UEntity extends Entity> void sendEntityUpdatePacket(UEntity entity, String context, SimpleNetworkWrapper network) {
        IvNetworkHelperServer.sendToPlayersWatchingEntity(entity, PacketEntityData.packetEntityData(entity, context), network);
    }

    public static void sendToPlayersWatchingEntity(Entity entity, IMessage message, SimpleNetworkWrapper network) {
        if (!(entity.field_70170_p instanceof WorldServer)) {
            throw new UnsupportedOperationException();
        }
        network.sendToDimension(message, entity.field_70170_p.field_73011_w.field_76574_g);
    }

    public static <UTileEntity extends TileEntity> void sendTileEntityUpdatePacket(UTileEntity tileEntity, String context, SimpleNetworkWrapper network, EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new UnsupportedOperationException();
        }
        network.sendTo((IMessage)PacketTileEntityData.packetEntityData(tileEntity, context), (EntityPlayerMP)player);
    }

    public static <UTileEntity extends TileEntity> void sendTileEntityUpdatePacket(UTileEntity tileEntity, String context, SimpleNetworkWrapper network) {
        IvNetworkHelperServer.sendToPlayersWatchingChunk(tileEntity.func_145831_w(), tileEntity.field_145851_c / 16, tileEntity.field_145849_e / 16, network, PacketTileEntityData.packetEntityData(tileEntity, context));
    }

    public static void sendToPlayersWatchingChunk(World world, int chunkX, int chunkZ, SimpleNetworkWrapper network, IMessage message) {
        List<EntityPlayerMP> playersWatching = IvNetworkHelperServer.getPlayersWatchingChunk(world, chunkX, chunkZ);
        for (EntityPlayerMP playerMP : playersWatching) {
            network.sendTo(message, playerMP);
        }
    }

    public static void sendToPlayersWatchingChunk(World world, int chunkX, int chunkZ, Channel channel, Object message) {
        List<EntityPlayerMP> playersWatching = IvNetworkHelperServer.getPlayersWatchingChunk(world, chunkX, chunkZ);
        for (EntityPlayerMP playerMP : playersWatching) {
            IvNetworkHelperServer.sendToPlayer(channel, playerMP, message);
        }
    }

    public static void sendToPlayersWatchingChunk(World world, int chunkX, int chunkZ, Packet packet) {
        List<EntityPlayerMP> playersWatching = IvNetworkHelperServer.getPlayersWatchingChunk(world, chunkX, chunkZ);
        for (EntityPlayerMP playerMP : playersWatching) {
            playerMP.field_71135_a.func_147359_a(packet);
        }
    }

    public static void sendToPlayer(Channel channel, EntityPlayerMP playerMP, Object message) {
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)playerMP);
        channel.writeAndFlush(message);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return Collections.emptyList();
        }
        ArrayList<EntityPlayerMP> playersWatching = new ArrayList<EntityPlayerMP>();
        WorldServer server = (WorldServer)world;
        PlayerManager playerManager = server.func_73040_p();
        List players = server.field_73010_i;
        for (EntityPlayerMP player : players) {
            if (!playerManager.func_72694_a(player, chunkX, chunkZ)) continue;
            playersWatching.add(player);
        }
        return playersWatching;
    }
}

