/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.blocks;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.Maze;
import ivorius.ivtoolkit.maze.MazeComponent;
import ivorius.ivtoolkit.maze.MazeComponentPosition;
import ivorius.ivtoolkit.maze.MazeGenerator;
import ivorius.ivtoolkit.maze.MazeGeneratorWithComponents;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.reccomplex.blocks.GeneratingTileEntity;
import ivorius.reccomplex.worldgen.genericStructures.WorldGenMaze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityMazeGenerator
extends TileEntity
implements GeneratingTileEntity {
    public List<MazeComponent> mazeComponents = new ArrayList<MazeComponent>();
    public List<MazePath> mazeExits = new ArrayList<MazePath>();
    public BlockCoord structureShift = new BlockCoord(0, 0, 0);
    public int[] roomSize = new int[]{3, 5, 3};
    public int[] roomNumbers = new int[]{4, 1, 4};

    public List<MazeComponent> getMazeComponents() {
        return Collections.unmodifiableList(this.mazeComponents);
    }

    public void setMazeComponents(List<MazeComponent> mazeComponents) {
        IvCollections.setContentsOfList(this.mazeComponents, mazeComponents);
    }

    public BlockCoord getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockCoord structureShift) {
        this.structureShift = structureShift;
    }

    public int[] getRoomSize() {
        return (int[])this.roomSize.clone();
    }

    public void setRoomSize(int[] roomSize) {
        this.roomSize = roomSize;
    }

    public int[] getRoomNumbers() {
        return (int[])this.roomNumbers.clone();
    }

    public void setRoomNumbers(int[] roomNumbers) {
        this.roomNumbers = roomNumbers;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readMazeDataFromNBT(nbtTagCompound);
    }

    public void readMazeDataFromNBT(NBTTagCompound nbtTagCompound) {
        this.mazeComponents.clear();
        NBTTagList componentsList = nbtTagCompound.func_150295_c("mazeComponents", 10);
        for (int i = 0; i < componentsList.func_74745_c(); ++i) {
            this.mazeComponents.add(new MazeComponent(componentsList.func_150305_b(i)));
        }
        this.mazeExits.clear();
        NBTTagList exitsList = nbtTagCompound.func_150295_c("mazeExits", 10);
        for (int i = 0; i < exitsList.func_74745_c(); ++i) {
            this.mazeExits.add(new MazePath(exitsList.func_150305_b(i)));
        }
        this.structureShift = BlockCoord.readCoordFromNBT("structureShift", nbtTagCompound);
        this.roomSize = IvNBTHelper.readIntArrayFixedSize("roomSize", 3, nbtTagCompound);
        this.roomNumbers = IvNBTHelper.readIntArrayFixedSize("roomNumbers", 3, nbtTagCompound);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeMazeDataToNBT(nbtTagCompound);
    }

    public void writeMazeDataToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList componentList = new NBTTagList();
        for (MazeComponent component : this.mazeComponents) {
            NBTTagCompound compound = new NBTTagCompound();
            component.writeToNBT(compound);
            componentList.func_74742_a((NBTBase)compound);
        }
        nbtTagCompound.func_74782_a("mazeComponents", (NBTBase)componentList);
        NBTTagList exitsList = new NBTTagList();
        for (MazePath exit : this.mazeExits) {
            exitsList.func_74742_a((NBTBase)exit.writeToNBT());
        }
        nbtTagCompound.func_74782_a("mazeExits", (NBTBase)exitsList);
        BlockCoord.writeCoordToNBT("structureShift", this.structureShift, nbtTagCompound);
        nbtTagCompound.func_74783_a("roomSize", this.roomSize);
        nbtTagCompound.func_74783_a("roomNumbers", this.roomNumbers);
    }

    @Override
    public void generate(World world, Random random, AxisAlignedTransform2D transform, int layer) {
        world.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        BlockCoord startCoord = this.structureShift.add(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Maze maze = new Maze(this.roomNumbers[0] * 2 + 1, this.roomNumbers[1] * 2 + 1, this.roomNumbers[2] * 2 + 1);
        MazePath[] mazeExits = new MazePath[1 + this.mazeExits.size()];
        mazeExits[0] = MazeGenerator.randomPathInMaze(random, maze, 1, 1, 1);
        for (int i = 0; i < this.mazeExits.size(); ++i) {
            mazeExits[i + 1] = this.mazeExits.get(i);
        }
        List<MazeComponent> transformedComponents = WorldGenMaze.transformedComponents(this.mazeComponents);
        MazeGenerator.generateStartPathsForEnclosedMaze(maze, mazeExits);
        List<MazeComponentPosition> placedComponents = MazeGeneratorWithComponents.generatePaths(random, maze, transformedComponents);
        WorldGenMaze.generateMaze(world, random, startCoord, placedComponents, this.roomSize, layer);
    }
}

