/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.items.ItemBlockSelectorFloating;
import ivorius.reccomplex.worldgen.WorldGenStructures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import org.lwjgl.opengl.GL11;

public class RCForgeEventHandler {
    private WorldGenStructures worldGenStructures = new WorldGenStructures();

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPreChunkDecoration(PopulateChunkEvent.Pre event) {
        this.worldGenStructures.generate(event.rand, event.chunkX, event.chunkZ, event.world, event.chunkProvider, event.chunkProvider);
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            StructureEntityInfo.initInEntity(event.entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawWorld(RenderWorldLastEvent event) {
        ItemStack heldItem;
        EntityClientPlayerMP renderEntity = Minecraft.func_71410_x().field_71439_g;
        StructureEntityInfo structureEntityInfo = StructureEntityInfo.getStructureEntityInfo((Entity)renderEntity);
        BlockCoord hoverPoint = null;
        BlockCoord selPoint1 = null;
        BlockCoord selPoint2 = null;
        if (structureEntityInfo != null) {
            selPoint1 = structureEntityInfo.selectedPoint1;
            selPoint2 = structureEntityInfo.selectedPoint2;
        }
        if ((heldItem = renderEntity.func_70694_bm()) != null && heldItem.func_77973_b() instanceof ItemBlockSelectorFloating) {
            hoverPoint = ItemBlockSelectorFloating.getHoveredBlock((EntityLivingBase)renderEntity, ((ItemBlockSelectorFloating)heldItem.func_77973_b()).selectionRange);
        }
        if (selPoint1 != null || selPoint2 != null || hoverPoint != null) {
            double entityX = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)event.partialTicks;
            double entityY = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)event.partialTicks;
            double entityZ = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)event.partialTicks;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-entityX), (double)(-entityY), (double)(-entityZ));
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)3.0f);
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            if (selPoint1 != null && selPoint2 != null) {
                BlockCoord smaller = structureEntityInfo.selectedPoint1.getLowerCorner(structureEntityInfo.selectedPoint2);
                BlockCoord bigger = structureEntityInfo.selectedPoint1.getHigherCorner(structureEntityInfo.selectedPoint2);
                BlockCoord biggerMax = bigger.add(1, 1, 1);
                GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)0.2f);
                RCForgeEventHandler.drawCuboid(smaller, biggerMax, false);
                GL11.glColor3f((float)0.6f, (float)0.6f, (float)0.6f);
                RCForgeEventHandler.drawCuboid(smaller, biggerMax, true);
            }
            if (selPoint1 != null) {
                GL11.glColor3f((float)1.0f, (float)0.3f, (float)0.3f);
                RCForgeEventHandler.drawCuboid(selPoint1, selPoint1.add(1, 1, 1), true);
            }
            if (selPoint2 != null) {
                GL11.glColor3f((float)0.3f, (float)1.0f, (float)0.3f);
                RCForgeEventHandler.drawCuboid(selPoint2, selPoint2.add(1, 1, 1), true);
            }
            if (hoverPoint != null) {
                GL11.glColor3f((float)0.3f, (float)0.3f, (float)1.0f);
                RCForgeEventHandler.drawCuboid(hoverPoint, hoverPoint.add(1, 1, 1), true);
            }
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawCuboid(BlockCoord min, BlockCoord max, boolean lined) {
        float width2 = ((float)max.x - (float)min.x) * 0.5f;
        float height2 = ((float)max.y - (float)min.y) * 0.5f;
        float length2 = ((float)max.z - (float)min.z) * 0.5f;
        double centerX = (float)min.x + width2;
        double centerY = (float)min.y + height2;
        double centerZ = (float)min.z + length2;
        GL11.glPushMatrix();
        GL11.glTranslated((double)centerX, (double)centerY, (double)centerZ);
        IvRenderHelper.drawCuboid(Tessellator.field_78398_a, width2 + 0.062f, height2 + 0.062f, length2 + 0.062f, 1.0f, lined);
        GL11.glPopMatrix();
    }
}

