/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.TableElementDefault;
import ivorius.reccomplex.gui.table.TableElementProperty;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TableElementPropertyDefault<P>
extends TableElementDefault
implements TableElementProperty<P> {
    protected P property;
    private List<TableElementPropertyListener> listeners = new ArrayList<TableElementPropertyListener>();

    public TableElementPropertyDefault(String id, String title, P value) {
        super(id, title);
        this.setPropertyValue(value);
    }

    public void addPropertyListener(TableElementPropertyListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyListener(TableElementPropertyListener listener) {
        this.listeners.remove(listener);
    }

    public List<TableElementPropertyListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    protected void alertListenersOfChange() {
        for (TableElementPropertyListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    @Override
    public P getPropertyValue() {
        return this.property;
    }

    @Override
    public void setPropertyValue(P value) {
        this.property = value;
    }
}

