/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ivorius.reccomplex.json.NBTBaseSerializerSmart;
import ivorius.reccomplex.json.NBTTagByteArraySerializer;
import ivorius.reccomplex.json.NBTTagByteSerializer;
import ivorius.reccomplex.json.NBTTagCompoundSerializer;
import ivorius.reccomplex.json.NBTTagDoubleSerializer;
import ivorius.reccomplex.json.NBTTagEndSerializer;
import ivorius.reccomplex.json.NBTTagFloatSerializer;
import ivorius.reccomplex.json.NBTTagIntArraySerializer;
import ivorius.reccomplex.json.NBTTagIntSerializer;
import ivorius.reccomplex.json.NBTTagListSerializer;
import ivorius.reccomplex.json.NBTTagLongSerializer;
import ivorius.reccomplex.json.NBTTagShortSerializer;
import ivorius.reccomplex.json.NBTTagStringSerializer;
import ivorius.reccomplex.json.StringTypeAdapterFactory;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtToJson {
    public static final Gson nbtJson = NbtToJson.createGson();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        NbtToJson.registerAllNBTSerializers(builder);
        return builder.create();
    }

    public static StringTypeAdapterFactory<NBTBase> createSafeNBTSerializer() {
        StringTypeAdapterFactory<NBTBase> nbtAdapterFactory = new StringTypeAdapterFactory<NBTBase>("nbt", "nbtType");
        nbtAdapterFactory.register("byteArray", NBTTagByteArray.class, new NBTTagByteArraySerializer());
        nbtAdapterFactory.register("byte", NBTTagByte.class, new NBTTagByteSerializer());
        nbtAdapterFactory.register("compound", NBTTagCompound.class, new NBTTagCompoundSerializer());
        nbtAdapterFactory.register("double", NBTTagDouble.class, new NBTTagDoubleSerializer());
        nbtAdapterFactory.register("end", NBTTagEnd.class, new NBTTagEndSerializer());
        nbtAdapterFactory.register("float", NBTTagFloat.class, new NBTTagFloatSerializer());
        nbtAdapterFactory.register("intArray", NBTTagIntArray.class, new NBTTagIntArraySerializer());
        nbtAdapterFactory.register("int", NBTTagInt.class, new NBTTagIntSerializer());
        nbtAdapterFactory.register("list", NBTTagList.class, new NBTTagListSerializer());
        nbtAdapterFactory.register("long", NBTTagLong.class, new NBTTagLongSerializer());
        nbtAdapterFactory.register("short", NBTTagShort.class, new NBTTagShortSerializer());
        nbtAdapterFactory.register("string", NBTTagString.class, new NBTTagStringSerializer());
        return nbtAdapterFactory;
    }

    public static void registerSafeNBTSerializer(GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(NBTBase.class, NbtToJson.createSafeNBTSerializer());
    }

    public static void registerAllNBTSerializers(GsonBuilder builder) {
        builder.registerTypeAdapter(NBTTagByteArray.class, (Object)new NBTTagByteArraySerializer());
        builder.registerTypeAdapter(NBTTagByte.class, (Object)new NBTTagByteSerializer());
        builder.registerTypeAdapter(NBTTagCompound.class, (Object)new NBTTagCompoundSerializer());
        builder.registerTypeAdapter(NBTTagDouble.class, (Object)new NBTTagDoubleSerializer());
        builder.registerTypeAdapter(NBTTagEnd.class, (Object)new NBTTagEndSerializer());
        builder.registerTypeAdapter(NBTTagFloat.class, (Object)new NBTTagFloatSerializer());
        builder.registerTypeAdapter(NBTTagIntArray.class, (Object)new NBTTagIntArraySerializer());
        builder.registerTypeAdapter(NBTTagInt.class, (Object)new NBTTagIntSerializer());
        builder.registerTypeAdapter(NBTTagList.class, (Object)new NBTTagListSerializer());
        builder.registerTypeAdapter(NBTTagLong.class, (Object)new NBTTagLongSerializer());
        builder.registerTypeAdapter(NBTTagShort.class, (Object)new NBTTagShortSerializer());
        builder.registerTypeAdapter(NBTTagString.class, (Object)new NBTTagStringSerializer());
    }

    public static void registerSmartNBTSerializer(GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(NBTBase.class, (Object)new NBTBaseSerializerSmart());
    }

    public static Class<? extends NBTBase> getNBTTypeSmart(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            if (array.size() == 0) {
                return NBTTagList.class;
            }
            boolean allByte = true;
            boolean allInt = true;
            for (JsonElement arrayElement : array) {
                if (arrayElement.isJsonPrimitive()) {
                    JsonPrimitive primitive = arrayElement.getAsJsonPrimitive();
                    if (!primitive.isNumber() || !(primitive.getAsNumber() instanceof Byte)) {
                        allByte = false;
                    }
                    if (primitive.isNumber() && primitive.getAsNumber() instanceof Integer) continue;
                    allInt = false;
                    continue;
                }
                allByte = false;
                allInt = false;
            }
            if (allByte) {
                return NBTTagByteArray.class;
            }
            if (allInt) {
                return NBTTagIntArray.class;
            }
            return NBTTagList.class;
        }
        if (element.isJsonObject()) {
            return NBTTagCompound.class;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return NBTTagString.class;
            }
            if (primitive.isNumber()) {
                return NBTBase.NBTPrimitive.class;
            }
        }
        return null;
    }

    public static NBTTagCompound getNBTFromBase64(String elementString) {
        byte[] nbtBytes = DatatypeConverter.parseBase64Binary((String)elementString);
        try {
            return CompressedStreamTools.func_152457_a((byte[])nbtBytes, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getBase64FromNBT(NBTTagCompound compound) {
        try {
            byte[] worldDataByteArray = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
            return DatatypeConverter.printBase64Binary((byte[])worldDataByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

