/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.json;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.json.JsonUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StringTypeAdapterFactory<B>
implements JsonSerializer<B>,
JsonDeserializer<B> {
    private Map<String, JsonDeserializer<? extends B>> deserializerMap = new HashMap<String, JsonDeserializer<? extends B>>();
    private Map<Class<? extends B>, JsonSerializer<? extends B>> serializerMap = new HashMap<Class<? extends B>, JsonSerializer<? extends B>>();
    private BiMap<Class<? extends B>, String> classMap = HashBiMap.create();
    private String typeKey;
    private String objectKey;

    public StringTypeAdapterFactory(String objectKey, String typeKey) {
        if (objectKey.equals(typeKey)) {
            throw new IllegalArgumentException("Type key must be different from object key");
        }
        this.objectKey = objectKey;
        this.typeKey = typeKey;
    }

    public StringTypeAdapterFactory() {
        this("object", "type");
    }

    public void register(String id, Class<? extends B> clazz, JsonSerializer<? extends B> serializer, JsonDeserializer<? extends B> deserializer) {
        this.deserializerMap.put(id, deserializer);
        this.serializerMap.put(clazz, serializer);
        this.classMap.put(clazz, (Object)id);
    }

    public <K extends B, MultiSerializer extends JsonSerializer<K> & JsonDeserializer<K>> void register(String id, Class<K> clazz, MultiSerializer multiSerializer) {
        this.register(id, (Class<? extends B>)clazz, (JsonSerializer<? extends B>)multiSerializer, (JsonDeserializer<? extends B>)multiSerializer);
    }

    public JsonDeserializer<? extends B> deserializer(String key) {
        return this.deserializerMap.get(key);
    }

    public JsonSerializer<? extends B> serializer(Class<? extends B> aClass) {
        return this.serializerMap.get(aClass);
    }

    public String type(Class<? extends B> aClass) {
        return (String)this.classMap.get(aClass);
    }

    public Class<? extends B> objectClass(String type) {
        return (Class)this.classMap.inverse().get((Object)type);
    }

    public Collection<String> allIDs() {
        return this.deserializerMap.keySet();
    }

    public B deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        if (json.isJsonObject() && (jsonObject = json.getAsJsonObject()).has(this.typeKey) && jsonObject.has(this.objectKey)) {
            String type = JsonUtils.getJsonObjectStringFieldValue(jsonObject, this.typeKey);
            JsonDeserializer<B> deserializer = this.deserializer(type);
            if (deserializer != null) {
                return (B)deserializer.deserialize(jsonObject.get(this.objectKey), typeOfT, context);
            }
            throw new JsonParseException("Unknown type: " + type);
        }
        return null;
    }

    public JsonElement serialize(B src, Type typeOfSrc, JsonSerializationContext context) {
        Class<?> objectClass = src.getClass();
        String id = this.type(objectClass);
        JsonSerializer<?> serializer = this.serializer(objectClass);
        if (id != null && serializer != null) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(this.typeKey, id);
            jsonObject.add(this.objectKey, serializer.serialize(src, typeOfSrc, context));
            return jsonObject;
        }
        return null;
    }
}

