/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.common.Loader;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerationHandler;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class GenericInventoryGenerator
implements InventoryGenerator,
Cloneable {
    public static final int LATEST_VERSION = 1;
    public int minItems;
    public int maxItems;
    public List<WeightedRandomChestContent> weightedRandomChestContents;
    public List<String> dependencies = new ArrayList<String>();

    public GenericInventoryGenerator(int minItems, int maxItems, List<String> dependencies, WeightedRandomChestContent ... weightedRandomChestContents) {
        this.minItems = minItems;
        this.maxItems = maxItems;
        this.dependencies = new ArrayList<String>();
        this.dependencies.addAll(dependencies);
        this.weightedRandomChestContents = new ArrayList<WeightedRandomChestContent>();
        Collections.addAll(this.weightedRandomChestContents, weightedRandomChestContents);
    }

    public GenericInventoryGenerator(int minItems, int maxItems, List<String> dependencies, List<WeightedRandomChestContent> weightedRandomChestContents) {
        this.minItems = minItems;
        this.maxItems = maxItems;
        this.dependencies = new ArrayList<String>();
        this.dependencies.addAll(dependencies);
        this.weightedRandomChestContents = new ArrayList<WeightedRandomChestContent>();
        this.weightedRandomChestContents.addAll(weightedRandomChestContents);
    }

    public static GenericInventoryGenerator createDefaultGenerator() {
        return new GenericInventoryGenerator(4, 8, Collections.emptyList(), new WeightedRandomChestContent[0]);
    }

    @Override
    public void generateInInventory(Random random, IInventory inventory) {
        int number = this.minItems + random.nextInt(this.maxItems - this.minItems + 1);
        WeightedRandomChestContent[] weightedRandomChestContents = this.weightedRandomChestContents.toArray(new WeightedRandomChestContent[this.weightedRandomChestContents.size()]);
        WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])weightedRandomChestContents, (IInventory)inventory, (int)number);
    }

    @Override
    public void generateInInventorySlot(Random random, IInventory inventory, int slot) {
        WeightedRandomChestContent item = (WeightedRandomChestContent)WeightedRandom.func_76271_a((Random)random, this.weightedRandomChestContents);
        ItemStack[] stacks = ChestGenHooks.generateStacks((Random)random, (ItemStack)item.field_76297_b, (int)item.field_76295_d, (int)item.field_76296_e);
        inventory.func_70299_a(slot, stacks.length > 0 ? stacks[0] : null);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedInfo) {
        list.add(StatCollector.func_74838_a((String)"inventoryGen.custom"));
    }

    @Override
    public boolean openEditGUI(ItemStack stack, EntityPlayer player, int slot) {
        player.openGui((Object)RecurrentComplex.instance, 0, player.func_130014_f_(), slot, 0, 0);
        return true;
    }

    @Override
    public GenericInventoryGenerator copyAsGenericInventoryGenerator() {
        return (GenericInventoryGenerator)this.clone();
    }

    @Override
    public boolean areDependenciesResolved() {
        for (String mod : this.dependencies) {
            if (Loader.isModLoaded((String)mod)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return InventoryGenerationHandler.createInventoryGeneratorFromJSON(InventoryGenerationHandler.createJSONFromInventoryGenerator(this));
    }

    public static class Serializer
    implements JsonDeserializer<GenericInventoryGenerator>,
    JsonSerializer<GenericInventoryGenerator> {
        public GenericInventoryGenerator deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            Integer version;
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "status");
            if (jsonobject.has("version")) {
                version = JsonUtils.getJsonObjectIntegerFieldValue(jsonobject, "version");
            } else {
                version = 1;
                RecurrentComplex.logger.warn("InventoryGen JSON missing 'version', using latest (" + this.getClass() + ")");
            }
            int minItems = JsonUtils.getJsonObjectIntegerFieldValue(jsonobject, "minItems");
            int maxItems = JsonUtils.getJsonObjectIntegerFieldValue(jsonobject, "maxItems");
            JsonArray chestContentsJSON = JsonUtils.getJsonObjectJsonArrayField(jsonobject, "contents");
            ArrayList<WeightedRandomChestContent> chestContents = new ArrayList<WeightedRandomChestContent>();
            for (JsonElement element : chestContentsJSON) {
                WeightedRandomChestContent weightedRandomChestContent = (WeightedRandomChestContent)context.deserialize(element, WeightedRandomChestContent.class);
                chestContents.add(weightedRandomChestContent);
            }
            ArrayList<String> dependencies = new ArrayList<String>();
            if (jsonobject.has("dependencies")) {
                JsonArray dependencyArray = JsonUtils.getJsonObjectJsonArrayField(jsonobject, "dependencies");
                for (JsonElement element : dependencyArray) {
                    dependencies.add(JsonUtils.getJsonElementStringValue(element, "dependency"));
                }
            }
            return new GenericInventoryGenerator(minItems, maxItems, dependencies, chestContents);
        }

        public JsonElement serialize(GenericInventoryGenerator structureInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("version", (Number)1);
            jsonobject.addProperty("minItems", (Number)structureInfo.minItems);
            jsonobject.addProperty("maxItems", (Number)structureInfo.maxItems);
            JsonArray chestContentsJSON = new JsonArray();
            for (WeightedRandomChestContent weightedRandomChestContent : structureInfo.weightedRandomChestContents) {
                chestContentsJSON.add(context.serialize((Object)weightedRandomChestContent, WeightedRandomChestContent.class));
            }
            jsonobject.add("contents", (JsonElement)chestContentsJSON);
            if (structureInfo.dependencies.size() > 0) {
                JsonArray dependencyArray = new JsonArray();
                for (String s : structureInfo.dependencies) {
                    dependencyArray.add(context.serialize((Object)s));
                }
                jsonobject.add("dependencies", (JsonElement)dependencyArray);
            }
            return jsonobject;
        }
    }
}

