/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ivorius.reccomplex.items.GeneratingItem;
import ivorius.reccomplex.json.ItemStackSerializer;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.worldgen.MCRegistrySpecial;
import ivorius.reccomplex.worldgen.inventory.GenericInventoryGenerator;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerator;
import ivorius.reccomplex.worldgen.inventory.InventoryGeneratorSaveHandler;
import ivorius.reccomplex.worldgen.inventory.ModInventoryGeneratorGeneric;
import ivorius.reccomplex.worldgen.inventory.WeightedRandomChestContentSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryGenerationHandler {
    private static Map<String, InventoryGenerator> inventoryGeneratorMap = new HashMap<String, InventoryGenerator>();
    private static Gson gson = InventoryGenerationHandler.createGson();

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericInventoryGenerator.class, (Object)new GenericInventoryGenerator.Serializer());
        builder.registerTypeAdapter(WeightedRandomChestContent.class, (Object)new WeightedRandomChestContentSerializer());
        builder.registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer(MCRegistrySpecial.INSTANCE));
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public static void registerInventoryGenerator(InventoryGenerator inventoryGenerator, String key) {
        if (inventoryGenerator.areDependenciesResolved()) {
            inventoryGeneratorMap.put(key, inventoryGenerator);
        }
    }

    public static void registerInventoryGenerator(ResourceLocation resourceLocation, String key, String modName) {
        GenericInventoryGenerator generator = InventoryGeneratorSaveHandler.readInventoryGenerator(resourceLocation);
        if (generator != null) {
            ModInventoryGeneratorGeneric generatorMod = new ModInventoryGeneratorGeneric(modName, generator);
            InventoryGenerationHandler.registerInventoryGenerator(generatorMod, key);
        }
    }

    public static void registerInventoryHandlers(String modID, String ... names) {
        for (String name : names) {
            InventoryGenerationHandler.registerInventoryGenerator(new ResourceLocation(modID, "structures/inventoryGenerators/" + name + ".json"), name, modID);
        }
    }

    public static InventoryGenerator generator(String key) {
        return inventoryGeneratorMap.get(key);
    }

    public static Set<String> allInventoryGeneratorKeys() {
        return inventoryGeneratorMap.keySet();
    }

    public static void removeGenerator(String key) {
        inventoryGeneratorMap.remove(key);
    }

    public static String createJSONFromInventoryGenerator(GenericInventoryGenerator inventoryGenerator) {
        return gson.toJson((Object)inventoryGenerator, GenericInventoryGenerator.class);
    }

    public static GenericInventoryGenerator createInventoryGeneratorFromJSON(String json) {
        return (GenericInventoryGenerator)gson.fromJson(json, GenericInventoryGenerator.class);
    }

    public static void generateAllTags(IInventory inventory, Random random) {
        ArrayList<ImmutablePair> foundGenerators = new ArrayList<ImmutablePair>();
        boolean didChange = true;
        int cycles = 0;
        do {
            ItemStack stack;
            if (didChange) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    stack = inventory.func_70301_a(i);
                    if (stack == null || !(stack.func_77973_b() instanceof GeneratingItem)) continue;
                    foundGenerators.add(new ImmutablePair((Object)stack, (Object)i));
                    inventory.func_70299_a(i, null);
                }
                didChange = false;
            }
            if (foundGenerators.size() <= 0) continue;
            Pair pair = (Pair)foundGenerators.get(0);
            stack = (ItemStack)pair.getLeft();
            ((GeneratingItem)stack.func_77973_b()).generateInInventory(inventory, random, stack, (Integer)pair.getRight());
            foundGenerators.remove(0);
            didChange = true;
        } while ((foundGenerators.size() > 0 || didChange) && ++cycles < 1000);
    }
}

