/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.KeyInputHandler;
import com.flansmod.client.TickHandlerClient;
import com.flansmod.client.TileEntitySpawnerRenderer;
import com.flansmod.client.debug.EntityDebugAABB;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.debug.RenderDebugAABB;
import com.flansmod.client.debug.RenderDebugVector;
import com.flansmod.client.gui.GuiArmourBox;
import com.flansmod.client.gui.GuiDriveableCrafting;
import com.flansmod.client.gui.GuiDriveableFuel;
import com.flansmod.client.gui.GuiDriveableInventory;
import com.flansmod.client.gui.GuiDriveableMenu;
import com.flansmod.client.gui.GuiDriveableRepair;
import com.flansmod.client.gui.GuiGunBox;
import com.flansmod.client.gui.GuiGunModTable;
import com.flansmod.client.gui.GuiMechaInventory;
import com.flansmod.client.model.RenderAAGun;
import com.flansmod.client.model.RenderBullet;
import com.flansmod.client.model.RenderFlag;
import com.flansmod.client.model.RenderFlagpole;
import com.flansmod.client.model.RenderGrenade;
import com.flansmod.client.model.RenderGun;
import com.flansmod.client.model.RenderMG;
import com.flansmod.client.model.RenderMecha;
import com.flansmod.client.model.RenderNull;
import com.flansmod.client.model.RenderParachute;
import com.flansmod.client.model.RenderPlane;
import com.flansmod.client.model.RenderVehicle;
import com.flansmod.common.CommonProxy;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.network.PacketBuyWeapon;
import com.flansmod.common.network.PacketCraftDriveable;
import com.flansmod.common.network.PacketRepairDriveable;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.TileEntitySpawner;
import com.flansmod.common.tools.EntityParachute;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    public static String modelDir = "com.flansmod.client.model.";
    public static RenderGun gunRenderer;
    public List<File> contentPacks;

    @Override
    public void load() {
        new FlansModClient().load();
        gunRenderer = new RenderGun();
        for (GunType gunType : GunType.guns) {
            if (gunType.model == null) continue;
            MinecraftForgeClient.registerItemRenderer((Item)gunType.item, (IItemRenderer)gunRenderer);
        }
        FMLCommonHandler.instance().bus().register((Object)new KeyInputHandler());
        new TickHandlerClient();
    }

    @Override
    public void forceReload() {
        Minecraft.func_71410_x().func_110436_a();
    }

    @Override
    public List<File> getContentList(Method method, ClassLoader classloader) {
        this.contentPacks = new ArrayList<File>();
        for (File file : FlansMod.flanDir.listFiles()) {
            if (!file.isDirectory() && !zipJar.matcher(file.getName()).matches()) continue;
            try {
                method.invoke((Object)classloader, file.toURI().toURL());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("modid", "FlansMod");
                map.put("name", "Flan's Mod : " + file.getName());
                map.put("version", "1");
                FMLModContainer container = new FMLModContainer("com.flansmod.common.FlansMod", new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                container.bindMetadata(MetadataCollection.from(null, (String)""));
                FMLClientHandler.instance().addModAsResource((ModContainer)container);
            }
            catch (Exception e) {
                FlansMod.log("Failed to load images for content pack : " + file.getName());
                e.printStackTrace();
            }
            FlansMod.log("Loaded content pack : " + file.getName());
            this.contentPacks.add(file);
        }
        FlansMod.log("Loaded textures and models.");
        return this.contentPacks;
    }

    @Override
    public List<File> getContentList() {
        return this.contentPacks;
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, (Render)new RenderBullet());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderGrenade());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlane.class, (Render)new RenderPlane());
        RenderingRegistry.registerEntityRenderingHandler(EntityVehicle.class, (Render)new RenderVehicle());
        RenderingRegistry.registerEntityRenderingHandler(EntityAAGun.class, (Render)new RenderAAGun());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlagpole.class, (Render)new RenderFlagpole());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlag.class, (Render)new RenderFlag());
        RenderingRegistry.registerEntityRenderingHandler(EntitySeat.class, (Render)new RenderNull());
        RenderingRegistry.registerEntityRenderingHandler(EntityWheel.class, (Render)new RenderNull());
        RenderingRegistry.registerEntityRenderingHandler(EntityMG.class, (Render)new RenderMG());
        RenderingRegistry.registerEntityRenderingHandler(EntityParachute.class, (Render)new RenderParachute());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugVector.class, (Render)new RenderDebugVector());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugAABB.class, (Render)new RenderDebugAABB());
        RenderingRegistry.registerEntityRenderingHandler(EntityMecha.class, (Render)new RenderMecha());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySpawner.class, (TileEntitySpecialRenderer)new TileEntitySpawnerRenderer());
    }

    @Override
    public void doTutorialStuff(EntityPlayer player, EntityDriveable entityType) {
        if (!FlansModClient.doneTutorial) {
            FlansModClient.doneTutorial = true;
            player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.inventoryKey.func_151463_i()) + " to open the menu"));
            player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i()) + " to get out"));
            player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.controlSwitchKey.func_151463_i()) + " to switch controls"));
            player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.trimKey.func_151463_i()) + " to reposition the vehicle"));
            if (entityType instanceof EntityPlane) {
                if (PlaneType.getPlane((String)((EntityPlane)entityType).driveableType).hasGear) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.gearKey.func_151463_i()) + " to switch the gear"));
                }
                if (PlaneType.getPlane((String)((EntityPlane)entityType).driveableType).hasDoor) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.doorKey.func_151463_i()) + " to switch the doors"));
                }
                if (PlaneType.getPlane((String)((EntityPlane)entityType).driveableType).hasWing) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.wingKey.func_151463_i()) + " to switch the wings"));
                }
            }
        }
    }

    @Override
    public void changeControlMode(EntityPlayer player) {
        if (FlansModClient.flipControlMode()) {
            player.func_146105_b((IChatComponent)new ChatComponentText("Mouse Control mode is now set to " + FlansModClient.controlModeMouse));
        }
    }

    @Override
    public boolean mouseControlEnabled() {
        return FlansModClient.controlModeMouse;
    }

    @Override
    public void playBlockBreakSound(int x, int y, int z, Block block) {
        super.playBlockBreakSound(x, y, z, block);
    }

    @Override
    public void tick() {
    }

    @Override
    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID >= 6 && ID <= 10 && (EntitySeat)player.field_70154_o == null) {
            return null;
        }
        switch (ID) {
            case 0: {
                return new GuiDriveableCrafting(player.field_71071_by, world, x, y, z);
            }
            case 1: {
                return new GuiDriveableRepair(player);
            }
            case 2: {
                return new GuiGunModTable(player.field_71071_by, world);
            }
            case 5: {
                return new GuiGunBox(player.field_71071_by, ((BlockGunBox)world.func_147439_a((int)x, (int)y, (int)z)).type);
            }
            case 6: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 0);
            }
            case 7: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 1);
            }
            case 8: {
                return new GuiDriveableFuel(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable);
            }
            case 9: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 2);
            }
            case 10: {
                return new GuiMechaInventory(player.field_71071_by, world, (EntityMecha)((EntitySeat)player.field_70154_o).driveable);
            }
            case 11: {
                return new GuiArmourBox(player.field_71071_by, ((BlockArmourBox)world.func_147439_a((int)x, (int)y, (int)z)).type);
            }
        }
        return null;
    }

    @Override
    public void openDriveableMenu(EntityPlayer player, World world, EntityDriveable driveable) {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiDriveableMenu(player.field_71071_by, world, driveable));
    }

    private String getModelName(String in) {
        String[] split = in.split("\\.");
        if (split.length == 1) {
            return "Model" + in;
        }
        if (split.length > 1) {
            String out = "Model" + split[split.length - 1];
            for (int i = split.length - 2; i >= 0; --i) {
                out = split[i] + "." + out;
            }
            return out;
        }
        return in;
    }

    @Override
    public <T> T loadModel(String s, String shortName, Class<T> typeClass) {
        if (s == null || shortName == null) {
            return null;
        }
        try {
            return typeClass.cast(Class.forName(modelDir + this.getModelName(s)).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            FlansMod.log("Failed to load model : " + shortName + " (" + s + ")");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadSound(String contentPack, String type, String sound) {
        FlansModResourceHandler.getSound(sound);
    }

    @Override
    public boolean isThePlayer(EntityPlayer player) {
        return player == FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public void buyGun(GunBoxType type, int gun) {
        FlansMod.getPacketHandler().sendToServer(new PacketBuyWeapon(type, 0, gun));
        FlansModClient.shootTime = 10;
    }

    @Override
    public void buyAmmo(GunBoxType box, int ammo, int type) {
        FlansMod.getPacketHandler().sendToServer(new PacketBuyWeapon(box, type, ammo));
        FlansModClient.shootTime = 10;
    }

    @Override
    public void craftDriveable(EntityPlayer player, DriveableType type) {
        super.craftDriveable(player, type);
        if (player.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketCraftDriveable(type.shortName));
        }
    }

    @Override
    public void repairDriveable(EntityPlayer driver, EntityDriveable driving, DriveablePart part) {
        super.repairDriveable(driver, driving, part);
        if (driver.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketRepairDriveable(part.type));
        }
    }

    @Override
    public boolean isScreenOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    @Override
    public boolean isKeyDown(int key) {
        switch (key) {
            case 0: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151463_i());
            }
            case 1: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151463_i());
            }
            case 2: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151463_i());
            }
            case 3: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151463_i());
            }
        }
        return false;
    }

    @Override
    public boolean keyDown(int keyCode) {
        boolean state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        return state;
    }
}

