/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.PlayerData;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.teams.TeamsManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PlayerHandler {
    public static Map<String, PlayerData> serverSideData = new HashMap<String, PlayerData>();
    public static Map<String, PlayerData> clientSideData = new HashMap<String, PlayerData>();
    public static ArrayList<String> clientsToRemoveAfterThisRound = new ArrayList();

    public PlayerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (event instanceof LivingHurtEvent && (entity.field_70154_o instanceof EntityDriveable || entity.field_70154_o instanceof EntitySeat)) {
            event.ammount = 0.0f;
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            PlayerHandler.getPlayerData((EntityPlayer)entity).playerKilled();
        }
    }

    public void tick() {
        for (PlayerData d : serverSideData.values()) {
            d.tick();
        }
        for (PlayerData d : clientSideData.values()) {
            d.tick();
        }
    }

    public static PlayerData getPlayerData(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerData(player.func_70005_c_(), Side.SERVER);
    }

    public static PlayerData getPlayerData(String username) {
        return PlayerHandler.getPlayerData(username, Side.SERVER);
    }

    public static PlayerData getPlayerData(EntityPlayer player, Side side) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerData(player.func_70005_c_(), side);
    }

    public static PlayerData getPlayerData(String username, Side side) {
        if (side.isClient()) {
            if (!clientSideData.containsKey(username)) {
                clientSideData.put(username, new PlayerData(username));
            }
        } else if (!serverSideData.containsKey(username)) {
            serverSideData.put(username, new PlayerData(username));
        }
        return side.isClient() ? clientSideData.get(username) : serverSideData.get(username);
    }

    @SubscribeEvent
    public void onPlayerEvent(PlayerEvent event) {
        if (event instanceof PlayerEvent.PlayerLoggedInEvent) {
            EntityPlayer player = event.player;
            String username = player.func_70005_c_();
            if (!serverSideData.containsKey(username)) {
                serverSideData.put(username, new PlayerData(username));
            }
            if (clientsToRemoveAfterThisRound.contains(username)) {
                clientsToRemoveAfterThisRound.remove(username);
            }
        } else if (event instanceof PlayerEvent.PlayerLoggedOutEvent) {
            EntityPlayer player = event.player;
            String username = player.func_70005_c_();
            if (TeamsManager.getInstance().currentRound == null) {
                serverSideData.remove(username);
            } else {
                clientsToRemoveAfterThisRound.add(username);
            }
        }
    }

    public static void roundEnded() {
        for (String username : clientsToRemoveAfterThisRound) {
            serverSideData.remove(username);
        }
    }
}

