/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IControllable;
import com.flansmod.api.IExplodeable;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.CollisionPoint;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableKeyHeld;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class EntityDriveable
extends Entity
implements IControllable,
IExplodeable,
IEntityAdditionalSpawnData {
    public boolean syncFromServer = true;
    public int serverPositionTransitionTicker;
    public double field_70118_ct;
    public double field_70117_cu;
    public double field_70116_cv;
    public double serverYaw;
    public double serverPitch;
    public double serverRoll;
    public DriveableData driveableData;
    public String driveableType;
    public float throttle;
    public boolean fuelling;
    public float prevRotationRoll;
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean leftMouseHeld = false;
    public boolean rightMouseHeld = false;
    public RotatedAxes prevAxes;
    public RotatedAxes axes = new RotatedAxes();
    public EntitySeat[] seats;

    public EntityDriveable(World world) {
        super(world);
        this.prevAxes = new RotatedAxes();
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70129_M = 0.375f;
        this.field_70158_ak = true;
        this.field_70155_l = 200.0;
    }

    public EntityDriveable(World world, DriveableType t, DriveableData d) {
        this(world);
        this.driveableType = t.shortName;
        this.driveableData = d;
    }

    protected void initType(DriveableType type, boolean clientSide) {
        this.seats = new EntitySeat[type.numPassengers + 1];
        for (int i = 0; i < type.numPassengers + 1; ++i) {
            if (clientSide) continue;
            this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.seats[i]);
        }
        this.field_70129_M = type.yOffset;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        this.driveableData.writeToNBT(tag);
        tag.func_74778_a("Type", this.driveableType);
        tag.func_74776_a("RotationYaw", this.axes.getYaw());
        tag.func_74776_a("RotationPitch", this.axes.getPitch());
        tag.func_74776_a("RotationRoll", this.axes.getRoll());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.driveableType = tag.func_74779_i("Type");
        this.driveableData = new DriveableData(tag);
        this.initType(DriveableType.getDriveable(this.driveableType), false);
        this.field_70126_B = tag.func_74760_g("RotationYaw");
        this.field_70127_C = tag.func_74760_g("RotationPitch");
        this.prevRotationRoll = tag.func_74760_g("RotationRoll");
        this.axes = new RotatedAxes(this.field_70126_B, this.field_70127_C, this.prevRotationRoll);
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.driveableType);
        NBTTagCompound tag = new NBTTagCompound();
        this.driveableData.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
        data.writeFloat(this.axes.getYaw());
        data.writeFloat(this.axes.getPitch());
        data.writeFloat(this.axes.getRoll());
        for (EnumDriveablePart ep : EnumDriveablePart.values()) {
            DriveablePart part = this.getDriveableData().parts.get((Object)ep);
            data.writeShort((int)((short)part.health));
            data.writeBoolean(part.onFire);
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.driveableType = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.driveableData = new DriveableData(ByteBufUtils.readTag((ByteBuf)data));
            this.initType(this.getDriveableType(), true);
            this.axes.setAngles(data.readFloat(), data.readFloat(), data.readFloat());
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                part.health = data.readShort();
                part.onFire = data.readBoolean();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retreive plane type from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
    }

    @Override
    public abstract void onMouseMoved(int var1, int var2);

    protected boolean canSit(int seat) {
        return this.getDriveableType().numPassengers >= seat && this.seats[seat].field_70153_n == null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return -0.3;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.func_70106_y();
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
        if (!this.isPartOfThis(entity)) {
            super.func_70108_f(entity);
        }
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (this.field_70173_aa > 1) {
            return;
        }
        if (!(this.field_70153_n instanceof EntityPlayer) || !FlansMod.proxy.isThePlayer((EntityPlayer)this.field_70153_n)) {
            if (this.syncFromServer) {
                this.serverPositionTransitionTicker = i + 5;
            } else {
                double var10 = d - this.field_70165_t;
                double var12 = d1 - this.field_70163_u;
                double var14 = d2 - this.field_70161_v;
                double var16 = var10 * var10 + var12 * var12 + var14 * var14;
                if (var16 <= 1.0) {
                    return;
                }
                this.serverPositionTransitionTicker = 3;
            }
            this.field_70118_ct = d;
            this.field_70117_cu = d1;
            this.field_70116_cv = d2;
            this.serverYaw = f;
            this.serverPitch = f1;
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70118_ct = x;
            this.field_70117_cu = y;
            this.field_70116_cv = z;
            this.serverYaw = yaw;
            this.serverPitch = pitch;
            this.serverRoll = roll;
            this.serverPositionTransitionTicker = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.field_70126_B = yaw;
            this.field_70127_C = pitch;
            this.prevRotationRoll = roll;
            this.setRotation(yaw, pitch, roll);
        }
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
        this.angularVelocity = new Vector3f(velYaw, velPitch, velRoll);
        this.throttle = throt;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
    }

    @Override
    public abstract boolean pressKey(int var1, EntityPlayer var2);

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKeyHeld(key, held));
        }
        switch (key) {
            case 9: {
                this.leftMouseHeld = held;
                break;
            }
            case 8: {
                this.rightMouseHeld = held;
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.getDriveableType().numPassengers + 1; ++i) {
                if (this.seats[i] != null && this.seats[i].field_70175_ag) continue;
                this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.seats[i]);
            }
        }
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            Vector3f pos;
            if (part.box == null) continue;
            part.update(this);
            if (this.field_70170_p.field_72995_K) {
                if (part.onFire) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.w / 16.0f, (float)part.box.y / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.h / 16.0f, (float)part.box.z / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.d / 16.0f));
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
                if (part.health > 0 && part.health < part.maxHealth / 2) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.w / 16.0f, (float)part.box.y / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.h / 16.0f, (float)part.box.z / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.d / 16.0f));
                    this.field_70170_p.func_72869_a(part.health < part.maxHealth / 4 ? "largesmoke" : "smoke", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
            }
            if (part.onFire) {
                if (this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(40) == 0) {
                    part.onFire = false;
                }
                pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
                if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))).func_149688_o() != Material.field_151586_h) continue;
                part.onFire = false;
                continue;
            }
            pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
            if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))).func_149688_o() != Material.field_151587_i) continue;
            part.onFire = true;
        }
        this.checkParts();
        this.field_70126_B = this.axes.getYaw();
        this.field_70127_C = this.axes.getPitch();
        this.prevRotationRoll = this.axes.getRoll();
        this.prevAxes = this.axes.clone();
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
        if (this.field_70153_n != null && this.field_70128_L) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70143_R = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n == null) {
            this.throttle *= 0.9f;
        }
    }

    protected void func_70069_a(float k) {
        if (k <= 0.0f) {
            return;
        }
        super.func_70069_a(k);
        int i = MathHelper.func_76123_f((float)(k - 3.0f));
        if (i > 0) {
            if (i > 4) {
                this.func_85030_a("damage.fallbig", 1.0f, 1.0f);
            } else {
                this.func_85030_a("damage.fallsmall", 1.0f, 1.0f);
            }
            this.func_70097_a(DamageSource.field_76379_h, i);
            Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), MathHelper.func_76128_c((double)this.field_70161_v));
            if (block != null) {
                Block.SoundType stepSound = block.field_149762_H;
                this.func_85030_a(stepSound.func_150498_e(), stepSound.func_150497_c() * 0.5f, stepSound.func_150494_d() * 0.75f);
            }
        }
    }

    public Vector3f rotate(Vector3f inVec) {
        return this.axes.findLocalVectorGlobally(inVec);
    }

    public Vector3f rotate(Vec3 inVec) {
        return this.rotate(inVec.field_72450_a, inVec.field_72448_b, inVec.field_72449_c);
    }

    public Vector3f rotate(double x, double y, double z) {
        return this.rotate(new Vector3f((float)x, (float)y, (float)z));
    }

    public void rotateYaw(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalYaw(rotateBy);
        this.updatePrevAngles();
    }

    public void rotatePitch(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalPitch(rotateBy);
        this.updatePrevAngles();
    }

    public void rotateRoll(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalRoll(rotateBy);
        this.updatePrevAngles();
    }

    public void updatePrevAngles() {
        double dRoll;
        double dPitch;
        double dYaw = this.axes.getYaw() - this.field_70126_B;
        if (dYaw > 180.0) {
            this.field_70126_B += 360.0f;
        }
        if (dYaw < -180.0) {
            this.field_70126_B -= 360.0f;
        }
        if ((dPitch = (double)(this.axes.getPitch() - this.field_70127_C)) > 180.0) {
            this.field_70127_C += 360.0f;
        }
        if (dPitch < -180.0) {
            this.field_70127_C -= 360.0f;
        }
        if ((dRoll = (double)(this.axes.getRoll() - this.prevRotationRoll)) > 180.0) {
            this.prevRotationRoll += 360.0f;
        }
        if (dRoll < -180.0) {
            this.prevRotationRoll -= 360.0f;
        }
    }

    public void setRotation(float rotYaw, float rotPitch, float rotRoll) {
        this.axes.setAngles(rotYaw, rotPitch, rotRoll);
    }

    public boolean isPartOfThis(Entity ent) {
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            if (ent == seat) {
                return true;
            }
            if (seat.field_70153_n != ent) continue;
            return true;
        }
        return ent == this;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public DriveableType getDriveableType() {
        return DriveableType.getDriveable(this.driveableType);
    }

    public DriveableData getDriveableData() {
        return this.driveableData;
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    @Override
    public Entity getControllingEntity() {
        return this.seats[0].getControllingEntity();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(this.getDriveableType().item, 1, 0);
        stack.field_77990_d = new NBTTagCompound();
        this.driveableData.writeToNBT(stack.field_77990_d);
        return stack;
    }

    public boolean hasFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].field_70153_n == null) {
            return false;
        }
        if (this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.driveableData.fuelInTank > 0.0f;
    }

    public boolean hasEnoughFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].field_70153_n == null) {
            return false;
        }
        if (this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.driveableData.fuelInTank > this.driveableData.engine.fuelConsumption * this.throttle;
    }

    public double getSpeedXYZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public double getKineticEnergy() {
        return 0.5 * (double)this.getDriveableType().mass * this.getSpeedXYZ();
    }

    public void applyForce(Vector3f forceOrigin, Vector3f forceVector) {
        this.applyTranslationalForce(forceOrigin, forceVector);
        this.applyRotationalForce(forceOrigin, forceVector);
    }

    public void applyRotationalForce(Vector3f forceOrigin, Vector3f forceVector) {
        Vector3f torqueVector = Vector3f.cross((Vector3f)forceVector.scale(1.0f), forceOrigin, null);
        this.applyTorque(torqueVector);
    }

    public void applyTorque(Vector3f torqueVector) {
        float deltaTime = 0.05f;
        float momentOfInertia = this.getDriveableType().momentOfInertia / (float)(this.landVehicle() ? 250 : 100);
        Vector3f.add(this.angularVelocity, (Vector3f)torqueVector.scale(deltaTime * 1.0f / momentOfInertia), this.angularVelocity);
    }

    public void applyTranslationalForce(Vector3f forceOrigin, Vector3f forceVector) {
        float deltaTime = 0.05f;
        Vector3f accelerationVector = (Vector3f)forceVector.scale(1.0f / this.getDriveableType().mass);
        this.field_70159_w += (double)(accelerationVector.x * deltaTime);
        this.field_70181_x += (double)(accelerationVector.y * deltaTime);
        this.field_70179_y += (double)(accelerationVector.z * deltaTime);
    }

    public void moveDriveable() {
        ArrayList aabbs;
        Block block;
        Vector3f newOrigin;
        Vector3f origin;
        Vector3f newPointVec;
        Vector3f pointVec;
        float deltaTime = 0.05f;
        DriveableType type = this.getDriveableType();
        Vector3f position = new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
        Vector3f motion = new Vector3f((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y);
        if (this.field_70170_p.field_72995_K && FlansMod.DEBUG) {
            this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, position, motion, 2, 0.0f, 0.0f, 1.0f));
            this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, position, (Vector3f)new Vector3f(this.angularVelocity).scale(0.1f), 2, 1.0f, 0.0f, 1.0f));
        }
        RotatedAxes newAxes = this.axes.clone();
        if ((double)Math.abs(this.angularVelocity.lengthSquared()) > 1.0E-8) {
            newAxes.rotateLocal(this.angularVelocity.length() * deltaTime, (Vector3f)new Vector3f(this.angularVelocity).normalise());
        }
        int numHits = 0;
        for (CollisionPoint point : type.points) {
            MovingObjectPosition hit;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            newPointVec = newAxes.findLocalVectorGlobally(point.getLocalVector());
            origin = Vector3f.add(position, pointVec, null);
            newOrigin = Vector3f.add(position, newPointVec, null);
            Vector3f rayOrigin = Vector3f.sub(newOrigin, motion, null);
            Vector3f ray = Vector3f.add(newOrigin, motion, null);
            if (this.field_70170_p.field_72995_K && FlansMod.DEBUG) {
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, origin, (Vector3f)Vector3f.sub(ray, origin, null).scale(1.0f), 2, 1.0f, 0.0f, 0.0f));
            }
            if ((hit = this.field_70170_p.func_72933_a(rayOrigin.toVec3(), ray.toVec3())) == null) continue;
            ++numHits;
        }
        if (numHits > 0) {
            for (CollisionPoint point : type.points) {
                if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
                pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
                newPointVec = newAxes.findLocalVectorGlobally(point.getLocalVector());
                origin = Vector3f.add(position, pointVec, null);
                newOrigin = Vector3f.add(position, newPointVec, null);
                Vector3f ray = Vector3f.add(newOrigin, motion, null);
                MovingObjectPosition hit = this.field_70170_p.func_72933_a(newOrigin.toVec3(), ray.toVec3());
                if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
                Vector3f hitVec = new Vector3f(hit.field_72307_f);
                Vector3f normal = null;
                int x = 0;
                int y = 0;
                int z = 0;
                switch (hit.field_72310_e) {
                    case 0: {
                        normal = new Vector3f(0.0f, -1.0f, 0.0f);
                        y = -1;
                        break;
                    }
                    case 1: {
                        normal = new Vector3f(0.0f, 1.0f, 0.0f);
                        y = 1;
                        break;
                    }
                    case 2: {
                        normal = new Vector3f(0.0f, 0.0f, -1.0f);
                        z = 1;
                        break;
                    }
                    case 3: {
                        normal = new Vector3f(0.0f, 0.0f, 1.0f);
                        z = -1;
                        break;
                    }
                    case 4: {
                        normal = new Vector3f(-1.0f, 0.0f, 0.0f);
                        x = 1;
                        break;
                    }
                    case 5: {
                        normal = new Vector3f(1.0f, 0.0f, 0.0f);
                        x = -1;
                    }
                }
                if (this.field_70170_p.isSideSolid(hit.field_72311_b + x, hit.field_72312_c + y, hit.field_72309_d + z, ForgeDirection.getOrientation((int)hit.field_72310_e).getOpposite())) continue;
                if (this.field_70170_p.field_72995_K && FlansMod.DEBUG) {
                    this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, hitVec, normal, 2, 0.0f, 1.0f, 0.0f));
                }
                float normalReactionMagnitude = Vector3f.dot(normal.negate(null), Vector3f.sub(ray, hitVec, null));
                float forceMagnitude = type.mass * normalReactionMagnitude / ((float)numHits * deltaTime);
                boolean shouldApplyForce = true;
                float damagePoint = 1.0f;
                float damageModifier = 5.0f;
                float blockDamageModifier = 50.0f;
                if (forceMagnitude > damagePoint * type.mass) {
                    float smashyForce = forceMagnitude - damagePoint * type.mass;
                    DriveablePart part = this.getDriveableData().parts.get((Object)point.part);
                    float smashyForceVsBlock = blockDamageModifier * part.smashIntoGround(this, damageModifier * smashyForce);
                    Block blockHit = this.field_70170_p.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    float blockHardness = blockHit.func_149712_f(this.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    if (TeamsManager.driveablesBreakBlocks && smashyForceVsBlock > blockHardness && blockHardness >= 0.0f) {
                        blockHit.func_149697_b(this.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, this.field_70170_p.func_72805_g(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d), 1);
                        FlansMod.proxy.playBlockBreakSound(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, blockHit);
                        this.field_70170_p.func_147468_f(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                        shouldApplyForce = false;
                    }
                }
                if (!shouldApplyForce) continue;
                this.applyForce(pointVec, (Vector3f)normal.scale(forceMagnitude));
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        if ((double)Math.abs(this.angularVelocity.lengthSquared()) > 1.0E-8) {
            this.axes.rotateGlobal(this.angularVelocity.length() * deltaTime, (Vector3f)new Vector3f(this.angularVelocity).normalise());
        }
        numHits = 0;
        for (CollisionPoint point : type.points) {
            int blockZ;
            int blockY;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            int blockX = MathHelper.func_76128_c((double)(this.field_70165_t + (double)pointVec.x));
            block = this.field_70170_p.func_147439_a(blockX, blockY = MathHelper.func_76128_c((double)(this.field_70163_u + (double)pointVec.y)), blockZ = MathHelper.func_76128_c((double)(this.field_70161_v + (double)pointVec.z)));
            if (block == null) continue;
            aabbs = new ArrayList();
            block.func_149743_a(this.field_70170_p, blockX, blockY, blockZ, AxisAlignedBB.func_72330_a((double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z), (double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z)), aabbs, (Entity)this);
            if (aabbs.size() <= 0) continue;
            ++numHits;
        }
        for (CollisionPoint point : type.points) {
            int blockZ;
            int blockY;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            int blockX = MathHelper.func_76128_c((double)(this.field_70165_t + (double)pointVec.x));
            block = this.field_70170_p.func_147439_a(blockX, blockY = MathHelper.func_76128_c((double)(this.field_70163_u + (double)pointVec.y)), blockZ = MathHelper.func_76128_c((double)(this.field_70161_v + (double)pointVec.z)));
            if (block == null) continue;
            aabbs = new ArrayList();
            block.func_149743_a(this.field_70170_p, blockX, blockY, blockZ, AxisAlignedBB.func_72330_a((double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z), (double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z)), aabbs, (Entity)this);
            if (aabbs.size() <= 0) continue;
            AxisAlignedBB aabb = (AxisAlignedBB)aabbs.get(0);
            double dminX = Math.abs(this.field_70165_t + (double)pointVec.x - aabb.field_72340_a);
            double dmaxX = Math.abs(this.field_70165_t + (double)pointVec.x - aabb.field_72336_d);
            double dminY = Math.abs(this.field_70163_u + (double)pointVec.y - aabb.field_72338_b);
            double dmaxY = Math.abs(this.field_70163_u + (double)pointVec.y - aabb.field_72337_e);
            double dminZ = Math.abs(this.field_70161_v + (double)pointVec.z - aabb.field_72339_c);
            double dmaxZ = Math.abs(this.field_70161_v + (double)pointVec.z - aabb.field_72334_f);
            double min = Math.min(Math.min(Math.min(dminX, dmaxX), Math.min(dminY, dmaxY)), Math.min(dminZ, dmaxZ));
            float pushiness = 1.0f;
            float bounciness = type.bounciness;
            this.applyForce(pointVec, new Vector3f(0.0f, (float)dmaxY * type.mass / (deltaTime * (float)numHits) * type.bounciness, 0.0f));
        }
        this.checkParts();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean landVehicle() {
        return false;
    }

    public boolean gearDown() {
        return true;
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public boolean attackPoint(CollisionPoint point, DamageSource damagesource, float i) {
        return false;
    }

    public boolean attackFromBullet(EntityBullet bullet, Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (!part.rayTrace(this, bullet, rotatedPosVector, rotatedMotVector)) continue;
            if (this.field_70170_p.field_72995_K) {
                return true;
            }
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, this.field_71093_bK);
            return true;
        }
        return false;
    }

    public DriveablePart raytraceParts(Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (!part.rayTrace(this, null, rotatedPosVector, rotatedMotVector)) continue;
            return part;
        }
        return null;
    }

    public boolean canHitPart(EnumDriveablePart part) {
        return true;
    }

    public void checkParts() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || part.health > 0 || part.maxHealth <= 0) continue;
            this.killPart(part);
        }
        for (EntitySeat seat : this.seats) {
        }
        if (this.getDriveableData().parts.get((Object)((Object)EnumDriveablePart.core)).dead) {
            this.func_70106_y();
        }
    }

    private void killPart(DriveablePart part) {
        if (part.dead) {
            return;
        }
        part.health = 0;
        part.dead = true;
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> drops;
            Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
            if (part.box != null) {
                pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
            }
            if ((drops = type.getItemsRequired(part, this.getDriveableData().engine)) != null) {
                for (ItemStack stack : drops) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, stack.func_77946_l()));
                }
            }
            this.dropItemsOnPartDeath(pos, part);
            if (part.type == EnumDriveablePart.core) {
                for (int i = 0; i < this.getDriveableData().func_70302_i_(); ++i) {
                    ItemStack stack;
                    stack = this.getDriveableData().func_70301_a(i);
                    if (stack == null) continue;
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian(), stack));
                }
            }
        }
        for (EnumDriveablePart child : part.type.getChildren()) {
            this.killPart(this.getDriveableData().parts.get((Object)child));
        }
    }

    protected abstract void dropItemsOnPartDeath(Vector3f var1, DriveablePart var2);

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    public void explode() {
    }

    @Override
    public float getCameraDistance() {
        return this.getDriveableType().cameraDistance;
    }

    public boolean isPartIntact(EnumDriveablePart part) {
        DriveablePart thisPart = this.getDriveableData().parts.get((Object)part);
        return thisPart.maxHealth == 0 || thisPart.health > 0;
    }

    public abstract boolean hasMouseControlMode();

    public abstract String getBombInventoryName();

    public boolean rotateWithTurret(Seat seat) {
        return seat.part == EnumDriveablePart.turret;
    }

    public String func_70005_c_() {
        return this.getDriveableType().name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat == 0 ? !FlansModClient.controlModeMouse : true;
    }
}

