/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.network.PacketDriveableControl;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketPlaneControl;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityPlane
extends EntityDriveable {
    public float flapsYaw;
    public float flapsPitchLeft;
    public float flapsPitchRight;
    public int soundPosition;
    public float propAngle;
    public int bombDelay;
    public int gunDelay;
    public int ticksSinceUsed = 0;
    public boolean varGear = true;
    public boolean varDoor = false;
    public boolean varWing = false;
    public int toggleTimer = 0;

    public EntityPlane(World world) {
        super(world);
    }

    public EntityPlane(World world, double x, double y, double z, PlaneType type, DriveableData data) {
        super(world, type, data);
        this.func_70107_b(x, y, z);
        this.initType(type, false);
    }

    public EntityPlane(World world, double x, double y, double z, EntityPlayer placer, PlaneType type, DriveableData data) {
        this(world, x, y, z, type, data);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.rotatePitch(type.restingPitch);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("VarGear", this.varGear);
        tag.func_74757_a("VarDoor", this.varDoor);
        tag.func_74757_a("VarWing", this.varWing);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varGear = tag.func_74767_n("VarGear");
        this.varDoor = tag.func_74767_n("VarDoor");
        this.varWing = tag.func_74767_n("VarWing");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        if (!FlansMod.proxy.mouseControlEnabled()) {
            return;
        }
        float sensitivity = 0.02f;
        this.flapsPitchLeft -= sensitivity * (float)deltaY;
        this.flapsPitchRight -= sensitivity * (float)deltaY;
        this.flapsPitchLeft -= sensitivity * (float)deltaX;
        this.flapsPitchRight += sensitivity * (float)deltaX;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        PlaneType type = this.getPlaneType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            if (i == 0) {
                this.bombDelay = type.planeBombDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        PlaneType type = this.getPlaneType();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        switch (key) {
            case 0: {
                this.throttle += 0.01f;
                if (this.throttle > 1.0f) {
                    this.throttle = 1.0f;
                }
                return true;
            }
            case 1: {
                this.throttle -= 0.01f;
                if (this.throttle < -1.0f) {
                    this.throttle = -1.0f;
                }
                if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                    this.throttle = 0.0f;
                }
                return true;
            }
            case 2: {
                this.flapsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.flapsYaw += 1.0f;
                return true;
            }
            case 4: {
                this.flapsPitchLeft += 1.0f;
                this.flapsPitchRight += 1.0f;
                return true;
            }
            case 5: {
                this.flapsPitchLeft -= 1.0f;
                this.flapsPitchRight -= 1.0f;
                return true;
            }
            case 6: {
                this.seats[0].field_70153_n.func_70078_a(null);
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K && (type.invInflight || Math.abs(this.throttle) < 0.1f && this.field_70122_E)) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.seats[0].field_70153_n, this.field_70170_p, this);
                }
                return true;
            }
            case 8: {
                if (!this.field_70170_p.field_72995_K && this.bombDelay <= 0 && TeamsManager.bombsEnabled) {
                    int slot = -1;
                    boolean bombType = false;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ItemStack bomb = this.driveableData.func_70301_a(i);
                        if (bomb == null || !(bomb.func_77973_b() instanceof ItemBullet) || !((ItemBullet)bomb.func_77973_b()).type.isBomb) continue;
                        slot = i;
                    }
                    if (slot != -1) {
                        Vec3 bombVec = this.rotate(type.bombPosition).toVec3();
                        this.field_70170_p.func_72838_d((Entity)((ItemBullet)this.driveableData.func_70301_a(slot).func_77973_b()).getEntity(this.field_70170_p, bombVec.func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.axes.getYaw(), this.axes.getPitch(), this.field_70159_w, this.field_70181_x, this.field_70179_y, (EntityLivingBase)((EntityLiving)this.field_70153_n), 1.0f, this.driveableData.func_70301_a(slot).func_77960_j(), type));
                        if (type.shootSecondarySound != null) {
                            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSecondarySound, false);
                        }
                        if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                            this.driveableData.func_70298_a(slot, 1);
                        }
                        this.bombDelay = type.planeBombDelay;
                    }
                    return true;
                }
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                FlansMod.proxy.changeControlMode((EntityPlayer)this.seats[0].field_70153_n);
                return true;
            }
            case 11: {
                this.flapsPitchLeft += 1.0f;
                this.flapsPitchRight -= 1.0f;
                return true;
            }
            case 12: {
                this.flapsPitchLeft -= 1.0f;
                this.flapsPitchRight += 1.0f;
                return true;
            }
            case 13: {
                if (this.toggleTimer <= 0) {
                    this.varGear = !this.varGear;
                    player.func_145747_a((IChatComponent)new ChatComponentText("Landing gear " + (this.varGear ? "down" : "up")));
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Doors " + (this.varDoor ? "open" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 15: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varWing = !this.varWing;
                    if (type.hasWing) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Toggling wings"));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableControl(this));
                }
                return true;
            }
            case 16: {
                this.axes.setAngles(this.axes.getYaw(), 0.0f, 0.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        PlaneType type = this.getPlaneType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Plane type null. Not ticking plane");
            return;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.planeLife > 0 && this.ticksSinceUsed > TeamsManager.planeLife * 20) {
            this.func_70106_y();
        }
        if (this.bombDelay > 0) {
            --this.bombDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.hasEnoughFuel()) {
            this.propAngle += this.throttle / 7.0f;
        }
        this.flapsYaw *= 0.9f;
        this.flapsPitchLeft *= 0.9f;
        this.flapsPitchRight *= 0.9f;
        if (this.flapsYaw > 20.0f) {
            this.flapsYaw = 20.0f;
        }
        if (this.flapsYaw < -20.0f) {
            this.flapsYaw = -20.0f;
        }
        if (this.flapsPitchRight > 20.0f) {
            this.flapsPitchRight = 20.0f;
        }
        if (this.flapsPitchRight < -20.0f) {
            this.flapsPitchRight = -20.0f;
        }
        if (this.flapsPitchLeft > 20.0f) {
            this.flapsPitchLeft = 20.0f;
        }
        if (this.flapsPitchLeft < -20.0f) {
            this.flapsPitchLeft = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        float sensitivityAdjust = 0.5f * type.mass / (float)Math.max(1.0, 5.0 * Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        float yaw = this.flapsYaw * (this.flapsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * sensitivityAdjust;
        float flapsPitch = (this.flapsPitchLeft + this.flapsPitchRight) / 2.0f;
        float pitch = flapsPitch * (flapsPitch > 0.0f ? type.lookUpModifier : type.lookDownModifier) * sensitivityAdjust;
        float flapsRoll = (this.flapsPitchRight - this.flapsPitchLeft) / 2.0f;
        float roll = flapsRoll * (flapsRoll > 0.0f ? type.rollLeftModifier : type.rollRightModifier) * sensitivityAdjust;
        this.applyTorque(this.axes.findLocalVectorGlobally(new Vector3f(-roll, yaw, -pitch)));
        float thrustFormulaCoefficient = 2.0f;
        float dragFormulaCoefficient = 10.0f;
        float gravity = 0.49050003f;
        float liftFormulaCoefficient = 1.2f * (dragFormulaCoefficient * type.drag * type.mass * gravity) / (type.lift * thrustFormulaCoefficient * type.maxThrottle * (float)type.propellers.size());
        for (Propeller propeller : type.propellers) {
            boolean canThrustCreatively;
            if (this.getDriveableData().parts.get((Object)((Object)propeller.planePart)).dead) continue;
            boolean bl = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
            if (!canThrustCreatively && !(data.fuelInTank > data.engine.fuelConsumption * this.throttle)) continue;
            float thrust = thrustFormulaCoefficient * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
            this.applyForce(this.axes.findLocalVectorGlobally(propeller.getPosition()), (Vector3f)this.axes.getXAxis().scale(thrust));
            if (canThrustCreatively) continue;
            data.fuelInTank -= data.engine.fuelConsumption * this.throttle;
        }
        Vector3f velocityVector = new Vector3f((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y);
        if (velocityVector.lengthSquared() > 1.0E-7f) {
            float drag = dragFormulaCoefficient * type.drag * velocityVector.lengthSquared();
            this.applyForce(new Vector3f(), (Vector3f)velocityVector.normalise().negate().scale(drag));
        }
        velocityVector = new Vector3f((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y);
        float xVelocity = Vector3f.dot(velocityVector, this.axes.getXAxis());
        float zVelocity = Vector3f.dot(velocityVector, this.axes.getZAxis());
        float perpendicularVelocity = xVelocity * xVelocity + zVelocity * zVelocity;
        if (velocityVector.lengthSquared() > 1.0E-7f) {
            float lift = liftFormulaCoefficient * type.lift * perpendicularVelocity;
            this.applyForce(new Vector3f(), (Vector3f)this.axes.getYAxis().scale(lift));
        }
        float gravitationalForce = type.mass * gravity;
        this.applyForce(new Vector3f(), new Vector3f(0.0f, -gravitationalForce, 0.0f));
        this.angularVelocity.scale(0.95f);
        this.moveDriveable();
        if (!this.field_70170_p.field_72995_K && this.leftMouseHeld && this.gunDelay <= 0 && TeamsManager.bulletsEnabled) {
            for (PilotGun gun : this.getDriveableType().guns) {
                BulletType bullet;
                GunType gunType = gun.type;
                ItemStack bulletItemStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + gun.gunID];
                if (gunType == null || bulletItemStack == null || !(bulletItemStack.func_77973_b() instanceof ItemBullet) || !gunType.isAmmo(bullet = ((ItemBullet)bulletItemStack.func_77973_b()).type)) continue;
                Vector3f gunVec = this.rotate(gun.position);
                this.field_70170_p.func_72838_d((Entity)((ItemBullet)bulletItemStack.func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(gunVec, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null), this.axes.getXAxis(), (EntityLivingBase)this.seats[0].field_70153_n, gunType.bulletSpread / 2.0f, gunType.damage, 2.0f, bulletItemStack.func_77960_j(), (InfoType)type));
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootMainSound, false);
                int damage = bulletItemStack.func_77960_j();
                bulletItemStack.func_77964_b(damage + 1);
                if (damage + 1 == bulletItemStack.func_77958_k()) {
                    bulletItemStack.func_77964_b(0);
                    if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                        --bulletItemStack.field_77994_a;
                        if (bulletItemStack.field_77994_a <= 0) {
                            bulletItemStack = null;
                        }
                        this.driveableData.func_70299_a(this.getDriveableType().numPassengerGunners + gun.gunID, bulletItemStack);
                    }
                }
                this.gunDelay = type.planeShootDelay;
            }
        }
        if (data.fuel != null && data.fuel.field_77994_a <= 0) {
            data.fuel = null;
        }
        boolean bl = this.fuelling = data.fuel != null && data.fuelInTank < (float)type.fuelTankSize && data.fuel.field_77994_a > 0 && data.fuel.func_77973_b() instanceof ItemPart && ((ItemPart)data.fuel.func_77973_b()).type.category == 9;
        if (this.fuelling) {
            int damage = data.fuel.func_77960_j();
            data.fuel.func_77964_b(damage + 1);
            data.fuelInTank += 100.0f;
            if (damage >= data.fuel.func_77958_k()) {
                data.fuel.func_77964_b(0);
                --data.fuel.field_77994_a;
                if (data.fuel.field_77994_a <= 0) {
                    data.fuel = null;
                }
            }
        }
        if (FlansMod.hooks.BuildCraftLoaded && !this.fuelling && data.fuel != null && data.fuel.field_77994_a > 0) {
            if (data.fuel.func_77969_a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + 500.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 5000.0f;
                data.fuel = new ItemStack(Items.field_151133_ar);
            } else if (data.fuel.func_77969_a(FlansMod.hooks.BuildCraftFuelBucket) && data.fuelInTank + 1000.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 10000.0f;
                data.fuel = new ItemStack(Items.field_151133_ar);
            }
        }
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketPlaneControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketPlaneControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
        }
    }

    @Override
    public boolean gearDown() {
        return this.varGear;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i, boolean doDamage) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        PlaneType type = PlaneType.getPlane(this.driveableType);
        if (damagesource.field_76373_n.equals("player") && ((EntityDamageSource)damagesource).func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null)) {
            ItemStack planeStack = new ItemStack(type.item, 1, 0);
            planeStack.field_77990_d = new NBTTagCompound();
            this.driveableData.writeToNBT(planeStack.field_77990_d);
            this.func_70099_a(planeStack, 0.5f);
            this.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean canHitPart(EnumDriveablePart part) {
        return this.varGear || part != EnumDriveablePart.coreWheel && part != EnumDriveablePart.leftWingWheel && part != EnumDriveablePart.rightWingWheel && part != EnumDriveablePart.tailWheel;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        return this.attackEntityFrom(damagesource, i, true);
    }

    public PlaneType getPlaneType() {
        return PlaneType.getPlane(this.driveableType);
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Bombs";
    }

    @Override
    public boolean hasMouseControlMode() {
        return true;
    }
}

