/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IExplodeable;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketVehicleControl;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityVehicle
extends EntityDriveable
implements IExplodeable {
    public int shellDelay;
    public int gunDelay;
    public int soundPosition;
    public float wheelsYaw;
    private int ticksSinceUsed = 0;
    public boolean varDoor;
    public float wheelsAngle;
    public int toggleTimer = 0;
    public EntityWheel[] wheels;

    public EntityVehicle(World world) {
        super(world);
        this.field_70138_W = 1.0f;
    }

    public EntityVehicle(World world, double x, double y, double z, VehicleType type, DriveableData data) {
        super(world, type, data);
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, false);
    }

    public EntityVehicle(World world, double x, double y, double z, EntityPlayer placer, VehicleType type, DriveableData data) {
        this(world, x, y, z, type, data);
        this.rotateYaw(placer.field_70177_z + 90.0f);
    }

    @Override
    protected void initType(DriveableType type, boolean clientSide) {
        super.initType(type, clientSide);
        this.wheels = new EntityWheel[4];
        for (int i = 0; i < 4; ++i) {
            if (clientSide) continue;
            this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
        }
        this.field_70138_W = ((VehicleType)type).wheelStepHeight;
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("VarDoor", this.varDoor);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varDoor = tag.func_74767_n("VarDoor");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            if (i == 0) {
                this.shellDelay = type.vehicleShellDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        VehicleType type = this.getVehicleType();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        switch (key) {
            case 0: {
                this.throttle += 0.01f;
                if (this.throttle > 1.0f) {
                    this.throttle = 1.0f;
                }
                return true;
            }
            case 1: {
                this.throttle -= 0.01f;
                if (this.throttle < -1.0f) {
                    this.throttle = -1.0f;
                }
                if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                    this.throttle = 0.0f;
                }
                return true;
            }
            case 2: {
                this.wheelsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.wheelsYaw += 1.0f;
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                this.seats[0].field_70153_n.func_70078_a(null);
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.seats[0].field_70153_n, this.field_70170_p, this);
                }
                return true;
            }
            case 8: {
                if (!this.field_70170_p.field_72995_K && this.shellDelay <= 0 && TeamsManager.bombsEnabled) {
                    int slot = -1;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ItemStack shell = this.driveableData.func_70301_a(i);
                        if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !((ItemBullet)shell.func_77973_b()).type.isShell) continue;
                        slot = i;
                    }
                    if (slot != -1) {
                        boolean spread = false;
                        boolean damageMultiplier = true;
                        float shellSpeed = 3.0f;
                        this.field_70170_p.func_72838_d((Entity)((ItemBullet)this.driveableData.func_70301_a(slot).func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.rotate(type.barrelPosition), null), this.rotate(this.seats[0].looking.getXAxis()), (EntityLivingBase)this.seats[0].field_70153_n, (float)spread, (float)damageMultiplier, shellSpeed, this.driveableData.func_70301_a(slot).func_77960_j(), (InfoType)type));
                        if (type.shootSecondarySound != null) {
                            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSecondarySound, false);
                        }
                        if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                            this.driveableData.func_70298_a(slot, 1);
                        }
                        this.shellDelay = type.vehicleShellDelay;
                    }
                    return true;
                }
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Doors " + (this.varDoor ? "open" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
                }
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        VehicleType type = this.getVehicleType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Vehicle type null. Not ticking vehicle");
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                if (this.wheels[i] != null && this.wheels[i].field_70175_ag) continue;
                this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
            }
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.vehicleLife > 0 && this.ticksSinceUsed > TeamsManager.vehicleLife * 20) {
            this.func_70106_y();
        }
        if (this.shellDelay > 0) {
            --this.shellDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        if (this.hasEnoughFuel()) {
            this.wheelsAngle += this.throttle / 7.0f;
        }
        this.wheelsYaw *= 0.9f;
        if (this.wheelsYaw > 20.0f) {
            this.wheelsYaw = 20.0f;
        }
        if (this.wheelsYaw < -20.0f) {
            this.wheelsYaw = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        Vector3f amountToMoveCar = new Vector3f();
        EntityWheel[] arr$ = this.wheels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            boolean canThrustCreatively;
            EntityWheel wheel = arr$[i$];
            if (wheel == null) continue;
            this.field_70122_E = true;
            wheel.field_70122_E = true;
            wheel.field_70177_z = this.axes.getYaw();
            if (!(type.tank || wheel.ID != 2 && wheel.ID != 3)) {
                wheel.field_70177_z += this.wheelsYaw;
            }
            wheel.field_70159_w *= (double)0.9f;
            wheel.field_70181_x *= (double)0.9f;
            wheel.field_70179_y *= (double)0.9f;
            wheel.field_70181_x -= 0.049000002443790436;
            boolean bl = canThrustCreatively = !TeamsManager.vehiclesNeedFuel || this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
            if (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption * this.throttle) {
                if (this.getVehicleType().tank) {
                    boolean left = wheel.ID == 0 || wheel.ID == 3;
                    float turningDrag = 0.02f;
                    wheel.field_70159_w *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    wheel.field_70179_y *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    float velocityScale = 0.04f * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    float steeringScale = 0.1f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier);
                    float effectiveWheelSpeed = (this.throttle + this.wheelsYaw * (float)(left ? 1 : -1) * steeringScale) * velocityScale;
                    wheel.field_70159_w += (double)effectiveWheelSpeed * Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f);
                    wheel.field_70179_y += (double)effectiveWheelSpeed * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f);
                } else {
                    float velocityScale = 0.1f * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    wheel.field_70159_w += Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    wheel.field_70179_y += Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    if (wheel.ID == 2 || wheel.ID == 3) {
                        velocityScale = 0.01f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * (float)(this.throttle > 0.0f ? 1 : -1);
                        wheel.field_70159_w -= wheel.getSpeedXZ() * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                        wheel.field_70179_y += wheel.getSpeedXZ() * Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                    } else {
                        wheel.field_70159_w *= (double)0.9f;
                        wheel.field_70179_y *= (double)0.9f;
                    }
                }
            }
            wheel.func_70091_d(wheel.field_70159_w, wheel.field_70181_x, wheel.field_70179_y);
            Vector3f targetWheelPos = this.axes.findLocalVectorGlobally(this.getVehicleType().wheelPositions[wheel.ID]);
            Vector3f currentWheelPos = new Vector3f(wheel.field_70165_t - this.field_70165_t, wheel.field_70163_u - this.field_70163_u, wheel.field_70161_v - this.field_70161_v);
            Vector3f dPos = (Vector3f)Vector3f.sub(targetWheelPos, currentWheelPos, null).scale(this.getVehicleType().wheelSpringStrength);
            if (!(dPos.length() > 0.001f)) continue;
            wheel.func_70091_d(dPos.x, dPos.y, dPos.z);
            dPos.scale(0.5f);
            Vector3f.sub(amountToMoveCar, dPos, amountToMoveCar);
        }
        this.func_70091_d(amountToMoveCar.x, amountToMoveCar.y, amountToMoveCar.z);
        if (this.wheels[0] != null && this.wheels[1] != null && this.wheels[2] != null && this.wheels[3] != null) {
            Vector3f frontAxleCentre = new Vector3f((this.wheels[2].field_70165_t + this.wheels[3].field_70165_t) / 2.0, (this.wheels[2].field_70163_u + this.wheels[3].field_70163_u) / 2.0, (this.wheels[2].field_70161_v + this.wheels[3].field_70161_v) / 2.0);
            Vector3f backAxleCentre = new Vector3f((this.wheels[0].field_70165_t + this.wheels[1].field_70165_t) / 2.0, (this.wheels[0].field_70163_u + this.wheels[1].field_70163_u) / 2.0, (this.wheels[0].field_70161_v + this.wheels[1].field_70161_v) / 2.0);
            float dx = frontAxleCentre.x - backAxleCentre.x;
            float dy = frontAxleCentre.y - backAxleCentre.y;
            float dz = frontAxleCentre.z - backAxleCentre.z;
            float dxz = (float)Math.sqrt(dx * dx + dz * dz);
            float yaw = (float)Math.atan2(dz, dx);
            float pitch = -((float)Math.atan2(dy, dxz));
            float roll = 0.0f;
            if (type.tank) {
                yaw = (float)Math.atan2(this.wheels[3].field_70161_v - this.wheels[2].field_70161_v, this.wheels[3].field_70165_t - this.wheels[2].field_70165_t) + 1.5707964f;
            }
            this.axes.setAngles(yaw * 180.0f / 3.14159f, pitch * 180.0f / 3.14159f, roll * 180.0f / 3.14159f);
        }
        if (!this.field_70170_p.field_72995_K && this.leftMouseHeld && this.gunDelay <= 0 && TeamsManager.bulletsEnabled && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer) {
            for (PilotGun gun : this.getDriveableType().guns) {
                BulletType bullet;
                GunType gunType = gun.type;
                ItemStack bulletItemStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + gun.gunID];
                if (gunType == null || bulletItemStack == null || !(bulletItemStack.func_77973_b() instanceof ItemBullet) || !gunType.isAmmo(bullet = ((ItemBullet)bulletItemStack.func_77973_b()).type)) continue;
                Vector3f localGunVec = gun.position;
                Vector3f lookVec = this.axes.getXAxis();
                if (gun.driveablePart == EnumDriveablePart.turret) {
                    localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
                    lookVec = this.axes.findLocalVectorGlobally(this.seats[0].looking.getXAxis());
                }
                Vector3f gunVec = this.rotate(localGunVec);
                this.field_70170_p.func_72838_d((Entity)((ItemBullet)bulletItemStack.func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(gunVec, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null), lookVec, (EntityLivingBase)((EntityLiving)this.field_70153_n), gunType.bulletSpread / 2.0f, gunType.damage, 2.0f, bulletItemStack.func_77960_j(), (InfoType)type));
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootMainSound, false);
                int damage = bulletItemStack.func_77960_j();
                bulletItemStack.func_77964_b(damage + 1);
                if (damage + 1 == bulletItemStack.func_77958_k()) {
                    bulletItemStack.func_77964_b(0);
                    if (!((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                        --bulletItemStack.field_77994_a;
                        if (bulletItemStack.field_77994_a <= 0) {
                            bulletItemStack = null;
                        }
                        this.driveableData.func_70299_a(this.getDriveableType().numPassengerGunners + gun.gunID, bulletItemStack);
                    }
                }
                this.gunDelay = type.vehicleShootDelay;
            }
        }
        if (data.fuel != null && data.fuel.field_77994_a <= 0) {
            data.fuel = null;
        }
        boolean bl = this.fuelling = data.fuel != null && data.fuelInTank < (float)type.fuelTankSize && data.fuel.field_77994_a > 0 && data.fuel.func_77973_b() instanceof ItemPart && ((ItemPart)data.fuel.func_77973_b()).type.category == 9;
        if (this.fuelling) {
            int damage = data.fuel.func_77960_j();
            data.fuel.func_77964_b(damage + 1);
            data.fuelInTank += 10.0f;
            if (damage >= data.fuel.func_77958_k()) {
                data.fuel.func_77964_b(0);
                --data.fuel.field_77994_a;
                if (data.fuel.field_77994_a <= 0) {
                    data.fuel = null;
                }
            }
        }
        if (FlansMod.hooks.BuildCraftLoaded && !this.fuelling && data.fuel != null && data.fuel.field_77994_a > 0) {
            if (data.fuel.func_77969_a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + 500.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 5000.0f;
                data.fuel = new ItemStack(Items.field_151133_ar);
            } else if (data.fuel.func_77969_a(FlansMod.hooks.BuildCraftFuelBucket) && data.fuelInTank + 1000.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 10000.0f;
                data.fuel = new ItemStack(Items.field_151133_ar);
            }
        }
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketVehicleControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
        }
    }

    private float averageAngles(float a, float b) {
        float avg;
        FlansMod.log("Pre  " + a + " " + b);
        float pi = (float)Math.PI;
        while (a > b + pi) {
            a -= 2.0f * pi;
        }
        while (a < b - pi) {
            a += 2.0f * pi;
        }
        for (avg = (a + b) / 2.0f; avg > pi; avg -= 2.0f * pi) {
        }
        while (avg < -pi) {
            avg += 2.0f * pi;
        }
        FlansMod.log("Post " + a + " " + b + " " + avg);
        return avg;
    }

    private Vec3 subtract(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)(a.field_72450_a - b.field_72450_a), (double)(a.field_72448_b - b.field_72448_b), (double)(a.field_72449_c - b.field_72449_c));
    }

    private Vec3 crossProduct(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)(a.field_72448_b * b.field_72449_c - a.field_72449_c * b.field_72448_b), (double)(a.field_72449_c * b.field_72450_a - a.field_72450_a * b.field_72449_c), (double)(a.field_72450_a * b.field_72448_b - a.field_72448_b * b.field_72450_a));
    }

    private void applyThrust(DriveablePart part, float thrust) {
        boolean canThrustCreatively;
        if (part.maxHealth > 0 && part.health <= 0) {
            return;
        }
        if (part.box == null) {
            return;
        }
        DriveableData data = this.getDriveableData();
        boolean bl = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
        if (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption * this.throttle) {
            int z;
            int y;
            Vector3f midPoint = part.box.getCentre();
            Vector3f globalMidPoint = this.axes.findLocalVectorGlobally(midPoint);
            int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)globalMidPoint.x));
            if (!this.field_70170_p.func_147437_c(x, y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)globalMidPoint.y - (double)this.getVehicleType().wheelStepHeight)), z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)globalMidPoint.z)))) {
                Vector3f xAxis = this.axes.getXAxis();
                this.applyForce(globalMidPoint, (Vector3f)new Vector3f(xAxis.x, 0.0f, xAxis.z).scale(thrust));
            }
            if (!canThrustCreatively) {
                data.fuelInTank -= data.engine.fuelConsumption * this.throttle;
            }
        }
    }

    @Override
    public boolean landVehicle() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        if (damagesource.field_76373_n.equals("player") && ((EntityDamageSource)damagesource).func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null)) {
            ItemStack vehicleStack = new ItemStack(type.item, 1, 0);
            vehicleStack.field_77990_d = new NBTTagCompound();
            this.driveableData.writeToNBT(vehicleStack.field_77990_d);
            this.func_70099_a(vehicleStack, 0.5f);
            this.func_70106_y();
        }
        return true;
    }

    public VehicleType getVehicleType() {
        return VehicleType.getVehicle(this.driveableType);
    }

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Shells";
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            wheel.func_70106_y();
        }
    }
}

