/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.network.PacketGunFire;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketReload;
import com.flansmod.common.types.InfoType;
import com.google.common.collect.Multimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class ItemGun
extends Item {
    public GunType type;
    private static boolean mouseHeld;
    private static boolean lastMouseHeld;
    public int soundDelay;
    public HashMap<String, IIcon> icons = new HashMap();

    public ItemGun(GunType gun) {
        this.field_77777_bU = 1;
        this.type = gun;
        this.type.item = this;
        this.func_77656_e(this.type.numAmmoItemsInGun);
        this.func_77637_a(FlansMod.tabFlanGuns);
        GameRegistry.registerItem((Item)this, (String)this.type.shortName, (String)"flansmod");
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack getBulletItemStack(ItemStack gun, int id) {
        if (!gun.func_77942_o()) {
            gun.field_77990_d = new NBTTagCompound();
            return null;
        }
        if (!gun.field_77990_d.func_74764_b("ammo")) {
            NBTTagList ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.field_77990_d.func_74782_a("ammo", (NBTBase)ammoTagsList);
            return null;
        }
        NBTTagList ammoTagsList = gun.field_77990_d.func_150295_c("ammo", 10);
        NBTTagCompound ammoTags = ammoTagsList.func_150305_b(id);
        return ItemStack.func_77949_a((NBTTagCompound)ammoTags);
    }

    public void setBulletItemStack(ItemStack gun, ItemStack bullet, int id) {
        NBTTagList ammoTagsList;
        if (!gun.func_77942_o()) {
            gun.field_77990_d = new NBTTagCompound();
        }
        if (!gun.field_77990_d.func_74764_b("ammo")) {
            ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.field_77990_d.func_74782_a("ammo", (NBTBase)ammoTagsList);
        }
        ammoTagsList = gun.field_77990_d.func_150295_c("ammo", 10);
        NBTTagCompound ammoTags = ammoTagsList.func_150305_b(id);
        if (bullet == null) {
            ammoTags = new NBTTagCompound();
        }
        bullet.func_77955_b(ammoTags);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean advancedTooltips) {
        for (AttachmentType attachment : this.type.getCurrentAttachments(stack)) {
            String line = attachment.name;
            lines.add(line);
        }
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(stack, i);
            if (bulletStack == null || !(bulletStack.func_77973_b() instanceof ItemBullet)) continue;
            BulletType bulletType = ((ItemBullet)bulletStack.func_77973_b()).type;
            String line = bulletType.name + " " + (bulletStack.func_77958_k() - bulletStack.func_77960_j()) + "/" + bulletStack.func_77958_k();
            lines.add(line);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71071_by.func_70448_g() == itemstack) {
            if (this.soundDelay <= 0 && this.type.idleSound != null) {
                PacketPlaySound.sendSoundPacket(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0, entity.field_71093_bK, this.type.idleSound, false);
                this.soundDelay = this.type.idleSoundLength;
            }
            lastMouseHeld = mouseHeld;
            mouseHeld = Mouse.isButtonDown((int)1);
            if (this.type.deployable) {
                return;
            }
            if (mouseHeld && !lastMouseHeld) {
                FlansMod.getPacketHandler().sendToServer(new PacketGunFire(true));
                this.clientSideShoot((EntityPlayer)entity, itemstack);
            }
            if ((this.type.mode == EnumFireMode.FULLAUTO || this.type.mode == EnumFireMode.MINIGUN) && !mouseHeld && lastMouseHeld) {
                FlansMod.getPacketHandler().sendToServer(new PacketGunFire(false));
            }
            if ((this.type.mode == EnumFireMode.FULLAUTO || this.type.mode == EnumFireMode.MINIGUN) && mouseHeld) {
                this.clientSideShoot((EntityPlayer)entity, itemstack);
            }
            GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
            IScope currentScope = this.type.getCurrentScope(itemstack);
            if (Mouse.isButtonDown((int)0) && FlansModClient.scopeTime <= 0 && FMLClientHandler.instance().getClient().field_71462_r == null) {
                if (FlansModClient.currentScope == null) {
                    FlansModClient.currentScope = currentScope;
                    FlansModClient.lastZoomLevel = currentScope.getZoomFactor();
                    FlansModClient.lastFOVZoomLevel = currentScope.getFOVFactor();
                    float f = FlansModClient.originalMouseSensitivity = gameSettings.field_74341_c;
                    gameSettings.field_74341_c = f / (float)Math.sqrt(currentScope.getZoomFactor());
                    FlansModClient.originalThirdPerson = gameSettings.field_74320_O;
                    gameSettings.field_74320_O = 0;
                    FlansModClient.originalFOV = gameSettings.field_74334_X;
                } else {
                    FlansModClient.currentScope = null;
                    gameSettings.field_74341_c = FlansModClient.originalMouseSensitivity;
                    gameSettings.field_74320_O = FlansModClient.originalThirdPerson;
                    gameSettings.field_74334_X = FlansModClient.originalFOV;
                }
                FlansModClient.scopeTime = 10;
            }
            if (FMLClientHandler.instance().getClient().field_71462_r != null && FlansModClient.currentScope != null) {
                FlansModClient.currentScope = null;
                gameSettings.field_74341_c = FlansModClient.originalMouseSensitivity;
                gameSettings.field_74320_O = FlansModClient.originalThirdPerson;
                gameSettings.field_74334_X = FlansModClient.originalFOV;
            }
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
    }

    public void clientSideShoot(EntityPlayer player, ItemStack stack) {
        if (FlansModClient.shootTime <= 0) {
            boolean hasAmmo = false;
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ItemStack bulletStack = this.getBulletItemStack(stack, i);
                if (bulletStack == null || bulletStack.func_77973_b() == null || bulletStack.func_77960_j() >= bulletStack.func_77958_k()) continue;
                hasAmmo = true;
                break;
            }
            if (hasAmmo) {
                GunAnimations animations = null;
                if (FlansModClient.gunAnimations.containsKey(player)) {
                    animations = FlansModClient.gunAnimations.get(player);
                } else {
                    animations = new GunAnimations();
                    FlansModClient.gunAnimations.put((EntityLivingBase)player, animations);
                }
                int pumpDelay = this.type.model == null ? 0 : this.type.model.pumpDelay;
                int pumpTime = this.type.model == null ? 1 : this.type.model.pumpTime;
                animations.doShoot(pumpDelay, pumpTime);
                FlansModClient.playerRecoil += this.type.getRecoil(stack);
                FlansModClient.shootTime = this.type.shootDelay;
            }
        }
    }

    public void onUpdateServer(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
            if (data == null) {
                return;
            }
            if (player.field_71071_by.func_70448_g() != itemstack) {
                if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() == null || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemGun)) {
                    data.isShooting = false;
                }
                return;
            }
            if (this.type.mode == EnumFireMode.FULLAUTO && data.isShooting) {
                this.tryToShoot(itemstack, world, player);
            }
            if (this.type.useLoopingSounds && data.isShooting && data.loopedSoundDelay <= 0 && data.minigunSpeed > 0.1f && !data.reloading) {
                data.loopedSoundDelay = this.type.loopedSoundLength;
                PacketPlaySound.sendSoundPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0, player.field_71093_bK, data.shouldPlayWarmupSound ? this.type.warmupSound : this.type.loopedSound, false);
                data.shouldPlayWarmupSound = false;
            }
            if (this.type.useLoopingSounds && !data.isShooting && data.shouldPlayCooldownSound) {
                PacketPlaySound.sendSoundPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0, player.field_71093_bK, this.type.cooldownSound, false);
                data.shouldPlayCooldownSound = false;
            }
            if (this.type.mode == EnumFireMode.MINIGUN && data.isShooting && data.minigunSpeed > 15.0f) {
                this.tryToShoot(itemstack, world, player);
            }
        }
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (world.field_72995_K) {
            this.onUpdateClient(itemstack, world, entity, i, flag);
        } else {
            this.onUpdateServer(itemstack, world, entity, i, flag);
        }
    }

    public ItemStack onMouseHeld(ItemStack stack, World world, EntityPlayerMP player, boolean isShooting) {
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (data != null && data.shootClickDelay == 0) {
            if (player.field_70154_o instanceof EntitySeat && ((EntitySeat)player.field_70154_o).seatInfo.id == 0) {
                return stack;
            }
            data.isShooting = isShooting;
            if (this.type.mode == EnumFireMode.SEMIAUTO && isShooting) {
                data.isShooting = false;
                return this.tryToShoot(stack, world, player);
            }
            if (this.type.useLoopingSounds && isShooting) {
                data.shouldPlayWarmupSound = true;
            }
        }
        return stack;
    }

    public ItemStack tryToShoot(ItemStack gunStack, World world, EntityPlayerMP entityplayer) {
        if (this.type.deployable) {
            return gunStack;
        }
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)entityplayer);
        boolean reloading = true;
        if (data.shootTime <= 0) {
            int bulletID;
            ItemStack bulletStack = null;
            for (bulletID = 0; bulletID < this.type.numAmmoItemsInGun; ++bulletID) {
                ItemStack checkingStack = this.getBulletItemStack(gunStack, bulletID);
                if (checkingStack == null || checkingStack.func_77973_b() == null || checkingStack.func_77960_j() >= checkingStack.func_77958_k()) continue;
                bulletStack = checkingStack;
                break;
            }
            if (bulletStack == null) {
                if (this.reload(gunStack, world, (EntityPlayer)entityplayer, false)) {
                    data.shootTime = (int)this.type.getReloadTime(gunStack);
                    data.reloading = true;
                    FlansMod.getPacketHandler().sendTo(new PacketReload(), entityplayer);
                    if (this.type.reloadSound != null) {
                        PacketPlaySound.sendSoundPacket(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 50.0, entityplayer.field_71093_bK, this.type.reloadSound, true);
                    }
                }
            } else if (bulletStack.func_77973_b() instanceof ItemBullet) {
                reloading = false;
                this.shoot(gunStack, world, bulletStack, (EntityPlayer)entityplayer);
                bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                this.setBulletItemStack(gunStack, bulletStack, bulletID);
            }
        }
        return gunStack;
    }

    public boolean reload(ItemStack gunStack, World world, EntityPlayer player, boolean forceReload) {
        return this.reload(gunStack, world, (Entity)player, (IInventory)player.field_71071_by, player.field_71075_bZ.field_75098_d, forceReload);
    }

    public boolean reload(ItemStack gunStack, World world, Entity entity, IInventory inventory, boolean creative, boolean forceReload) {
        if (this.type.deployable) {
            return false;
        }
        if (forceReload && !this.type.canForceReload) {
            return false;
        }
        boolean reloadedSomething = false;
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(gunStack, i);
            if (bulletStack != null && bulletStack.func_77960_j() != bulletStack.func_77958_k() && !forceReload) continue;
            int bestSlot = -1;
            int bulletsInBestSlot = 0;
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                int bulletsInThisSlot;
                ItemStack item = inventory.func_70301_a(j);
                if (item == null || !(item.func_77973_b() instanceof ItemBullet) || !this.type.isAmmo(((ItemBullet)item.func_77973_b()).type) || (bulletsInThisSlot = item.func_77958_k() - item.func_77960_j()) <= bulletsInBestSlot) continue;
                bestSlot = j;
                bulletsInBestSlot = bulletsInThisSlot;
            }
            if (bestSlot == -1) continue;
            ItemStack newBulletStack = inventory.func_70301_a(bestSlot);
            BulletType newBulletType = ((ItemBullet)newBulletStack.func_77973_b()).type;
            if (bulletStack != null && bulletStack.func_77973_b() instanceof ItemBullet && ((ItemBullet)bulletStack.func_77973_b()).type.dropItemOnReload != null && !creative) {
                ItemGun.dropItem(world, entity, ((ItemBullet)bulletStack.func_77973_b()).type.dropItemOnReload);
            }
            if (bulletStack != null && bulletStack.func_77960_j() < bulletStack.func_77958_k() && !InventoryHelper.addItemStackToInventory(inventory, bulletStack, creative)) {
                entity.func_70099_a(bulletStack, 0.5f);
            }
            ItemStack stackToLoad = newBulletStack.func_77946_l();
            stackToLoad.field_77994_a = 1;
            this.setBulletItemStack(gunStack, stackToLoad, i);
            if (!creative) {
                --newBulletStack.field_77994_a;
            }
            if (newBulletStack.field_77994_a <= 0) {
                newBulletStack = null;
            }
            inventory.func_70299_a(bestSlot, newBulletStack);
            reloadedSomething = true;
        }
        return reloadedSomething;
    }

    public static void dropItem(World world, Entity entity, String itemName) {
        if (itemName != null) {
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            entity.func_70099_a(dropStack, 0.5f);
        }
    }

    private void shoot(ItemStack stack, World world, ItemStack bulletStack, EntityPlayer entityplayer) {
        BulletType bullet = ((ItemBullet)bulletStack.func_77973_b()).type;
        if (this.soundDelay <= 0 && this.type.shootSound != null) {
            AttachmentType barrel = this.type.getBarrel(stack);
            boolean silenced = barrel != null && barrel.silencer;
            PacketPlaySound.sendSoundPacket(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 50.0, entityplayer.field_71093_bK, this.type.shootSound, this.type.distortSound, silenced);
            this.soundDelay = this.type.shootSoundLength;
        }
        if (!world.field_72995_K) {
            for (int k = 0; k < this.type.numBullets; ++k) {
                world.func_72838_d(((ItemBullet)bulletStack.func_77973_b()).getEntity(world, (EntityLivingBase)entityplayer, (entityplayer.func_70093_af() ? 0.7f : 1.0f) * this.type.getSpread(stack), this.type.getDamage(stack), this.type.getBulletSpeed(stack), this.type.numBullets > 1, bulletStack.func_77960_j(), this.type));
            }
            if (bullet.dropItemOnShoot != null && !entityplayer.field_71075_bZ.field_75098_d) {
                ItemGun.dropItem(world, (Entity)entityplayer, bullet.dropItemOnShoot);
            }
        }
        PlayerHandler.getPlayerData((EntityPlayer)entityplayer).shootTime = this.type.shootDelay;
        if (this.type.knockback > 0.0f) {
            // empty if block
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.type.deployable) {
            Vec3 lookVec;
            float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
            float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
            double length = 5.0;
            Vec3 posVec = Vec3.func_72443_a((double)entityplayer.field_70165_t, (double)(entityplayer.field_70163_u + 1.62 - (double)entityplayer.field_70129_M), (double)entityplayer.field_70161_v);
            MovingObjectPosition look = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), true);
            if (look != null && look.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && look.field_72310_e == 1) {
                int playerDir = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int i = look.field_72311_b;
                int j = look.field_72312_c;
                int k = look.field_72309_d;
                if (!world.field_72995_K) {
                    if (world.func_147439_a(i, j, k) == Blocks.field_150433_aE) {
                        --j;
                    }
                    if (!(!this.isSolid(world, i, j, k) || world.func_147439_a(i, j + 1, k) != Blocks.field_150350_a && world.func_147439_a(i, j + 1, k) != Blocks.field_150433_aE || world.func_147439_a(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j + 1, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0)) != Blocks.field_150350_a || world.func_147439_a(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0)) != Blocks.field_150350_a && world.func_147439_a(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0)) != Blocks.field_150433_aE)) {
                        for (EntityMG mg : EntityMG.mgs) {
                            if (mg.blockX != i || mg.blockY != j + 1 || mg.blockZ != k || mg.field_70128_L) continue;
                            return itemstack;
                        }
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)new EntityMG(world, i, j + 1, k, playerDir, this.type));
                        }
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            itemstack.field_77994_a = 0;
                        }
                    }
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return itemstack;
    }

    private boolean isSolid(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block == null) {
            return false;
        }
        return block.func_149688_o().func_76220_a() && block.func_149662_c();
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.type.meleeDamage, 0));
        return multimap;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.type.meleeSound != null) {
            PacketPlaySound.sendSoundPacket(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 50.0, entityLiving.field_71093_bK, this.type.meleeSound, true);
        }
        return this.type.meleeDamage == 0.0f || this.type.FOVFactor != 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    public boolean isItemStackDamageable() {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack gunStack = new ItemStack(item, 1, 0);
        GunType type = ((ItemGun)item).type;
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Paint", type.defaultPaintjob.iconName);
        gunStack.field_77990_d = tags;
        list.add(gunStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("FlansMod:" + this.type.iconPath);
        for (Paintjob paintjob : this.type.paintjobs) {
            this.icons.put(paintjob.iconName, icon.func_94245_a("FlansMod:" + paintjob.iconName));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.field_77990_d.func_74764_b("Paint")) {
            stack.field_77990_d.func_74778_a("Paint", this.type.defaultPaintjob.iconName);
        }
        return this.icons.get(stack.field_77990_d.func_74779_i("Paint"));
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }
}

