/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketTeamInfo
extends PacketBase {
    public static String mapShortName;
    public static String map;
    public static String gametype;
    public static int numTeams;
    public static TeamData[] teamData;
    public static boolean sortedByTeam;
    public static int timeLeft;
    public static int scoreLimit;
    public static int numLines;

    public static PlayerScoreData getPlayerScoreData(String username) {
        if (teamData == null) {
            return null;
        }
        for (TeamData team : teamData) {
            if (team == null || team.playerData == null) {
                return null;
            }
            for (PlayerScoreData player : team.playerData) {
                if (player == null || player.username == null || !player.username.equals(username)) continue;
                return player;
            }
        }
        return null;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        if (TeamsManager.getInstance().currentRound == null) {
            this.writeUTF(data, "No Gametype");
            data.writeInt(0);
        } else {
            this.writeUTF(data, TeamsManager.getInstance().currentRound.gametype.name);
            this.writeUTF(data, TeamsManager.getInstance().currentRound.map.name);
            this.writeUTF(data, TeamsManager.getInstance().currentRound.map.shortName);
            data.writeInt(TeamsManager.getInstance().roundTimeLeft);
            data.writeInt(TeamsManager.getInstance().currentRound.scoreLimit);
            if (TeamsManager.getInstance().currentRound.gametype.sortScoreboardByTeam()) {
                data.writeBoolean(true);
                if (TeamsManager.getInstance().currentRound.teams == null) {
                    data.writeInt(0);
                } else {
                    data.writeInt(TeamsManager.getInstance().currentRound.teams.length);
                    for (int i = 0; i < TeamsManager.getInstance().currentRound.teams.length; ++i) {
                        Team team = TeamsManager.getInstance().currentRound.teams[i];
                        if (team == null) {
                            this.writeUTF(data, "none");
                            continue;
                        }
                        this.writeUTF(data, team.shortName);
                        data.writeInt(team.score);
                        team.sortPlayers();
                        data.writeInt(team.members.size());
                        for (int j = 0; j < team.members.size(); ++j) {
                            String username = team.members.get(j);
                            PlayerData playerData = PlayerHandler.getPlayerData(username, Side.SERVER);
                            this.writeUTF(data, username);
                            if (playerData == null) {
                                data.writeInt(0);
                                data.writeInt(0);
                                data.writeInt(0);
                                continue;
                            }
                            data.writeInt(playerData.score);
                            data.writeInt(playerData.kills);
                            data.writeInt(playerData.deaths);
                        }
                    }
                }
            } else {
                data.writeBoolean(false);
                ArrayList<String> playerNames = new ArrayList<String>();
                for (int i = 0; i < TeamsManager.getInstance().currentRound.teams.length; ++i) {
                    Team team = TeamsManager.getInstance().currentRound.teams[i];
                    if (team == null || team.members == null) continue;
                    playerNames.addAll(team.members);
                }
                Collections.sort(playerNames, new Team.ComparatorScore());
                data.writeInt(playerNames.size());
                for (int j = 0; j < playerNames.size(); ++j) {
                    String username = (String)playerNames.get(j);
                    PlayerData playerData = PlayerHandler.getPlayerData(username, Side.SERVER);
                    this.writeUTF(data, username);
                    if (playerData == null) {
                        data.writeInt(0);
                        data.writeInt(0);
                        data.writeInt(0);
                        continue;
                    }
                    data.writeInt(playerData.score);
                    data.writeInt(playerData.kills);
                    data.writeInt(playerData.deaths);
                }
            }
        }
        data.writeBoolean(TeamsManager.canBreakGlass);
        data.writeBoolean(TeamsManager.vehiclesNeedFuel);
        data.writeBoolean(TeamsManager.driveablesBreakBlocks);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        gametype = this.readUTF(data);
        if (gametype.equals("No Gametype")) {
            numTeams = 0;
            teamData = new TeamData[0];
        } else {
            map = this.readUTF(data);
            mapShortName = this.readUTF(data);
            timeLeft = data.readInt();
            scoreLimit = data.readInt();
            sortedByTeam = data.readBoolean();
            if (sortedByTeam) {
                numLines = numTeams = data.readInt();
                if (numTeams == 0) {
                    return;
                }
                teamData = new TeamData[numTeams];
                for (int i = 0; i < numTeams; ++i) {
                    PacketTeamInfo.teamData[i] = new TeamData();
                    String teamName = this.readUTF(data);
                    if (teamName.equals("none")) continue;
                    PacketTeamInfo.teamData[i].team = Team.getTeam(teamName);
                    PacketTeamInfo.teamData[i].score = data.readInt();
                    PacketTeamInfo.teamData[i].numPlayers = data.readInt();
                    PacketTeamInfo.teamData[i].playerData = new PlayerScoreData[PacketTeamInfo.teamData[i].numPlayers];
                    numLines += PacketTeamInfo.teamData[i].numPlayers;
                    for (int j = 0; j < PacketTeamInfo.teamData[i].numPlayers; ++j) {
                        PacketTeamInfo.teamData[i].playerData[j] = new PlayerScoreData();
                        PacketTeamInfo.teamData[i].playerData[j].team = teamData[i];
                        PacketTeamInfo.teamData[i].playerData[j].username = this.readUTF(data);
                        PacketTeamInfo.teamData[i].playerData[j].score = data.readInt();
                        PacketTeamInfo.teamData[i].playerData[j].kills = data.readInt();
                        PacketTeamInfo.teamData[i].playerData[j].deaths = data.readInt();
                    }
                }
            } else {
                numLines = 0;
                teamData = new TeamData[]{new TeamData()};
                PacketTeamInfo.teamData[0].team = null;
                PacketTeamInfo.teamData[0].score = 0;
                PacketTeamInfo.teamData[0].numPlayers = data.readInt();
                PacketTeamInfo.teamData[0].playerData = new PlayerScoreData[PacketTeamInfo.teamData[0].numPlayers];
                numLines += PacketTeamInfo.teamData[0].numPlayers;
                for (int j = 0; j < PacketTeamInfo.teamData[0].numPlayers; ++j) {
                    PacketTeamInfo.teamData[0].playerData[j] = new PlayerScoreData();
                    PacketTeamInfo.teamData[0].playerData[j].team = teamData[0];
                    PacketTeamInfo.teamData[0].playerData[j].username = this.readUTF(data);
                    PacketTeamInfo.teamData[0].playerData[j].score = data.readInt();
                    PacketTeamInfo.teamData[0].playerData[j].kills = data.readInt();
                    PacketTeamInfo.teamData[0].playerData[j].deaths = data.readInt();
                }
            }
        }
        TeamsManager.canBreakGlass = data.readBoolean();
        TeamsManager.vehiclesNeedFuel = data.readBoolean();
        TeamsManager.driveablesBreakBlocks = data.readBoolean();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansModClient.teamInfo = this;
    }

    public Team getTeam(int spawnerTeamID) {
        switch (spawnerTeamID) {
            case 0: {
                return null;
            }
            case 1: {
                return Team.spectators;
            }
        }
        return teamData.length > spawnerTeamID - 2 ? PacketTeamInfo.teamData[spawnerTeamID - 2].team : null;
    }

    public boolean roundOver() {
        if (timeLeft == 0) {
            return true;
        }
        for (int i = 0; i < teamData.length; ++i) {
            if (PacketTeamInfo.teamData[i].score != scoreLimit) continue;
            return true;
        }
        return false;
    }

    public Team getWinner() {
        for (int i = 0; i < teamData.length; ++i) {
            if (PacketTeamInfo.teamData[i].score != scoreLimit) continue;
            return PacketTeamInfo.teamData[i].team;
        }
        return null;
    }

    public static class PlayerScoreData {
        public String username;
        public int score;
        public int kills;
        public int deaths;
        public TeamData team;
    }

    public static class TeamData {
        public Team team;
        public int score;
        public int numPlayers;
        public PlayerScoreData[] playerData;
    }
}

