/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;

public class ArmourType
extends InfoType {
    public static ArrayList<ArmourType> armours = new ArrayList();
    public int type;
    public double defence;
    public String armourTextureName;

    public ArmourType(TypeFile file) {
        super(file);
        armours.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("Type")) {
                if (split[1].equals("Hat") || split[1].equals("Helmet")) {
                    this.type = 0;
                }
                if (split[1].equals("Chest") || split[1].equals("Body")) {
                    this.type = 1;
                }
                if (split[1].equals("Legs") || split[1].equals("Pants")) {
                    this.type = 2;
                }
                if (split[1].equals("Shoes") || split[1].equals("Boots")) {
                    this.type = 3;
                }
            }
            if (split[0].equals("DamageReduction") || split[0].equals("Defence")) {
                this.defence = Double.parseDouble(split[1]);
            }
            if (split[0].equals("ArmourTexture") || split[0].equals("ArmorTexture")) {
                this.armourTextureName = split[1];
            }
        }
        catch (Exception e) {
            System.out.println("Reading armour file failed.");
            e.printStackTrace();
        }
    }

    public static ArmourType getArmourType(String string) {
        for (ArmourType armour : armours) {
            if (!armour.shortName.equals(string)) continue;
            return armour;
        }
        return null;
    }
}

