/*
 * Decompiled with CFR 0.152.
 */
package com.jimboom.mario;

import com.jimboom.mario.PipeTeleporterChannel;
import com.jimboom.mario.PipeTeleporterDBServer;
import com.jimboom.mario.ServerPacketHandler;
import com.jimboom.mario.mod_Mario;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EntityPipeTeleporter
extends TileEntity {
    public PipeTeleporterChannel currentChannel;
    public int channelToAdd;
    public boolean readyToAdd = false;
    public int playsound = 42;
    public int delay;
    public double yaw;
    public double yaw2;
    public int standOnCount = 0;
    public boolean playerMoved = false;
    public int reset;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.reset;
            if (this.reset > 10) {
                this.standOnCount = 0;
                this.playerMoved = true;
            }
        }
        if (this.readyToAdd && this.currentChannel == null && this.channelToAdd > -1) {
            this.removeOldChannel();
            this.addNewChannel(this.channelToAdd);
            if (this.field_145850_b.field_72995_K) {
                ServerPacketHandler.sendRefreshDB();
            }
            this.readyToAdd = false;
        }
        this.yaw2 = this.yaw;
        if (!this.anyPlayerInRange()) {
            return;
        }
        this.yaw += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.yaw > 360.0) {
            this.yaw -= 360.0;
            this.yaw2 -= 360.0;
        }
        this.delay = 200 + this.field_145850_b.field_73012_v.nextInt(600);
    }

    public boolean addNewChannel(int f) {
        if (f < 0 || f >= PipeTeleporterDBServer.maxChannels) {
            return false;
        }
        PipeTeleporterChannel tf = PipeTeleporterDBServer.getOrCreateChannel(this.field_145850_b.field_73011_w.field_76574_g, f);
        if (tf.addTeleporter(this)) {
            this.currentChannel = tf;
            PipeTeleporterDBServer.needsUpdate = true;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void removeOldChannel() {
        if (this.currentChannel != null) {
            this.currentChannel.removeTeleporter(this);
            this.func_70296_d();
        }
    }

    public void onCollide(Entity entity) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.standOnCount;
        this.reset = 0;
        if (this.standOnCount > 32 && this.playerMoved) {
            this.teleportEntity(entity);
        }
    }

    public void teleportEntity(Entity entity) {
        EntityPipeTeleporter tp;
        if (this.field_145850_b.field_72995_K) {
            if (mod_Mario.proxy.isTeleporterActive(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                mod_Mario.proxy.sendTeleportMe(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.isActive() && (tp = this.currentChannel.getCounterpart(this)) != null && !(entity instanceof EntityPlayer)) {
            entity.func_70107_b((double)((float)tp.field_145851_c + 0.5f), (double)((float)tp.field_145848_d + 0.3f), (double)((float)tp.field_145849_e + 0.5f));
            ServerPacketHandler.sendAnimation(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, tp.field_145851_c, tp.field_145848_d, tp.field_145849_e);
            tp.playerMoved = false;
            tp.standOnCount = 0;
        }
    }

    public boolean isActive() {
        return this.currentChannel != null && this.currentChannel.getCounterpart(this) != null;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int f = nbttagcompound.func_74762_e("Current");
        if (f > -1 && !this.readyToAdd) {
            this.channelToAdd = f;
            this.readyToAdd = true;
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.currentChannel != null) {
            nbttagcompound.func_74768_a("Current", this.currentChannel.getChannel());
        } else {
            nbttagcompound.func_74768_a("Current", -1);
        }
    }

    public boolean isSameAs(EntityPipeTeleporter tp) {
        return tp != null && tp.field_145851_c == this.field_145851_c && tp.field_145848_d == this.field_145848_d && tp.field_145849_e == this.field_145849_e;
    }

    public PipeTeleporterChannel getCurrentChannel() {
        return this.currentChannel;
    }

    public void setCurrentChannel(PipeTeleporterChannel currentChannel) {
        this.currentChannel = currentChannel;
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0) != null;
    }
}

