/*
 * Decompiled with CFR 0.152.
 */
package com.jimboom.mario;

import com.jimboom.mario.Channel;
import java.util.HashMap;
import java.util.Map;

public class PipeTeleporterDBClient {
    public static Map<Integer, Channel> channels;
    public static int maxChannels;

    public static void init() {
        channels = new HashMap<Integer, Channel>();
    }

    public static void add(int f, int x, int y, int z) {
        Channel chan;
        if (channels != null && !channels.containsKey(f)) {
            channels.put(f, new Channel(f));
        }
        if ((chan = channels.get(f)) != null || chan.tp1 == null) {
            chan.tp1 = new int[]{x, y, z};
        } else if (chan.tp2 == null) {
            chan.tp2 = new int[]{x, y, z};
        }
    }

    public static boolean isAlreadyUsed(int f, int x, int y, int z) {
        if (channels != null && channels.containsKey(f)) {
            Channel chan = channels.get(f);
            if (chan == null) {
                return false;
            }
            return !(chan.tp1 == null || chan.tp2 == null || chan.tp1[0] == x && chan.tp1[1] == y && chan.tp1[2] == z || chan.tp2[0] == x && chan.tp2[1] == y && chan.tp2[2] == z);
        }
        return false;
    }

    public static int getChannel(int x, int y, int z) {
        if (channels == null || channels.isEmpty()) {
            return -1;
        }
        for (Map.Entry<Integer, Channel> entry : channels.entrySet()) {
            Channel chan = entry.getValue();
            if (chan == null || (chan.tp1 == null || chan.tp1[0] != x || chan.tp1[1] != y || chan.tp1[2] != z) && (chan.tp2 == null || chan.tp2[0] != x || chan.tp2[1] != y || chan.tp2[2] != z)) continue;
            return chan.Channel;
        }
        return -1;
    }

    public static boolean isActive(int x, int y, int z) {
        int f = PipeTeleporterDBClient.getChannel(x, y, z);
        if (f >= 0 && channels != null && channels.containsKey(f)) {
            Channel chan = channels.get(f);
            if (chan.tp1 != null && chan.tp2 != null) {
                return true;
            }
        }
        return false;
    }

    public static void printChannels() {
        System.out.println("-----------------------------------Client--------------------------------------");
        if (channels == null) {
            System.out.println("null");
            return;
        }
        for (Map.Entry<Integer, Channel> entry2 : channels.entrySet()) {
            Channel tf = entry2.getValue();
            if (tf == null) continue;
            System.out.println(" f: " + tf.Channel);
            if (tf.tp1 != null) {
                System.out.println("tp1 x: " + tf.tp1[0] + " z: " + tf.tp1[2]);
            }
            if (tf.tp2 == null) continue;
            System.out.println("tp2 x: " + tf.tp2[0] + " z: " + tf.tp2[2]);
        }
    }

    static {
        maxChannels = -1;
    }
}

