/*
 * Decompiled with CFR 0.152.
 */
package com.jimboom.mario;

import com.jimboom.mario.PipeTeleporterChannel;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class PipeTeleporterDBServer {
    public static Map<Integer, Map<Integer, PipeTeleporterChannel>> channels;
    public static boolean needsUpdate;
    public static int maxChannels;

    public static void init() {
        channels = new HashMap<Integer, Map<Integer, PipeTeleporterChannel>>();
        PipeTeleporterDBServer.convertSaveFile();
        PipeTeleporterDBServer.readChunkCoords();
    }

    public static PipeTeleporterChannel getOrCreateChannel(int dimension, int f) {
        Map<Integer, PipeTeleporterChannel> m = null;
        if (channels == null) {
            PipeTeleporterDBServer.init();
        }
        if (!channels.containsKey(dimension)) {
            channels.put(dimension, new HashMap());
        }
        if (!(m = channels.get(dimension)).containsKey(f)) {
            m.put(f, new PipeTeleporterChannel(f));
        }
        return m.get(f);
    }

    public static int getDimensionIDforWorld(World worldObj) {
        Integer[] ids = DimensionManager.getIDs();
        for (int x = 0; x < ids.length; ++x) {
            int id = ids[x];
            if (DimensionManager.getWorld((int)id) != worldObj) continue;
            return id;
        }
        return 0;
    }

    public static int[] getLocations(int dim) {
        int[] temp = new int[800];
        int counter = 0;
        if (channels == null || channels.isEmpty()) {
            return null;
        }
        Map<Integer, PipeTeleporterChannel> map = channels.get(dim);
        if (map == null || map.isEmpty()) {
            return null;
        }
        for (Map.Entry<Integer, PipeTeleporterChannel> entry : map.entrySet()) {
            PipeTeleporterChannel tf = entry.getValue();
            if (tf == null) continue;
            if (tf.getTp1() != null) {
                temp[counter] = entry.getKey();
                temp[counter + 1] = tf.getTp1().field_145851_c;
                temp[counter + 2] = tf.getTp1().field_145848_d;
                temp[counter + 3] = tf.getTp1().field_145849_e;
                counter += 4;
            }
            if (tf.getTp2() == null) continue;
            temp[counter] = entry.getKey();
            temp[counter + 1] = tf.getTp2().field_145851_c;
            temp[counter + 2] = tf.getTp2().field_145848_d;
            temp[counter + 3] = tf.getTp2().field_145849_e;
            counter += 4;
        }
        int[] finalArray = new int[counter];
        for (int i = 0; i < counter; ++i) {
            finalArray[i] = temp[i];
        }
        return finalArray;
    }

    public static void writeChunkCoords() {
        try {
            File file = new File(PipeTeleporterDBServer.getPath());
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(fos);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.canWrite()) {
                for (Map.Entry<Integer, Map<Integer, PipeTeleporterChannel>> entry : channels.entrySet()) {
                    Map<Integer, PipeTeleporterChannel> map = entry.getValue();
                    if (map == null || map.isEmpty()) continue;
                    for (Map.Entry<Integer, PipeTeleporterChannel> entry2 : map.entrySet()) {
                        PipeTeleporterChannel tf = entry2.getValue();
                        if (tf == null) continue;
                        if (tf.getTp1() != null) {
                            dos.writeInt(tf.getTp1().field_145851_c >> 4);
                            dos.writeInt(tf.getTp1().field_145849_e >> 4);
                        }
                        if (tf.getTp2() == null) continue;
                        dos.writeInt(tf.getTp2().field_145851_c >> 4);
                        dos.writeInt(tf.getTp2().field_145849_e >> 4);
                    }
                }
                fos.close();
                dos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        needsUpdate = false;
    }

    public static void readChunkCoords() {
        try {
            File file = new File(PipeTeleporterDBServer.getPath());
            FileInputStream fis = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(fis);
            WorldServer[] worlds = MinecraftServer.func_71276_C().field_71305_c;
            try {
                block4: while (true) {
                    int x = dis.readInt();
                    int z = dis.readInt();
                    int i = 0;
                    while (true) {
                        if (i >= worlds.length) continue block4;
                        if (worlds[i] != null) {
                            worlds[i].func_72863_F().func_73154_d(x, z);
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (EOFException e) {
                fis.close();
                dis.close();
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static String getPath() {
        MinecraftServer ms = FMLCommonHandler.instance().getMinecraftServerInstance();
        String s = ms.func_71209_f(ms.func_71270_I()) + "/teleporterLocations" + ".dat";
        if (ms.func_71264_H()) {
            s = ms.func_71209_f("/saves") + "/" + ms.func_71270_I() + "/teleporterLocations" + ".dat";
        }
        return s;
    }

    public static void convertSaveFile() {
        String path = PipeTeleporterDBServer.getPath().replaceFirst(".dat", "0.dat");
        PipeTeleporterDBServer.readOld(path);
        path = PipeTeleporterDBServer.getPath().replaceFirst(".dat", "-1.dat");
        PipeTeleporterDBServer.readOld(path);
    }

    public static void readOld(String path) {
        try {
            File file = new File(path);
            FileInputStream fis = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(fis);
            WorldServer[] worlds = MinecraftServer.func_71276_C().field_71305_c;
            for (int i = 0; i < worlds.length; ++i) {
                IChunkProvider cp = worlds[i].func_72863_F();
                ((ChunkProviderServer)cp).field_73250_a = true;
            }
            try {
                block5: while (true) {
                    int x = dis.readInt();
                    int z = dis.readInt();
                    int i = 0;
                    while (true) {
                        if (i >= worlds.length) continue block5;
                        if (worlds[i] != null && worlds[i].func_72964_e(x, z) != null && !worlds[i].func_72964_e((int)x, (int)z).field_76636_d) {
                            worlds[i].func_72964_e(x, z).func_76631_c();
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (EOFException e) {
                for (int i = 0; i < worlds.length; ++i) {
                    IChunkProvider cp = worlds[i].func_72863_F();
                    if (!(cp instanceof ChunkProviderServer)) continue;
                    ((ChunkProviderServer)cp).field_73250_a = false;
                }
                fis.close();
                dis.close();
                file.delete();
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

