/*
 * Decompiled with CFR 0.152.
 */
package com.jimboom.mario;

import com.jimboom.mario.EntityPipeTeleporter;
import com.jimboom.mario.PipeTeleporterDBServer;
import com.jimboom.mario.mod_Mario;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class ServerPacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBufInputStream dat = new ByteBufInputStream(event.packet.payload());
        try {
            int t1 = dat.readInt();
            switch (t1) {
                case 0: {
                    int ch = dat.readInt();
                    int t2 = dat.readInt();
                    int t3 = dat.readInt();
                    int t4 = dat.readInt();
                    TileEntity tileEntity = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK).func_147438_o(t2, t3, t4);
                    if (!(tileEntity instanceof EntityPipeTeleporter)) break;
                    ((EntityPipeTeleporter)tileEntity).removeOldChannel();
                    ((EntityPipeTeleporter)tileEntity).addNewChannel(ch);
                    ServerPacketHandler.sendRefreshDB();
                    break;
                }
                case 1: {
                    ServerPacketHandler.sendTeleporterDB(player);
                    break;
                }
                case 2: {
                    this.teleportPlayer(dat, player);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendTeleporterDB(EntityPlayerMP player) {
        int[] dataInt = PipeTeleporterDBServer.getLocations(player.field_71093_bK);
        if (dataInt == null) {
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bytes);
        try {
            dos.writeInt(0);
            dos.writeInt(PipeTeleporterDBServer.maxChannels);
            dos.writeInt(dataInt.length);
            for (int i = 0; i < dataInt.length; ++i) {
                dos.writeInt(dataInt[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FMLProxyPacket pkt = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])bytes.toByteArray()), mod_Mario.channelName);
        mod_Mario.channel.sendTo(pkt, player);
    }

    public static void sendRefreshDB() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bytes);
        int[] surface = PipeTeleporterDBServer.getLocations(0);
        int[] nether = PipeTeleporterDBServer.getLocations(-1);
        for (Object player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            try {
                if (((EntityPlayerMP)player).field_71093_bK == 0) {
                    if (surface == null) continue;
                    dos.writeInt(0);
                    dos.writeInt(PipeTeleporterDBServer.maxChannels);
                    dos.writeInt(surface.length);
                    for (int i = 0; i < surface.length; ++i) {
                        dos.writeInt(surface[i]);
                    }
                } else if (((EntityPlayerMP)player).field_71093_bK == -1) {
                    if (nether == null) continue;
                    dos.writeInt(0);
                    dos.writeInt(PipeTeleporterDBServer.maxChannels);
                    dos.writeInt(nether.length);
                    for (int i = 0; i < nether.length; ++i) {
                        dos.writeInt(nether[i]);
                    }
                } else {
                    int[] data = PipeTeleporterDBServer.getLocations(((EntityPlayerMP)player).field_71093_bK);
                    if (data == null) continue;
                    dos.writeInt(0);
                    dos.writeInt(PipeTeleporterDBServer.maxChannels);
                    dos.writeInt(data.length);
                    for (int i = 0; i < data.length; ++i) {
                        dos.writeInt(data[i]);
                    }
                }
                if (dos.size() <= 0) continue;
                FMLProxyPacket pkt = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])bytes.toByteArray()), mod_Mario.channelName);
                mod_Mario.channel.sendTo(pkt, (EntityPlayerMP)player);
            }
            catch (IOException e) {}
        }
    }

    public static void sendAnimation(int dimension, int xCoord, int yCoord, int zCoord, int xCoord2, int yCoord2, int zCoord2) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        int[] dataInt = new int[]{4, xCoord, yCoord, zCoord, xCoord2, yCoord2, zCoord2};
        try {
            for (int i = 0; i < dataInt.length; ++i) {
                data.writeInt(dataInt[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        FMLProxyPacket pkt = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])bytes.toByteArray()), mod_Mario.channelName);
        mod_Mario.channel.sendToAllAround(pkt, new NetworkRegistry.TargetPoint(dimension, (double)xCoord, (double)yCoord, (double)zCoord, 100.0));
        mod_Mario.channel.sendToAllAround(pkt, new NetworkRegistry.TargetPoint(dimension, (double)xCoord2, (double)yCoord2, (double)zCoord2, 100.0));
    }

    private void teleportPlayer(ByteBufInputStream dat, EntityPlayerMP player) {
        try {
            EntityPipeTeleporter tp1;
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
            TileEntity tp = world.func_147438_o(dat.readInt(), dat.readInt(), dat.readInt());
            if (tp instanceof EntityPipeTeleporter && (tp1 = ((EntityPipeTeleporter)tp).currentChannel.getCounterpart((EntityPipeTeleporter)tp)) != null) {
                world.func_147438_o(tp1.field_145851_c, tp1.field_145848_d, tp1.field_145849_e);
                player.func_70634_a((double)((float)tp1.field_145851_c + 0.5f), (double)((float)tp1.field_145848_d + 0.5f), (double)tp1.field_145849_e);
                ServerPacketHandler.sendAnimation(player.field_71093_bK, tp1.field_145851_c, tp1.field_145848_d, tp1.field_145849_e, tp.field_145851_c, tp.field_145848_d, tp.field_145849_e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

