/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.block;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import java.util.Locale;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.inventory.ContainerAutoCrafting;
import net.lepko.easycrafting.core.inventory.gui.GuiAutoCrafting;
import net.lepko.easycrafting.core.inventory.gui.IGuiTile;
import net.lepko.easycrafting.core.util.InventoryUtils;
import net.lepko.easycrafting.core.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class TileEntityAutoCrafting
extends TileEntity
implements ISidedInventory,
IGuiTile {
    private static final Mode[] VALID_MODES = Mode.values();
    private static final int UPDATE_INTERVAL = 5;
    private Mode mode = Mode.ALWAYS;
    private int lastUpdate = 0;
    private ItemStack[] inventory = new ItemStack[26];
    public final int[] SLOTS = InventoryUtils.createSlotArray(10, this.inventory.length);
    private boolean poweredNow = false;
    private boolean poweredPrev = false;
    private boolean inventoryChanged = false;
    private int pendingRequests = 0;
    public boolean scheduledRecipeCheck = false;
    private InventoryCrafting craftingGrid = new InventoryCrafting((Container)new FakeContainer(), 3, 3);
    private IRecipe currentRecipe = null;
    private boolean lastCraftingSuccess = true;

    public void setMode(int index) {
        if (index >= 0 && index < VALID_MODES.length) {
            this.mode = VALID_MODES[index];
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void cycleModes(int mouseButton) {
        if (mouseButton == 0) {
            if (this.mode == null || this.mode.ordinal() + 1 >= VALID_MODES.length) {
                this.setMode(0);
            } else {
                this.setMode(this.mode.ordinal() + 1);
            }
        } else if (mouseButton == 1) {
            if (this.mode == null || this.mode.ordinal() - 1 < 0) {
                this.setMode(VALID_MODES.length - 1);
            } else {
                this.setMode(this.mode.ordinal() - 1);
            }
        }
    }

    private void checkForRecipe() {
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        InventoryUtils.setContents((IInventory)this.craftingGrid, (IInventory)this);
        for (IRecipe recipe : recipeList) {
            if (!recipe.func_77569_a(this.craftingGrid, this.field_145850_b)) continue;
            this.currentRecipe = recipe;
            this.func_70299_a(9, this.currentRecipe.func_77572_b(this.craftingGrid));
            return;
        }
        this.currentRecipe = null;
        this.func_70299_a(9, null);
    }

    private boolean isReplaceableInCraftingGridSlot(int slot, ItemStack stack) {
        this.craftingGrid.func_70299_a(slot, stack);
        boolean result = this.currentRecipe.func_77569_a(this.craftingGrid, this.field_145850_b) && StackUtils.areIdentical(this.currentRecipe.func_77572_b(this.craftingGrid), this.func_70301_a(9));
        this.craftingGrid.func_70299_a(slot, this.func_70301_a(slot));
        return result;
    }

    private boolean tryCrafting() {
        if (this.currentRecipe == null || this.func_70301_a(9) == null) {
            return false;
        }
        boolean[] found = new boolean[9];
        StackReference[] refs = new StackReference[9];
        for (int o = 0; o < 9; ++o) {
            found[o] = this.craftingGrid.func_70301_a(o) == null;
        }
        block1: for (int invSlot = 10; invSlot < 18; ++invSlot) {
            ItemStack stack = ItemStack.func_77944_b((ItemStack)this.func_70301_a(invSlot));
            if (stack == null || stack.field_77994_a <= 0) continue;
            for (int gridSlot = 0; gridSlot < 9; ++gridSlot) {
                if (found[gridSlot] || !this.isReplaceableInCraftingGridSlot(gridSlot, stack)) continue;
                refs[gridSlot] = new StackReference((IInventory)this, invSlot);
                found[gridSlot] = true;
                if (--stack.field_77994_a <= 0) continue block1;
            }
        }
        for (boolean b : found) {
            if (b) continue;
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.craftingGrid.func_70301_a(i) == null) continue;
            ItemStack is = refs[i].getCopy(1);
            this.craftingGrid.func_70299_a(i, is);
        }
        boolean craftingCompleted = false;
        ItemStack result = this.currentRecipe.func_77572_b(this.craftingGrid);
        if (this.currentRecipe.func_77569_a(this.craftingGrid, this.field_145850_b) && StackUtils.areIdentical(result, this.func_70301_a(9)) && InventoryUtils.addItemToInventory((IInventory)this, result, 18, 26)) {
            FakePlayer fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)Ref.GAME_PROFILE);
            FMLCommonHandler.instance().firePlayerCraftingEvent((EntityPlayer)fakePlayer, result, (IInventory)this.craftingGrid);
            result.func_77980_a(this.field_145850_b, (EntityPlayer)fakePlayer, result.field_77994_a);
            for (StackReference ref : refs) {
                ItemStack stack;
                if (ref == null || (stack = ref.decreaseStackSize(1)) == null || stack.func_77973_b() == null || !stack.func_77973_b().hasContainerItem(stack)) continue;
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                if (container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) {
                    container = null;
                }
                if (container == null || InventoryUtils.addItemToInventory((IInventory)this, container, 18, 26)) continue;
                InventoryUtils.dropItem(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5, container);
            }
            craftingCompleted = true;
        }
        InventoryUtils.setContents((IInventory)this.craftingGrid, (IInventory)this);
        return craftingCompleted;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        InventoryUtils.readStacksFromNBT(this.inventory, tag.func_150295_c("Inventory", 10));
        this.setMode(tag.func_74771_c("Mode"));
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("Inventory", (NBTBase)InventoryUtils.writeStacksToNBT(this.inventory));
        tag.func_74774_a("Mode", (byte)this.mode.ordinal());
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.checkForRecipe();
    }

    public void func_145845_h() {
        if (this.scheduledRecipeCheck) {
            this.scheduledRecipeCheck = false;
            this.checkForRecipe();
        }
        this.poweredPrev = this.poweredNow;
        this.poweredNow = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.poweredPrev && this.poweredNow) {
            ++this.pendingRequests;
        }
        if (!this.field_145850_b.field_72995_K && ++this.lastUpdate > 5) {
            this.lastUpdate = 0;
            if (this.lastCraftingSuccess || this.inventoryChanged) {
                this.inventoryChanged = false;
                if (this.mode == Mode.ALWAYS || this.mode == Mode.POWERED && this.poweredNow || this.mode == Mode.UNPOWERED && !this.poweredNow) {
                    this.lastCraftingSuccess = this.tryCrafting();
                } else if (this.mode == Mode.PULSE && this.pendingRequests > 0 && (this.lastCraftingSuccess = this.tryCrafting())) {
                    --this.pendingRequests;
                }
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.inventoryChanged = true;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return InventoryUtils.decreaseStackSize((IInventory)this, slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return InventoryUtils.getStackInSlotOnClosing((IInventory)this, slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack stack) {
        this.inventory[slotIndex] = stack;
    }

    public String func_145825_b() {
        return "container.easycrafting:table.auto_crafting";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack stack) {
        return slotIndex >= 10 && slotIndex < 18;
    }

    public int[] func_94128_d(int side) {
        return this.SLOTS;
    }

    public boolean func_102007_a(int slotIndex, ItemStack stack, int side) {
        return slotIndex >= 10 && slotIndex < 18;
    }

    public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
        return slotIndex >= 18 && slotIndex < this.inventory.length;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player, TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityAutoCrafting) {
            return new ContainerAutoCrafting(player.field_71071_by, (TileEntityAutoCrafting)tileEntity);
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player, TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityAutoCrafting) {
            return new GuiAutoCrafting(player.field_71071_by, (TileEntityAutoCrafting)tileEntity);
        }
        return null;
    }

    public static enum Mode {
        PULSE,
        ALWAYS,
        POWERED,
        UNPOWERED;

        public final String tooltip = String.format("mode.easycrafting:%s.tooltip", this.toString().toLowerCase(Locale.ENGLISH));
    }

    private static class StackReference {
        public final IInventory inv;
        public final int slot;

        public StackReference(IInventory inv, int slot) {
            this.inv = inv;
            this.slot = slot;
        }

        public ItemStack getCopy(int size) {
            return StackUtils.copyStack(this.inv.func_70301_a(this.slot), size);
        }

        public ItemStack decreaseStackSize(int amt) {
            return InventoryUtils.decreaseStackSize(this.inv, this.slot, amt);
        }
    }

    private static class FakeContainer
    extends Container {
        private FakeContainer() {
        }

        public boolean func_75145_c(EntityPlayer player) {
            return true;
        }
    }
}

