/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private static Configuration config;
    public static int MAX_RECURSION;
    public static int MAX_RECURSION_DEFAULT;
    public static String MAX_RECURSION_COMMENT;
    public static int MAX_TIME;
    public static int MAX_TIME_DEFAULT;
    public static String MAX_TIME_COMMENT;

    public static void initialize(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        config.load();
        MAX_RECURSION = config.get("general", "recipeRecursion", MAX_RECURSION_DEFAULT, MAX_RECURSION_COMMENT).getInt(MAX_RECURSION_DEFAULT);
        MAX_TIME = config.get("general", "maxTime", MAX_TIME_DEFAULT, MAX_TIME_COMMENT).getInt(MAX_TIME_DEFAULT);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setRecursion(int value) {
        MAX_RECURSION = value;
        config.getCategory("general").get("recipeRecursion").set(value);
        config.save();
    }

    static {
        MAX_RECURSION_DEFAULT = 10;
        MAX_RECURSION_COMMENT = "How deep to check for ingredients in multi level crafting, higher values can cause lag; default: 10";
        MAX_TIME_DEFAULT = 5000;
        MAX_TIME_COMMENT = "How long to wait for recipe results (milliseconds; default 5000";
    }
}

