/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.inventory.gui;

import codechicken.nei.guihook.IContainerTooltipHandler;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.block.ModBlocks;
import net.lepko.easycrafting.core.block.TileEntityEasyCrafting;
import net.lepko.easycrafting.core.config.ConfigHandler;
import net.lepko.easycrafting.core.inventory.ContainerEasyCrafting;
import net.lepko.easycrafting.core.inventory.gui.GuiTabbed;
import net.lepko.easycrafting.core.inventory.gui.Tab;
import net.lepko.easycrafting.core.network.PacketHandler;
import net.lepko.easycrafting.core.network.message.MessageEasyCrafting;
import net.lepko.easycrafting.core.recipe.RecipeChecker;
import net.lepko.easycrafting.core.recipe.RecipeHelper;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.lepko.easycrafting.core.util.InventoryUtils;
import net.lepko.easycrafting.core.util.ItemMap;
import net.lepko.easycrafting.core.util.StackUtils;
import net.lepko.easycrafting.core.util.WrappedStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.guihook.IContainerTooltipHandler", modid="NotEnoughItems")
public class GuiEasyCrafting
extends GuiTabbed
implements IContainerTooltipHandler {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation(Ref.RES_DOMAIN, "textures/gui/easycraftinggui.png");
    private static String LAST_SEARCH = "";
    private static boolean WORKER_LOCKED = false;
    public List<WrappedRecipe> shownRecipes;
    public List<WrappedRecipe> craftableRecipes = ImmutableList.of();
    private int currentRowOffset = 0;
    private int maxRowOffset = 0;
    private float currentScrollValue = 0.0f;
    private boolean wasClicking = false;
    private boolean isDraggingScrollBar = false;
    private boolean[] canCraftCache;
    private final IInventory tileInventory;
    private GuiTextField searchField;

    public GuiEasyCrafting(InventoryPlayer playerInventory, TileEntityEasyCrafting tileInventory) {
        super(new ContainerEasyCrafting(playerInventory, tileInventory));
        this.tileInventory = tileInventory;
        this.field_147000_g = 235;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(this.field_146289_q, this.field_147003_i + 82, this.field_147009_r + 6, 89, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(32);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146180_a(LAST_SEARCH);
    }

    @Override
    public void initTabs() {
        this.tabGroup.addTab(new TabEasyCrafting(new ItemStack(ModBlocks.table), "Available"));
        this.tabGroup.addTab(new TabEasyCrafting(new ItemStack(Items.field_151111_aL), "Search"));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float time) {
        WORKER_LOCKED = !RecipeChecker.INSTANCE.done;
        boolean leftMouseDown = Mouse.isButtonDown((int)0);
        int left = this.field_147003_i + 155;
        int top = this.field_147009_r + 18;
        int right = left + 14;
        int bottom = top + 89;
        if (!this.wasClicking && leftMouseDown && mouseX >= left && mouseY >= top && mouseX < right && mouseY < bottom) {
            this.isDraggingScrollBar = this.maxRowOffset > 0;
        } else if (!leftMouseDown) {
            this.isDraggingScrollBar = false;
        }
        this.wasClicking = leftMouseDown;
        if (this.isDraggingScrollBar) {
            this.setScrollValue(((float)(mouseY - top) - 7.5f) / ((float)(bottom - top) - 15.0f));
        }
        super.func_73863_a(mouseX, mouseY, time);
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(f, i, j);
        int scrollTextureX = this.maxRowOffset == 0 ? 12 : 0;
        this.func_73729_b(this.field_147003_i + 156, this.field_147009_r + 17 + (int)(this.currentScrollValue * 73.0f), scrollTextureX, 240, 12, 16);
        int searchTextureX = this.field_146999_f - 90 - 7;
        this.func_73729_b(this.field_147003_i + searchTextureX, this.field_147009_r + 4, searchTextureX, 244, 90, 12);
        this.searchField.func_146194_f();
        if (this.canCraftCache != null && this.currentTab != 0) {
            int offset = this.currentRowOffset * 8;
            for (int k = 0; k < 40 && k + offset < this.canCraftCache.length; ++k) {
                this.drawSlotBackground(this.field_147002_h.func_75139_a(k), this.canCraftCache[k + offset]);
            }
        }
        for (int l = 0; l < 18; ++l) {
            this.drawSlotBackground(this.field_147002_h.func_75139_a(l + 40), false);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String title = "Easy Crafting";
        if (WORKER_LOCKED) {
            title = "Searching...";
        }
        this.field_146289_q.func_78276_b(title, 7, 6, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_73869_a(char par1, int par2) {
        if (!this.func_146983_a(par2)) {
            if (this.searchField.func_146201_a(par1, par2)) {
                this.updateSearch(true);
            } else {
                super.func_73869_a(par1, par2);
            }
        }
    }

    public void func_146274_d() {
        int mouseScroll = Mouse.getEventDWheel();
        if (mouseScroll == 0) {
            super.func_146274_d();
        } else {
            this.setRowOffset(this.currentRowOffset + (mouseScroll > 0 ? -1 : 1));
        }
    }

    protected void func_146984_a(Slot slot, int slotIndex, int button, int action) {
        if (slotIndex >= 0 && slotIndex < 40) {
            this.onCraftingSlotClick(slot, slotIndex, button, action);
        } else {
            super.func_146984_a(slot, slotIndex, button, action);
        }
    }

    private void onCraftingSlotClick(Slot slot, int slotIndex, int button, int action) {
        WrappedRecipe r;
        Ref.LOGGER.trace("Clicked: " + slot.getClass().getSimpleName() + "@" + slotIndex + ", button=" + button + ", action=" + action + ", stack=" + slot.func_75211_c());
        if (action > 1 || button > 1 || !slot.func_75216_d()) {
            return;
        }
        ItemStack heldStack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        ItemStack slotStack = slot.func_75211_c();
        WrappedRecipe recipe = null;
        int recipeIndex = slotIndex + this.currentRowOffset * 8;
        if (recipeIndex >= 0 && this.shownRecipes != null && recipeIndex < this.shownRecipes.size() && StackUtils.areEqualNoSizeNoNBT((r = this.shownRecipes.get(recipeIndex)).getOutput(), slotStack) && this.craftableRecipes != null && this.craftableRecipes.contains(r)) {
            recipe = r;
        }
        if (recipe == null) {
            return;
        }
        ItemStack finalStack = slotStack.func_77946_l();
        int finalStackSize = 0;
        if (heldStack == null) {
            finalStackSize = finalStack.field_77994_a;
        } else if (StackUtils.canStack(slotStack, heldStack) == 0) {
            finalStackSize = finalStack.field_77994_a + heldStack.field_77994_a;
        }
        if (finalStackSize > 0) {
            boolean isRightClick = button == 1;
            boolean isShiftClick = action == 1;
            PacketHandler.INSTANCE.sendToServer(new MessageEasyCrafting(recipe, isRightClick, isShiftClick));
            if (isRightClick) {
                int maxTimes = RecipeHelper.calculateCraftingMultiplierUntilMaxStack(slotStack, heldStack);
                int timesCrafted = RecipeHelper.canCraft(recipe, (IInventory)this.field_146297_k.field_71439_g.field_71071_by, RecipeManager.getAllRecipes(), false, maxTimes, ConfigHandler.MAX_RECURSION);
                if (timesCrafted > 0) {
                    finalStack.field_77994_a = finalStackSize + (timesCrafted - 1) * finalStack.field_77994_a;
                    this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(finalStack);
                }
            } else if (isShiftClick) {
                int maxTimes = RecipeHelper.calculateCraftingMultiplierUntilMaxStack(slotStack, null);
                int timesCrafted = RecipeHelper.canCraft(recipe, (IInventory)this.field_146297_k.field_71439_g.field_71071_by, RecipeManager.getAllRecipes(), false, maxTimes, ConfigHandler.MAX_RECURSION);
                if (timesCrafted > 0) {
                    finalStack.field_77994_a *= timesCrafted;
                    InventoryUtils.addItemToInventory((IInventory)this.field_146297_k.field_71439_g.field_71071_by, finalStack);
                }
            } else {
                finalStack.field_77994_a = finalStackSize;
                this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(finalStack);
            }
        }
    }

    private void drawSlotBackground(Slot slot, boolean canCraft) {
        int x = this.field_147003_i + slot.field_75223_e;
        int y = this.field_147009_r + slot.field_75221_f;
        int color = canCraft ? -2147442688 : -2136997888;
        Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)color);
    }

    private void updateSearch(boolean scrollToTop) {
        List<WrappedRecipe> all = this.currentTab == 0 ? this.craftableRecipes : RecipeManager.getAllRecipes();
        ArrayList<WrappedRecipe> list = new ArrayList<WrappedRecipe>();
        if (all == null || this.searchField == null) {
            return;
        }
        LAST_SEARCH = this.searchField.func_146179_b().toLowerCase();
        if (!LAST_SEARCH.trim().isEmpty()) {
            block0: for (WrappedRecipe recipe : all) {
                List tips = recipe.getOutput().func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
                for (String tip : tips) {
                    if (!tip.toLowerCase().contains(LAST_SEARCH)) continue;
                    list.add(recipe);
                    continue block0;
                }
            }
            this.shownRecipes = list;
        } else {
            this.shownRecipes = all;
        }
        this.maxRowOffset = (int)(Math.ceil((double)this.shownRecipes.size() / 8.0) - 5.0);
        this.maxRowOffset = this.maxRowOffset < 0 ? 0 : this.maxRowOffset;
        this.rebuildCanCraftCache();
        this.setRowOffset(scrollToTop ? 0 : this.currentRowOffset);
    }

    public void refreshCraftingOutput() {
        this.craftableRecipes = ImmutableList.copyOf(RecipeChecker.INSTANCE.recipes);
        this.updateSearch(false);
    }

    private void rebuildCanCraftCache() {
        this.canCraftCache = new boolean[this.shownRecipes.size()];
        for (int i = 0; i < this.shownRecipes.size(); ++i) {
            this.canCraftCache[i] = this.craftableRecipes.contains(this.shownRecipes.get(i));
        }
    }

    private void setRowOffset(int rowOffset) {
        this.currentRowOffset = MathHelper.func_76125_a((int)rowOffset, (int)0, (int)this.maxRowOffset);
        this.currentScrollValue = MathHelper.func_76131_a((float)((float)this.currentRowOffset / (float)this.maxRowOffset), (float)0.0f, (float)1.0f);
        this.setSlots();
    }

    private void setScrollValue(float scrollValue) {
        this.currentScrollValue = MathHelper.func_76131_a((float)scrollValue, (float)0.0f, (float)1.0f);
        this.currentRowOffset = MathHelper.func_76125_a((int)((int)(this.currentScrollValue * (float)this.maxRowOffset + 0.5f)), (int)0, (int)this.maxRowOffset);
        this.setSlots();
    }

    private void setSlots() {
        if (this.shownRecipes != null) {
            int offset = this.currentRowOffset * 8;
            for (int i = 0; i < 40; ++i) {
                if (i + offset >= this.shownRecipes.size() || i + offset < 0) {
                    this.tileInventory.func_70299_a(i, null);
                    continue;
                }
                WrappedRecipe recipe = this.shownRecipes.get(i + offset);
                ItemStack is = recipe.handler.getCraftingResult(recipe, recipe.usedIngredients);
                this.tileInventory.func_70299_a(i, is);
            }
        }
    }

    public List<String> handleTooltip(GuiContainer gui, int mouseX, int mouseY, List<String> currentTip) {
        return currentTip;
    }

    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack stack, List<String> currentTip) {
        return currentTip;
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int mouseX, int mouseY, List<String> currentTip) {
        if (!this.drawCustomTooltip(stack, mouseX, mouseY, currentTip)) {
            return currentTip;
        }
        return new LinkedList<String>(){

            @Override
            public int size() {
                return 0;
            }
        };
    }

    protected void func_146285_a(ItemStack stack, int mouseX, int mouseY) {
        if (!this.drawCustomTooltip(stack, mouseX, mouseY, stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x))) {
            super.func_146285_a(stack, mouseX, mouseY);
        }
    }

    private boolean drawCustomTooltip(ItemStack stack, int mouseX, int mouseY, List<String> currentTip) {
        if (GuiEasyCrafting.func_146271_m() && currentTip != null && !currentTip.isEmpty()) {
            for (int j = 0; j < 40; ++j) {
                Slot slot = this.field_147002_h.func_75139_a(j);
                if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                String itemName = currentTip.get(0);
                ImmutableList list = ImmutableList.of((Object)(stack.func_77953_t().field_77937_e + itemName));
                this.drawHoveringText((List)list, mouseX, mouseY, font == null ? this.field_146289_q : font);
                boolean leftSide = mouseX + 12 + this.field_146289_q.func_78256_a(itemName) > this.field_146294_l;
                this.drawIngredientTooltip(j, mouseX, mouseY, leftSide);
                return true;
            }
        }
        return false;
    }

    private void drawIngredientTooltip(int slotIndex, int mouseX, int mouseY, boolean leftSide) {
        List<WrappedStack> ingredientList;
        WrappedRecipe r;
        WrappedRecipe recipe = null;
        int recipe_index = slotIndex + this.currentRowOffset * 8;
        if (recipe_index >= 0 && this.shownRecipes != null && recipe_index < this.shownRecipes.size() && StackUtils.areCraftingEquivalent((r = this.shownRecipes.get(recipe_index)).getOutput(), this.field_147002_h.func_75139_a(slotIndex).func_75211_c())) {
            recipe = r;
        }
        if (recipe == null) {
            return;
        }
        boolean canCraft = this.canCraftCache[recipe_index];
        List<WrappedStack> list = ingredientList = canCraft && !recipe.usedIngredients.isEmpty() ? StackUtils.collateStacks(recipe.usedIngredients) : recipe.collatedInputs;
        if (ingredientList != null && !ingredientList.isEmpty()) {
            int width = 16;
            int height = 16;
            int xPos = mouseX + 12;
            int yPos = mouseY - 12 + 14;
            if (ingredientList.size() > 1) {
                width += (ingredientList.size() - 1) * (width + 2);
            }
            if (leftSide) {
                xPos -= 28 + width;
            }
            int bgColor = -267386864;
            int borderColor = canCraft ? 1342220032 : 0x50FF0000;
            int borderColorDark = (borderColor & 0xFEFEFE) >> 1 | borderColor & 0xFF000000;
            this.field_73735_i += 500.0f;
            GuiEasyCrafting.field_146296_j.field_77023_b += 500.0f;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)32826);
            this.func_73733_a(xPos - 3, yPos - 4, xPos + width + 3, yPos - 3, bgColor, bgColor);
            this.func_73733_a(xPos - 3, yPos + height + 3, xPos + width + 3, yPos + height + 4, bgColor, bgColor);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + width + 3, yPos + height + 3, bgColor, bgColor);
            this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + height + 3, bgColor, bgColor);
            this.func_73733_a(xPos + width + 3, yPos - 3, xPos + width + 4, yPos + height + 3, bgColor, bgColor);
            this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + height + 3 - 1, borderColor, borderColorDark);
            this.func_73733_a(xPos + width + 2, yPos - 3 + 1, xPos + width + 3, yPos + height + 3 - 1, borderColor, borderColorDark);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + width + 3, yPos - 3 + 1, borderColor, borderColor);
            this.func_73733_a(xPos - 3, yPos + height + 2, xPos + width + 3, yPos + height + 3, borderColorDark, borderColorDark);
            RenderHelper.func_74520_c();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
            for (WrappedStack ws : ingredientList) {
                this.renderItem(xPos, yPos, ws);
                xPos += 18;
            }
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            this.field_73735_i -= 500.0f;
            GuiEasyCrafting.field_146296_j.field_77023_b -= 500.0f;
        }
    }

    private void renderItem(int xPos, int yPos, WrappedStack ws) {
        ItemStack is = null;
        int count = 0;
        for (ItemStack stack : ws.stacks) {
            if (stack.func_77960_j() == Short.MAX_VALUE && stack.func_77981_g()) {
                count += ItemMap.get(stack.func_77973_b()).size();
                continue;
            }
            ++count;
        }
        int num = (int)(this.field_146297_k.field_71441_e.func_82737_E() / 10L % (long)count);
        count = 0;
        for (ItemStack stack : ws.stacks) {
            if (stack.func_77960_j() == Short.MAX_VALUE && stack.func_77981_g()) {
                List<ItemStack> all = ItemMap.get(stack.func_77973_b());
                if (num >= count && num < count + all.size()) {
                    is = StackUtils.copyStack(all.get(num - count), ws.size);
                    break;
                }
                count += all.size();
                continue;
            }
            if (num == count) {
                is = StackUtils.copyStack(stack, ws.size);
                break;
            }
            ++count;
        }
        if (is != null) {
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, is, xPos, yPos);
            field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.field_71446_o, is, xPos, yPos);
        } else {
            Ref.LOGGER.warn("Error rendering stack in recipe tooltip: is == null");
        }
    }

    private class TabEasyCrafting
    extends Tab {
        public TabEasyCrafting(ItemStack iconStack, String tooltip) {
            super(iconStack, tooltip);
        }

        @Override
        public void onTabSelected() {
            GuiEasyCrafting.this.updateSearch(true);
        }
    }
}

