/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.recipe;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.config.ConfigHandler;
import net.lepko.easycrafting.core.inventory.gui.GuiEasyCrafting;
import net.lepko.easycrafting.core.recipe.RecipeHelper;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

@SideOnly(value=Side.CLIENT)
public enum RecipeChecker {
    INSTANCE;

    private Minecraft mc = FMLClientHandler.instance().getClient();
    public volatile boolean requested = false;
    private volatile boolean displayed = true;
    private volatile boolean suspended = false;
    public volatile boolean done = false;
    public volatile List<WrappedRecipe> recipes = ImmutableList.of();
    private Thread worker = null;

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mc.field_71441_e != null) {
            if (this.worker == null || !this.worker.isAlive()) {
                this.worker = new Thread((Runnable)new CraftabilityChecker(), "EasyCrafting-" + CraftabilityChecker.class.getSimpleName());
                this.worker.setDaemon(true);
                this.worker.start();
                Ref.LOGGER.info("Worker thread spawned.");
            }
            if (!this.displayed && !this.requested && this.done && this.mc.field_71462_r instanceof GuiEasyCrafting) {
                GuiEasyCrafting gec = (GuiEasyCrafting)this.mc.field_71462_r;
                gec.refreshCraftingOutput();
                this.displayed = true;
            }
        }
    }

    private class CraftabilityChecker
    implements Runnable {
        private CraftabilityChecker() {
        }

        @Override
        public void run() {
            while (true) {
                if (RecipeChecker.this.requested) {
                    RecipeChecker.this.requested = false;
                    RecipeChecker.this.displayed = false;
                    RecipeChecker.this.suspended = false;
                    RecipeChecker.this.done = false;
                    this.setCraftableRecipes();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private void setCraftableRecipes() {
            InventoryPlayer inventory = ((RecipeChecker)RecipeChecker.this).mc.field_71439_g.field_71071_by;
            RecipeChecker.this.recipes = this.getCraftableRecipes((IInventory)inventory, ConfigHandler.MAX_RECURSION, ConfigHandler.MAX_TIME, RecipeManager.getAllRecipes());
            RecipeChecker.this.done = !RecipeChecker.this.suspended;
        }

        private List<WrappedRecipe> getCraftableRecipes(IInventory inventory, int maxRecursion, long maxTime, List<WrappedRecipe> recipesToCheck) {
            long startTime = System.currentTimeMillis();
            LinkedList<WrappedRecipe> craftable = new LinkedList<WrappedRecipe>();
            LinkedList<WrappedRecipe> tmpAll = new LinkedList<WrappedRecipe>(recipesToCheck);
            for (WrappedRecipe wr : tmpAll) {
                if (RecipeChecker.this.requested) {
                    RecipeChecker.this.suspended = true;
                    return ImmutableList.of();
                }
                if (!RecipeHelper.canCraft(wr, inventory)) continue;
                craftable.add(wr);
            }
            tmpAll.removeAll(craftable);
            if (!craftable.isEmpty()) {
                for (int recursion = 0; recursion < maxRecursion; ++recursion) {
                    if (RecipeChecker.this.requested) {
                        RecipeChecker.this.suspended = true;
                        return ImmutableList.of();
                    }
                    if (tmpAll.isEmpty()) break;
                    LinkedList<WrappedRecipe> tmpCraftable = new LinkedList<WrappedRecipe>(craftable);
                    for (WrappedRecipe wr : tmpAll) {
                        if (RecipeChecker.this.requested) {
                            RecipeChecker.this.suspended = true;
                            return ImmutableList.of();
                        }
                        if (!RecipeHelper.canCraft(wr, inventory, tmpCraftable, maxRecursion)) continue;
                        craftable.add(wr);
                    }
                    tmpAll.removeAll(craftable);
                    if (tmpCraftable.size() == craftable.size()) break;
                }
            }
            if (RecipeChecker.this.requested) {
                RecipeChecker.this.suspended = true;
                return ImmutableList.of();
            }
            Collections.sort(craftable, WrappedRecipe.Sorter.INSTANCE);
            Ref.LOGGER.info(String.format("%d/%d craftable | %.4f seconds", craftable.size(), recipesToCheck.size(), (double)(System.currentTimeMillis() - startTime) / 1000.0));
            return craftable;
        }
    }
}

