/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.recipe;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.lepko.easycrafting.core.recipe.handler.ForestryRecipeHandler;
import net.lepko.easycrafting.core.recipe.handler.ForgeRecipeHandler;
import net.lepko.easycrafting.core.recipe.handler.IC2RecipeHandler;
import net.lepko.easycrafting.core.recipe.handler.IRecipeHandler;
import net.lepko.easycrafting.core.recipe.handler.MekanismRecipeHandler;
import net.lepko.easycrafting.core.recipe.handler.VanillaRecipeHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class RecipeManager {
    public static final List<IRecipeHandler> HANDLERS = new LinkedList<IRecipeHandler>();
    private static final List<WrappedRecipe> allRecipes;
    private static int prevListSize;
    private static IRecipe prevLastElement;

    private static boolean shouldScan(List<IRecipe> recipes) {
        if (allRecipes.isEmpty()) {
            return true;
        }
        if (prevListSize != recipes.size() || !recipes.isEmpty() && prevLastElement != recipes.get(recipes.size() - 1)) {
            Ref.LOGGER.warn("|~| A MOD IS ADDING RECIPES TOO LATE |~| Class=" + recipes.get(recipes.size() - 1).getClass().getCanonicalName());
            return true;
        }
        return false;
    }

    public static void scanRecipes() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        if (!RecipeManager.shouldScan(recipes)) {
            return;
        }
        prevListSize = recipes.size();
        prevLastElement = (IRecipe)recipes.get(recipes.size() - 1);
        allRecipes.clear();
        long startTime = System.nanoTime();
        int fails = 0;
        for (IRecipe r : recipes) {
            WrappedRecipe wr = WrappedRecipe.of(r);
            if (wr != null) {
                allRecipes.add(wr);
                continue;
            }
            ++fails;
        }
        Collections.sort(allRecipes, WrappedRecipe.Sorter.INSTANCE);
        Ref.LOGGER.info(String.format("Scanned %d recipes (%d failed) in %.8f seconds", recipes.size(), fails, (double)(System.nanoTime() - startTime) / 1.0E9));
    }

    public static List<WrappedRecipe> getAllRecipes() {
        return ImmutableList.copyOf(allRecipes);
    }

    public static InventoryCrafting getCraftingInventory(List<ItemStack> usedIngredients) {
        InventoryCrafting ic = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                return false;
            }

            public void func_75130_a(IInventory p_75130_1_) {
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (i < usedIngredients.size()) {
                ic.func_70299_a(i, usedIngredients.get(i));
                continue;
            }
            ic.func_70299_a(i, null);
        }
        return ic;
    }

    static {
        HANDLERS.add(new IC2RecipeHandler());
        HANDLERS.add(new ForestryRecipeHandler());
        HANDLERS.add(new MekanismRecipeHandler());
        HANDLERS.add(new VanillaRecipeHandler());
        HANDLERS.add(new ForgeRecipeHandler());
        allRecipes = new LinkedList<WrappedRecipe>();
        prevListSize = 0;
        prevLastElement = null;
    }
}

