/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.recipe;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.recipe.handler.IRecipeHandler;
import net.lepko.easycrafting.core.util.StackUtils;
import net.lepko.easycrafting.core.util.WrappedStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class WrappedRecipe {
    public final IRecipe recipe;
    public final List<Object> inputs;
    public final List<WrappedStack> collatedInputs;
    private final WrappedStack output;
    public final IRecipeHandler handler;
    public final List<ItemStack> usedIngredients;

    private WrappedRecipe(IRecipe recipe, List<Object> inputs, WrappedStack output, IRecipeHandler handler) {
        this.recipe = recipe;
        this.inputs = inputs;
        this.collatedInputs = StackUtils.collateStacks(inputs);
        this.output = output;
        this.handler = handler;
        this.usedIngredients = new ArrayList<ItemStack>(9);
    }

    public ItemStack getOutput() {
        return StackUtils.copyStack(this.output.stacks.get(0), this.output.size);
    }

    public static WrappedRecipe of(IRecipe recipe) {
        if (recipe == null) {
            WrappedRecipe.warn("recipe is null", new Object[0]);
            return null;
        }
        if (recipe.func_77571_b() == null) {
            WrappedRecipe.warn("recipe output is null", recipe);
            return null;
        }
        if (recipe.func_77571_b().func_77973_b() == null) {
            WrappedRecipe.warn("recipe output item is null [id=" + recipe.func_77571_b().func_77973_b() + "]", recipe);
            return null;
        }
        List<Object> inputs = null;
        IRecipeHandler handler = null;
        for (IRecipeHandler h : RecipeManager.HANDLERS) {
            inputs = h.getInputs(recipe);
            if (inputs == null) continue;
            handler = h;
            break;
        }
        if (inputs == null) {
            WrappedRecipe.warn("failed to get recipe input list", recipe);
            return null;
        }
        inputs.removeAll(Collections.singleton(null));
        if (inputs.isEmpty()) {
            WrappedRecipe.warn("recipe input list is empty", recipe);
            return null;
        }
        for (Object o : inputs) {
            if (o instanceof List) {
                List list = (List)o;
                if (list.isEmpty()) {
                    WrappedRecipe.warn("one of recipe inputs is an empty list", recipe);
                    return null;
                }
                for (Object p : list) {
                    if (p instanceof ItemStack) {
                        ItemStack stack = (ItemStack)p;
                        if (stack.func_77973_b() == null) {
                            WrappedRecipe.warn("one of recipe input items is null [id=" + stack.func_77973_b() + "]", recipe);
                            return null;
                        }
                        stack.field_77994_a = 1;
                        continue;
                    }
                    WrappedRecipe.warn("one of recipe inputs is unknown", o, recipe);
                    return null;
                }
                continue;
            }
            if (o instanceof ItemStack) {
                ItemStack stack = (ItemStack)o;
                if (stack.func_77973_b() == null) {
                    WrappedRecipe.warn("one of recipe input items is null [id=" + stack.func_77973_b() + "]", recipe);
                    return null;
                }
                stack.field_77994_a = 1;
                continue;
            }
            WrappedRecipe.warn("one of recipe inputs is unknown", o, recipe);
            return null;
        }
        return new WrappedRecipe(recipe, inputs, new WrappedStack(recipe.func_77571_b()), handler);
    }

    private static void warn(String msg, Object ... objs) {
        String s = "[WrappedRecipe] " + msg;
        for (Object o : objs) {
            s = s + " (" + o.getClass().getCanonicalName() + ")";
        }
        Ref.LOGGER.warn(s);
    }

    public static enum Sorter implements Comparator<WrappedRecipe>
    {
        INSTANCE;


        @Override
        public int compare(WrappedRecipe first, WrappedRecipe second) {
            ItemStack is1 = first.getOutput();
            ItemStack is2 = second.getOutput();
            int compareName = is1.func_77973_b().func_77667_c(is1).compareTo(is2.func_77973_b().func_77667_c(is2));
            if (compareName != 0) {
                return compareName;
            }
            int compareDamage = Ints.compare((int)is1.func_77960_j(), (int)is2.func_77960_j());
            if (compareDamage != 0) {
                return compareDamage;
            }
            return Ints.compare((int)is1.field_77994_a, (int)is2.field_77994_a) * -1;
        }
    }
}

