/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.recipe.handler;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.recipe.RecipeManager;
import net.lepko.easycrafting.core.recipe.WrappedRecipe;
import net.lepko.easycrafting.core.recipe.handler.IRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class ForestryRecipeHandler
implements IRecipeHandler {
    private static Class<? super IRecipe> shapedRecipeClass = null;
    private static Method inputMethod = null;
    private static Method checkItemMatch = null;

    @Override
    public List<Object> getInputs(IRecipe recipe) {
        ArrayList<Object> ingredients = null;
        if (shapedRecipeClass != null && shapedRecipeClass.isInstance(recipe) && inputMethod != null && checkItemMatch != null) {
            try {
                Object[] input = (Object[])inputMethod.invoke((Object)recipe, new Object[0]);
                ingredients = new ArrayList<Object>(Arrays.asList(input));
            }
            catch (Exception e) {
                Ref.LOGGER.warn("[Forestry Recipe Scan] " + recipe.getClass().getName() + " failed!", (Throwable)e);
                return null;
            }
        }
        return ingredients;
    }

    @Override
    public boolean matchItem(ItemStack target, ItemStack candidate, WrappedRecipe recipe) {
        boolean b;
        try {
            b = (Boolean)checkItemMatch.invoke((Object)recipe.recipe, target, candidate);
        }
        catch (Exception e) {
            Ref.LOGGER.warn("[Forestry Recipe Handler] failed to match item!", (Throwable)e);
            return false;
        }
        return b;
    }

    @Override
    public ItemStack getCraftingResult(WrappedRecipe recipe, List<ItemStack> usedIngredients) {
        return recipe.recipe.func_77572_b(RecipeManager.getCraftingInventory(usedIngredients));
    }

    static {
        if (Loader.isModLoaded((String)"Forestry")) {
            try {
                shapedRecipeClass = Class.forName("forestry.core.utils.ShapedRecipeCustom");
                inputMethod = shapedRecipeClass.getMethod("getIngredients", new Class[0]);
                checkItemMatch = shapedRecipeClass.getDeclaredMethod("checkItemMatch", ItemStack.class, ItemStack.class);
                checkItemMatch.setAccessible(true);
            }
            catch (Exception e) {
                Ref.LOGGER.warn("[Forestry Recipe Scan] Forestry ShapedRecipeCustom.class could not be obtained!", (Throwable)e);
            }
        } else {
            Ref.LOGGER.info("[Forestry Recipe Scan] Disabled.");
        }
    }
}

