/*
 * Decompiled with CFR 0.152.
 */
package net.lepko.easycrafting.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.lepko.easycrafting.Ref;
import net.lepko.easycrafting.core.util.StackUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class InventoryUtils {
    private static final Random RNG = new Random();
    private static final int PLAYER_INVENTORY_SIZE = 36;

    public static int getMainInventorySize(IInventory inv) {
        if (inv instanceof InventoryPlayer) {
            return 36;
        }
        return inv.func_70302_i_();
    }

    public static int getEmptySlot(IInventory inventory) {
        int invSize = InventoryUtils.getMainInventorySize(inventory);
        return InventoryUtils.getEmptySlot(inventory, 0, invSize);
    }

    public static int getEmptySlot(IInventory inventory, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static List<ItemStack> storeContents(IInventory inventory) {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            copy.add(i, ItemStack.func_77944_b((ItemStack)inventory.func_70301_a(i)));
        }
        return copy;
    }

    public static void setContents(IInventory inventory, List<ItemStack> list) {
        if (inventory.func_70302_i_() != list.size()) {
            Ref.LOGGER.warn("Tried to set inventory contents from a list that is not the same size as the inventory; Aborted!");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            inventory.func_70299_a(i, ItemStack.func_77944_b((ItemStack)list.get(i)));
        }
    }

    public static void setContents(IInventory to, IInventory from) {
        int invSize = Math.min(to.func_70302_i_(), from.func_70302_i_());
        for (int i = 0; i < invSize; ++i) {
            to.func_70299_a(i, ItemStack.func_77944_b((ItemStack)from.func_70301_a(i)));
        }
    }

    public static boolean addItemToInventory(IInventory inventory, ItemStack itemstack) {
        int invSize = InventoryUtils.getMainInventorySize(inventory);
        return InventoryUtils.addItemToInventory(inventory, itemstack, 0, invSize);
    }

    public static boolean addItemToInventory(IInventory inventory, ItemStack itemstack, int start, int end) {
        int slot;
        ItemStack is;
        List<ItemStack> contents = InventoryUtils.storeContents(inventory);
        int maxStack = Math.min(inventory.func_70297_j_(), itemstack.func_77976_d());
        for (int i = start; i < end; ++i) {
            if (!StackUtils.areEqualNoSize(itemstack, inventory.func_70301_a(i))) continue;
            is = inventory.func_70301_a(i);
            if (is.field_77994_a >= maxStack) continue;
            if (is.field_77994_a + itemstack.field_77994_a <= maxStack) {
                is.field_77994_a += itemstack.field_77994_a;
                inventory.func_70296_d();
                return true;
            }
            itemstack.field_77994_a -= maxStack - is.field_77994_a;
            is.field_77994_a = maxStack;
        }
        while ((slot = InventoryUtils.getEmptySlot(inventory, start, end)) != -1) {
            if (itemstack.field_77994_a <= maxStack) {
                inventory.func_70299_a(slot, itemstack.func_77946_l());
                inventory.func_70296_d();
                return true;
            }
            is = itemstack.func_77946_l();
            itemstack.field_77994_a -= maxStack;
            is.field_77994_a = maxStack;
            inventory.func_70299_a(slot, is);
        }
        InventoryUtils.setContents(inventory, contents);
        return false;
    }

    public static boolean consumeItemForCrafting(IInventory inventory, int inventoryIndex, List<ItemStack> usedIngredients) {
        ItemStack stack = inventory.func_70298_a(inventoryIndex, 1);
        if (stack != null) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                ItemStack containerStack = stack.func_77973_b().getContainerItem(stack);
                if (containerStack.func_77984_f() && containerStack.func_77960_j() > containerStack.func_77958_k()) {
                    containerStack = null;
                }
                if (containerStack != null && !InventoryUtils.addItemToInventory(inventory, containerStack)) {
                    if (inventory.func_70301_a(inventoryIndex) != null) {
                        ++inventory.func_70301_a((int)inventoryIndex).field_77994_a;
                    } else {
                        inventory.func_70299_a(inventoryIndex, stack);
                    }
                    return false;
                }
            }
            usedIngredients.add(stack);
            inventory.func_70296_d();
            return true;
        }
        return false;
    }

    public static void readStacksFromNBT(ItemStack[] stacks, NBTTagList nbt) {
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound tag = nbt.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= stacks.length) continue;
            stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public static NBTTagList writeStacksToNBT(ItemStack[] stacks) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack stack = stacks[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        return itemList;
    }

    public static void dropItems(TileEntity te) {
        if (te instanceof IInventory) {
            InventoryUtils.dropItems(te, InventoryUtils.createSlotArray(0, ((IInventory)te).func_70302_i_()));
        }
    }

    public static void dropItems(TileEntity te, int[] slots) {
        if (te instanceof IInventory) {
            double x = (double)te.field_145851_c + 0.5;
            double y = (double)te.field_145848_d + 0.5;
            double z = (double)te.field_145849_e + 0.5;
            IInventory inv = (IInventory)te;
            for (int slot : slots) {
                InventoryUtils.dropItem(te.func_145831_w(), x, y, z, inv.func_70301_a(slot));
            }
        }
    }

    public static void dropItem(World world, double x, double y, double z, ItemStack stack) {
        if (stack != null) {
            EntityItem drop = new EntityItem(world, x, y, z, stack.func_77946_l());
            float speed = 0.05f;
            drop.field_70159_w = (float)RNG.nextGaussian() * speed;
            drop.field_70181_x = (float)RNG.nextGaussian() * speed + 0.2f;
            drop.field_70179_y = (float)RNG.nextGaussian() * speed;
            world.func_72838_d((Entity)drop);
        }
    }

    public static ItemStack decreaseStackSize(IInventory inv, int slotIndex, int amount) {
        ItemStack stack = inv.func_70301_a(slotIndex);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                ItemStack is = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    inv.func_70299_a(slotIndex, null);
                } else {
                    inv.func_70296_d();
                }
                inv.func_70296_d();
                return is;
            }
            inv.func_70299_a(slotIndex, null);
            inv.func_70296_d();
        }
        return stack;
    }

    public static ItemStack getStackInSlotOnClosing(IInventory inv, int slotIndex) {
        ItemStack stack = inv.func_70301_a(slotIndex);
        inv.func_70299_a(slotIndex, null);
        return stack;
    }

    public static int[] createSlotArray(int first, int last) {
        int[] slots = new int[last - first];
        for (int i = first; i < last; ++i) {
            slots[i - first] = i;
        }
        return slots;
    }
}

