/*
 * Decompiled with CFR 0.152.
 */
package RCM.Renders;

import RCM.Entities.EntityRCOctocopter;
import RCM.Entities.GlobalEntity;
import RCM.Models.Model;
import RCM.Models.ModelLoader;
import RCM.Renders.GlobalRender;
import cpw.mods.fml.common.FMLLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderRCOctocopter
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("rcm:textures/models/rcoctocopterskin.png");
    public Model propellerCW = null;
    public Model propellerBlur = null;
    public Model propellerCCW = null;

    public RenderRCOctocopter() {
        this.field_76989_e = 0.0f;
        String filePath = "rcm:models/rcoctocopter.rcm";
        try {
            this.mainBody = ModelLoader.loadModel(filePath, "MainBody");
            this.propellerCW = ModelLoader.loadModel(filePath, "PropellerCW");
            this.propellerCCW = ModelLoader.loadModel(filePath, "PropellerCCW");
            this.propellerBlur = ModelLoader.loadModel(filePath, "PropellerBlur");
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Octocopter model file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Octocopter model file loaded incorrectly!!", (Object[])new Object[0]);
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        Vector3f localTrans;
        int i;
        boolean mirror = false;
        EntityRCOctocopter octoenity = (EntityRCOctocopter)rcentity;
        for (i = 0; i < octoenity.helper.getTorqueQuant(); ++i) {
            localTrans = new Vector3f();
            localTrans = octoenity.helper.getPosition(i, new Quat4f());
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)(localTrans.y - 0.005f), (float)localTrans.z);
            GL11.glRotatef((float)(-octoenity.prevMotorSpeeds[i] - (octoenity.motorSpeeds[i] - octoenity.prevMotorSpeeds[i]) * timeStep), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            if (!mirror) {
                this.drawObject(this.propellerCW);
            } else {
                this.drawObject(this.propellerCCW);
            }
            mirror = !mirror;
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        for (i = 0; i < octoenity.helper.getTorqueQuant(); ++i) {
            localTrans = new Vector3f();
            localTrans = octoenity.helper.getPosition(i, new Quat4f());
            GL11.glPushMatrix();
            GL11.glTranslatef((float)localTrans.x, (float)(localTrans.y - 0.005f), (float)localTrans.z);
            GL11.glRotatef((float)(-octoenity.prevMotorSpeeds[i] - (octoenity.motorSpeeds[i] - octoenity.prevMotorSpeeds[i]) * timeStep), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            GL11.glBegin((int)4);
            float visiblility = 0.0f;
            if (octoenity.motorSpeeds[i] - octoenity.prevMotorSpeeds[i] > 100.0f) {
                visiblility = 0.01f * (octoenity.motorSpeeds[i] - octoenity.prevMotorSpeeds[i] - 100.0f);
            } else if (octoenity.motorSpeeds[i] - octoenity.prevMotorSpeeds[i] < -100.0f) {
                visiblility = -0.01f * (octoenity.motorSpeeds[i] - octoenity.prevMotorSpeeds[i] + 100.0f);
            }
            if (visiblility > 1.0f) {
                visiblility = 1.0f;
            } else if (visiblility < 0.0f) {
                visiblility = 0.0f;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visiblility);
            this.drawObject(this.propellerBlur);
            GL11.glEnd();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.textureLocation;
    }
}

