/*
 * Decompiled with CFR 0.152.
 */
package RCM.Renders;

import RCM.Entities.EntityRCPlane;
import RCM.Entities.GlobalEntity;
import RCM.Models.Model;
import RCM.Models.ModelLoader;
import RCM.Renders.GlobalRender;
import cpw.mods.fml.common.FMLLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderRCPlane
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("rcm:textures/models/rctrainerskin.png");
    public Model rightAileron = null;
    public Model leftAileron = null;
    public Model rudder = null;
    public Model elevator = null;
    public Model propeller = null;
    public Model propellerBlur = null;
    public Model frontGear = null;
    public Model wheel = null;

    public RenderRCPlane() {
        this.field_76989_e = 0.0f;
        String filePath = "rcm:models/rctrainerplane.rcm";
        try {
            this.mainBody = ModelLoader.loadModel(filePath, "MainBody");
            this.rightAileron = ModelLoader.loadModel(filePath, "RightAileron");
            this.leftAileron = ModelLoader.loadModel(filePath, "LeftAileron");
            this.rudder = ModelLoader.loadModel(filePath, "Rudder");
            this.elevator = ModelLoader.loadModel(filePath, "Elevator");
            this.propeller = ModelLoader.loadModel(filePath, "Propeller");
            this.propellerBlur = ModelLoader.loadModel(filePath, "PropellerBlur");
            this.frontGear = ModelLoader.loadModel(filePath, "FrontGear");
            this.wheel = ModelLoader.loadModel(filePath, "Wheel");
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer model file loaded incorrectly!!", (Object[])new Object[0]);
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        for (int i = 0; i < rcentity.helper.getNumberOfWheels(); ++i) {
            GL11.glPushMatrix();
            Vector3f wheelPos = rcentity.helper.getWheelPosition(i, new Quat4f());
            GL11.glTranslatef((float)wheelPos.x, (float)(wheelPos.y - 0.15f), (float)wheelPos.z);
            GL11.glRotatef((float)(rcentity.physicsWorld.vehicle.getWheelInfo((int)i).steering * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)4);
            this.drawObject(this.wheel);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        EntityRCPlane trainerenity = (EntityRCPlane)rcentity;
        Vector3f localTrans = new Vector3f();
        Vector3f rotateAxis = new Vector3f();
        localTrans.set(0.0f, -0.15017f, 0.20623f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(-0.093f, 0.0f, 0.0f, 0.996f), new Vector3f(0.0f, 1.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(rcentity.physicsWorld.vehicle.getWheelInfo((int)0).steering * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.frontGear);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set((Tuple3f)trainerenity.helper.getPosition(0, new Quat4f()));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-trainerenity.prevMotorSpeeds[0] - (trainerenity.motorSpeeds[0] - trainerenity.prevMotorSpeeds[0]) * timeStep), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.propeller);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)(-trainerenity.prevMotorSpeeds[0] - (trainerenity.motorSpeeds[0] - trainerenity.prevMotorSpeeds[0]) * timeStep), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBegin((int)4);
        float visiblility = 0.0f;
        if (trainerenity.motorSpeeds[0] - trainerenity.prevMotorSpeeds[0] < -100.0f) {
            visiblility = -0.01f * (trainerenity.motorSpeeds[0] - trainerenity.prevMotorSpeeds[0] + 100.0f);
        }
        if (visiblility > 1.0f) {
            visiblility = 1.0f;
        } else if (visiblility < 0.0f) {
            visiblility = 0.0f;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visiblility);
        this.drawObject(this.propellerBlur);
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        localTrans.set(-0.45133f, 0.09713f, -0.22248f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.0f, -0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)((trainerenity.prevAileronAngle + (trainerenity.aileronAngle - trainerenity.prevAileronAngle) * timeStep) * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.rightAileron);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.45133f, 0.09713f, -0.22248f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(0.0f, 0.0f, 0.035f, 0.999f), new Vector3f(1.0f, 0.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)((-trainerenity.prevAileronAngle - (trainerenity.aileronAngle - trainerenity.prevAileronAngle) * timeStep) * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.leftAileron);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.0f, 0.08955f, -0.85616f);
        rotateAxis.set((Tuple3f)trainerenity.helper.rotateVector(new Quat4f(-0.112f, 0.0f, 0.0f, 0.994f), new Vector3f(0.0f, 1.0f, 0.0f)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)((-trainerenity.prevRudderAngle - (trainerenity.rudderAngle - trainerenity.prevRudderAngle) * timeStep) * 180.0f / (float)Math.PI), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.rudder);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        localTrans.set(0.0f, -0.01398f, -0.83274f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)localTrans.x, (float)localTrans.y, (float)localTrans.z);
        GL11.glRotatef((float)((-trainerenity.prevElevatorAngle - (trainerenity.elevatorAngle - trainerenity.prevElevatorAngle) * timeStep) * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)4);
        this.drawObject(this.elevator);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.textureLocation;
    }
}

