/*
 * Decompiled with CFR 0.152.
 */
package RCM.Renders;

import RCM.Entities.EntityRCOctocopter;
import RCM.Entities.EntityRCPlane;
import RCM.Entities.GlobalEntity;
import RCM.Items.ItemRemoteControl;
import RCM.Models.Model;
import RCM.Models.ModelFace;
import RCM.Models.ModelLoader;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderRemoteControl
implements IItemRenderer {
    private ResourceLocation textureLocation = new ResourceLocation("rcm:textures/models/remotecontrolskin.png");
    private ResourceLocation textureLocationLight = new ResourceLocation("rcm:textures/items/iconremotecontrolon.png");
    private ResourceLocation textureTrainer = new ResourceLocation("rcm:textures/items/icontrainerplane.png");
    private ResourceLocation textureOctocopter = new ResourceLocation("rcm:textures/items/iconoctocopter.png");
    private Model remoteModel = null;
    private long startTime;
    private long endTime;
    private boolean initTimerSet;
    private float lookTarget;
    public static float renderTicks;
    public static GlobalEntity rcEntity;

    public RenderRemoteControl() {
        try {
            this.remoteModel = ModelLoader.loadModel("rcm:models/remotecontrol.rcm", "RemoteControl");
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case ENTITY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (type) {
            case ENTITY: {
                switch (helper) {
                    case ENTITY_ROTATION: 
                    case ENTITY_BOBBING: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float f6;
        int x = 64;
        int y = 64;
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP entityclientplayermp = mc.field_71439_g;
        ItemRemoteControl remote = (ItemRemoteControl)item.func_77973_b();
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.lookTarget = 0.45f * (entityclientplayermp.field_70127_C + (entityclientplayermp.field_70125_A - entityclientplayermp.field_70127_C) * renderTicks) / 45.0f;
            if (this.lookTarget > 0.45f) {
                this.lookTarget = 0.45f;
            } else if (this.lookTarget < 0.0f) {
                this.lookTarget = 0.0f;
            }
            GL11.glTranslatef((float)0.5f, (float)this.lookTarget, (float)-0.957f);
            GL11.glRotatef((float)-4.3f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)2.05f, (float)1.0f, (float)0.0f, (float)0.0f);
            mc.field_71446_o.func_110577_a(entityclientplayermp.func_110306_p());
            for (int k = 0; k < 2; ++k) {
                int l = k * 2 - 1;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.95f * (float)l));
                GL11.glRotatef((float)(-45 * l), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-80 * l), (float)0.0f, (float)1.0f, (float)0.0f);
                Render render = RenderManager.field_78727_a.func_78713_a((Entity)mc.field_71439_g);
                RenderPlayer renderplayer = (RenderPlayer)render;
                float f1 = 1.0f;
                GL11.glScalef((float)f1, (float)f1, (float)f1);
                renderplayer.func_82441_a((EntityPlayer)mc.field_71439_g);
                GL11.glPopMatrix();
            }
            GL11.glTranslatef((float)-0.28f, (float)0.31f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            f6 = 1.6f;
            GL11.glScalef((float)f6, (float)f6, (float)f6);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glTranslatef((float)0.4f, (float)0.42f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            f6 = 1.8f;
            GL11.glScalef((float)f6, (float)f6, (float)f6);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.1f, (float)0.0f);
            f6 = 1.8f;
            GL11.glScalef((float)f6, (float)f6, (float)f6);
        }
        mc.field_71446_o.func_110577_a(this.textureLocation);
        GL11.glBegin((int)4);
        this.drawObject(this.remoteModel);
        GL11.glEnd();
        float f2 = 0.4f;
        GL11.glScalef((float)f2, (float)f2, (float)f2);
        float f3 = 0.015625f;
        GL11.glScalef((float)f3, (float)f3, (float)f3);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (remote.state) {
            Tessellator tessellator;
            GL11.glPushMatrix();
            if (rcEntity != null && RenderRemoteControl.rcEntity.activated) {
                if (rcEntity instanceof EntityRCPlane) {
                    mc.field_71446_o.func_110577_a(this.textureTrainer);
                } else if (rcEntity instanceof EntityRCOctocopter) {
                    mc.field_71446_o.func_110577_a(this.textureOctocopter);
                }
                float f62 = 0.1f;
                GL11.glTranslatef((float)11.0f, (float)14.0f, (float)-2.22f);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glScalef((float)f62, (float)f62, (float)f62);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDisable((int)2896);
                tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                tessellator.func_78374_a((double)(-x), (double)y, 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)x, (double)y, 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)x, (double)(-y), 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)(-x), (double)(-y), 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            x = 32;
            y = 32;
            mc.field_71446_o.func_110577_a(this.textureLocationLight);
            float f5 = 0.34f;
            GL11.glTranslatef((float)0.0f, (float)-19.38f, (float)-0.43f);
            GL11.glRotatef((float)-6.1f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)f5, (float)f5, (float)f5);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            tessellator.func_78374_a((double)(-x), (double)y, 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)x, (double)y, 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)x, (double)(-y), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(-x), (double)(-y), 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2.22f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        float f4 = 0.25f;
        GL11.glScalef((float)f4, (float)f4, (float)f4);
        this.drawFont(mc, remote, 0, 39);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void drawObject(Model model) {
        for (ModelFace face : model.faces) {
            Vector3f n1 = model.normals.get((int)face.normalIndex.x - 1);
            GL11.glNormal3f((float)n1.x, (float)n1.y, (float)n1.z);
            Vector2f t1 = model.textureCoordinates.get((int)face.textureCoordinateIndex.x - 1);
            GL11.glTexCoord2f((float)t1.x, (float)t1.y);
            Vector3f v1 = model.vertices.get((int)face.vertexIndex.x - 1);
            GL11.glVertex3f((float)v1.x, (float)v1.y, (float)v1.z);
            Vector3f n2 = model.normals.get((int)face.normalIndex.y - 1);
            Vector2f t2 = model.textureCoordinates.get((int)face.textureCoordinateIndex.y - 1);
            GL11.glTexCoord2f((float)t2.x, (float)t2.y);
            GL11.glNormal3f((float)n2.x, (float)n2.y, (float)n2.z);
            Vector3f v2 = model.vertices.get((int)face.vertexIndex.y - 1);
            GL11.glVertex3f((float)v2.x, (float)v2.y, (float)v2.z);
            Vector3f n3 = model.normals.get((int)face.normalIndex.z - 1);
            Vector2f t3 = model.textureCoordinates.get((int)face.textureCoordinateIndex.z - 1);
            GL11.glTexCoord2f((float)t3.x, (float)t3.y);
            GL11.glNormal3f((float)n3.x, (float)n3.y, (float)n3.z);
            Vector3f v3 = model.vertices.get((int)face.vertexIndex.z - 1);
            GL11.glVertex3f((float)v3.x, (float)v3.y, (float)v3.z);
        }
    }

    private void drawFont(Minecraft mc, ItemRemoteControl itemRC, int i, int j) {
        String s1 = "";
        String s2 = "";
        String s3 = "";
        String s4 = "No RC Profile";
        String s5 = "No Signal";
        String s6 = "";
        if (!this.initTimerSet) {
            this.startTime = System.currentTimeMillis();
            this.initTimerSet = true;
        }
        this.endTime = System.currentTimeMillis();
        int remoteTimer = (int)(this.endTime - this.startTime) / 1000;
        if (remoteTimer / 3600 < 10) {
            s1 = "0";
        }
        s2 = s2 + String.valueOf(remoteTimer / 3600);
        if (remoteTimer / 60 < 10) {
            s2 = "0";
        }
        s2 = s2 + String.valueOf(remoteTimer / 60);
        if (remoteTimer - remoteTimer / 3600 * 3600 - remoteTimer / 60 * 60 < 10) {
            s3 = "0";
        }
        s3 = s3 + String.valueOf(remoteTimer - remoteTimer / 3600 * 3600 - remoteTimer / 60 * 60);
        if (rcEntity != null && RenderRemoteControl.rcEntity.activated) {
            s4 = "RC Profile:";
            s5 = "Signal: <<<<<<<";
            if (rcEntity instanceof EntityRCPlane) {
                s6 = "Trainer Plane";
            } else if (rcEntity instanceof EntityRCOctocopter) {
                s6 = "Octocopter";
            }
        }
        if (itemRC.state) {
            mc.field_71466_p.func_78276_b(s4, i - 60, j, 0x66CCFF);
            mc.field_71466_p.func_78276_b(s6, i - 60, j + 10, 0x66CCFF);
            mc.field_71466_p.func_78276_b(s5, i - 60, j + 25, 0x66CCFF);
            mc.field_71466_p.func_78276_b("Timer: " + s1 + ":" + s2 + ":" + s3, i - 33, j + 40, 0x66CCFF);
        }
        if (!itemRC.state) {
            this.startTime = this.endTime;
        }
    }
}

