/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.fluids;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import redgear.core.fluids.AdvFluidTank;
import redgear.core.fluids.FluidUtil;
import redgear.core.inventory.IntentoryStorage;

public class FluidStorage
implements IFluidHandler {
    private final List<AdvFluidTank> tanks = new ArrayList<AdvFluidTank>();

    public int addTank(AdvFluidTank newTank) {
        this.tanks.add(newTank);
        return this.tanks.size() - 1;
    }

    public int tanks() {
        return this.tanks.size();
    }

    private boolean validTank(int index) {
        return index >= 0 && index < this.tanks.size() && this.tanks.get(index) != null;
    }

    public AdvFluidTank getTank(int index) {
        if (this.validTank(index)) {
            return this.tanks.get(index);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int filled = 0;
        for (AdvFluidTank tank : this.tanks) {
            filled = tank.fillWithMap(resource, doFill);
            if (filled <= 0) continue;
            return filled;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack removed = null;
        for (AdvFluidTank tank : this.tanks) {
            removed = tank.drainWithMap(resource, doDrain);
            if (removed.amount <= 0) continue;
            return removed;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack removed = null;
        for (AdvFluidTank tank : this.tanks) {
            removed = tank.drainWithMap(maxDrain, doDrain);
            if (removed == null || removed.amount <= 0) continue;
            return removed;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tankList = new NBTTagList();
        for (int i = 0; i < this.tanks.size(); ++i) {
            AdvFluidTank tank = this.getTank(i);
            if (tank == null) continue;
            NBTTagCompound invTag = new NBTTagCompound();
            invTag.func_74774_a("tank", (byte)i);
            tankList.func_74742_a((NBTBase)tank.writeToNBT(invTag));
        }
        tag.func_74782_a("Tanks", (NBTBase)tankList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("Tanks", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound invTag = tagList.func_150305_b(i);
            byte slot = invTag.func_74771_c("tank");
            AdvFluidTank tank = this.getTank(slot);
            if (tank == null) continue;
            tank.readFromNBT(invTag);
        }
    }

    public void writeFluidStack(NBTTagCompound tag, String name, FluidStack stack) {
        if (stack == null) {
            return;
        }
        tag.func_74782_a(name, (NBTBase)stack.writeToNBT(new NBTTagCompound()));
    }

    public FluidStack readFluidStack(NBTTagCompound tag, String name) {
        NBTTagCompound subTag = tag.func_74775_l(name);
        if (subTag == null) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)subTag);
    }

    public boolean fillTank(IntentoryStorage inventory, int slotFullIndex, int slotEmptyIndex, AdvFluidTank tank) {
        ItemStack fullSlot = inventory.func_70301_a(slotFullIndex);
        if (fullSlot == null || tank == null || !inventory.validSlot(slotEmptyIndex)) {
            return false;
        }
        FluidStack contents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fullSlot);
        ItemStack emptyContainer = FluidUtil.getEmptyContainer(fullSlot);
        if (tank.canFillWithMap(contents, true) && inventory.canAddStack(slotEmptyIndex, emptyContainer)) {
            tank.fillWithMap(contents, true);
            if (emptyContainer != null) {
                inventory.addStack(slotEmptyIndex, emptyContainer);
            }
            inventory.func_70298_a(slotFullIndex, 1);
            return true;
        }
        return false;
    }

    public boolean fillTank(IntentoryStorage inventory, int slotFullIndex, int slotEmptyIndex, int tankIndex) {
        return this.fillTank(inventory, slotFullIndex, slotEmptyIndex, this.getTank(tankIndex));
    }

    public boolean emptyTank(IntentoryStorage inventory, int slotEmptyIndex, int slotFullIndex, AdvFluidTank tank) {
        int capacity;
        ItemStack filled;
        ItemStack emptySlot = inventory.func_70301_a(slotEmptyIndex);
        if (emptySlot == null || tank == null || !inventory.validSlot(slotFullIndex)) {
            return false;
        }
        FluidStack contents = tank.getFluid();
        if (emptySlot != null && contents != null && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)contents.copy(), (ItemStack)emptySlot.func_77946_l())) != null && tank.canDrainWithMap(capacity = FluidUtil.getContainerCapacity(contents, filled)) && inventory.canAddStack(slotFullIndex, filled)) {
            inventory.addStack(slotFullIndex, filled);
            tank.drainWithMap(capacity, true);
            inventory.func_70298_a(slotEmptyIndex, 1);
            return true;
        }
        return false;
    }

    public boolean emptyTank(IntentoryStorage inventory, int slotEmptyIndex, int slotFullIndex, int tankIndex) {
        return this.emptyTank(inventory, slotEmptyIndex, slotFullIndex, this.getTank(tankIndex));
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (AdvFluidTank tank : this.tanks) {
            if (!tank.canAccept(fluid.getID())) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        for (AdvFluidTank tank : this.tanks) {
            if (!tank.canEject(fluid.getID())) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[this.tanks.size()];
        for (int x = 0; x < this.tanks.size(); ++x) {
            info[x] = this.tanks.get(x).getInfo();
        }
        return info;
    }
}

