/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.mod;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import redgear.core.mod.CoreModUtils;
import redgear.core.mod.FileHelper;

public class CoreModConfiguration {
    private final File configFile;
    private final ArrayList<Property> properties = new ArrayList();
    private boolean hasChanged = false;

    public CoreModConfiguration(File file, CoreModUtils util) {
        this.configFile = file;
    }

    public void load() {
        for (String line : FileHelper.readLines(this.configFile)) {
            this.properties.add(new Property(line));
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void save() {
        if (this.hasChanged) {
            ArrayList<String> lines = new ArrayList<String>();
            for (Property prop : this.properties) {
                if (prop.type == Type.Void) continue;
                lines.add(prop.toString());
            }
            FileHelper.writeLines(lines, this.configFile);
        }
    }

    private Property getProperty(String name, Type type) {
        for (Property prop : this.properties) {
            if (prop.type != type || !prop.name.equals(name)) continue;
            return prop;
        }
        return null;
    }

    private Object getValue(String name, Object Default, Type type) {
        Property prop = this.getProperty(name, type);
        if (prop != null) {
            return prop.value;
        }
        this.properties.add(new Property(name, type, Default));
        this.hasChanged = true;
        return Default;
    }

    public boolean getBoolean(String name, boolean Default) {
        return (Boolean)this.getValue(name, Default, Type.Boolean);
    }

    public int getInt(String name, int Default) {
        return (Integer)this.getValue(name, Default, Type.Integer);
    }

    private static class Property {
        public String name;
        public Type type;
        public Object value;

        Property(String line) {
            try {
                List<String> tokens = Arrays.asList(line.split("[=:]"));
                char typeTest = Character.toUpperCase(tokens.get(0).charAt(0));
                for (Type test : Type.values()) {
                    if (typeTest != test.symbol) continue;
                    this.value = test == Type.String ? tokens.get(2) : test.def.getMethod(test.parseFunction, String.class).invoke(null, tokens.get(2));
                    this.name = tokens.get(1);
                    this.type = test;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.name = "";
            this.type = Type.Void;
            this.value = line;
        }

        Property(String name, Type type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.type.symbol + ":" + this.name + "=" + this.value.toString();
        }
    }

    private static enum Type {
        Integer('I', Integer.class, "parseInt"),
        Boolean('B', Boolean.class, "parseBoolean"),
        String('S', String.class, null),
        Void('V', null, null);

        public char symbol;
        public Class<?> def;
        public String parseFunction;

        private Type(char symbol, Class<?> def, String parseFunction) {
            this.symbol = symbol;
            this.def = def;
            this.parseFunction = parseFunction;
        }
    }
}

