/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.render.gui.element;

import java.util.List;
import net.minecraft.util.StatCollector;
import redgear.core.render.GuiBase;
import redgear.core.render.RenderHelper;
import redgear.core.render.gui.element.ElementBase;

public class ElementButton
extends ElementBase {
    int sheetX;
    int sheetY;
    int hoverX;
    int hoverY;
    int disabledX = 0;
    int disabledY = 0;
    boolean disabled = false;
    boolean tooltipLocalized = false;
    String tooltip;
    public String toolTip;

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY);
        this.setName(name);
        this.setSize(sizeX, sizeY);
        this.setTexture(texture, this.texW, this.texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY);
        this.setName(name);
        this.setSize(sizeX, sizeY);
        this.setTexture(texture, this.texW, this.texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
        this.disabledX = disabledX;
        this.disabledY = disabledY;
    }

    @Override
    public void draw() {
        RenderHelper.bindTexture(this.texture);
        if (!this.disabled) {
            if (this.intersectsWith(this.gui.getMouseX(), this.gui.getMouseY())) {
                this.drawTexturedModalRect(this.posX, this.posY, this.hoverX, this.hoverY, this.sizeX, this.sizeY);
            } else {
                this.drawTexturedModalRect(this.posX, this.posY, this.sheetX, this.sheetY, this.sizeX, this.sizeY);
            }
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, this.disabledX, this.disabledY, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tooltip != null) {
            if (this.tooltipLocalized) {
                list.add(this.tooltip);
            } else {
                list.add(StatCollector.func_74838_a((String)this.tooltip));
            }
        }
    }

    public ElementButton setToolTip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ElementButton setToolTipLocalized(boolean localized) {
        this.tooltipLocalized = localized;
        return this;
    }

    public ElementButton clearToolTip() {
        this.tooltip = null;
        return this;
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.disabled) {
            this.gui.handleElementButtonClick(this.getName(), mouseButton);
            return true;
        }
        return false;
    }

    public void setSheetX(int pos) {
        this.sheetX = pos;
    }

    public void setSheetY(int pos) {
        this.sheetY = pos;
    }

    public void setHoverX(int pos) {
        this.hoverX = pos;
    }

    public void setHoverY(int pos) {
        this.hoverY = pos;
    }

    public void setDisabled() {
        this.disabled = true;
    }

    public void setActive() {
        this.disabled = false;
    }
}

