/*
 * Decompiled with CFR 0.152.
 */
package redgear.core.util;

import cpw.mods.fml.common.Loader;
import java.io.File;
import net.minecraft.util.ResourceLocation;

public class StringHelper {
    public static final String slash = File.separator;

    public static String camelCase(String init) {
        if (init == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(init.length());
        for (String word : init.split(" ")) {
            if (word.isEmpty()) continue;
            ret.append(word.substring(0, 1).toUpperCase());
            ret.append(word.substring(1).toLowerCase());
        }
        return ret.toString();
    }

    public static String concat(Object ... values) {
        StringBuilder build = new StringBuilder();
        for (Object bit : values) {
            build.append(bit);
        }
        return build.toString();
    }

    public static String getModId() {
        return Loader.instance().activeModContainer().getModId();
    }

    public static String parseModAsset() {
        return StringHelper.concat(StringHelper.getModId(), ":");
    }

    public static String parseTextureFile(String modId, String folder, String textureName) {
        return StringHelper.concat("/assets/", modId, "/", folder, "/", textureName, ".png");
    }

    public static File parseConfigFile(File configDir) {
        return StringHelper.parseConfigFile(configDir, StringHelper.getModId());
    }

    public static File parseConfigFile(File configDir, String modID) {
        return new File(configDir, modID.replace("_", slash) + ".cfg");
    }

    public static String parseUnLocalName(String name) {
        return StringHelper.concat(StringHelper.getModId().replace('_', '.'), ".", name);
    }

    public static ResourceLocation parseModelTexture(String modId, String textureName) {
        return new ResourceLocation(modId, StringHelper.concat("textures/models/", textureName, ".png"));
    }
}

