/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.BuilderBlockData;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BuilderEmptyCave
extends BuilderBase {
    boolean[][][] map;
    boolean[][][] map2;
    BuilderBlockData caveBlock = new BuilderBlockData(Blocks.field_150350_a);
    int initChance = 50;
    int size = 48;
    int height = 28;
    int posY;
    int boss = 0;
    boolean spawnBoss = false;
    World world;

    @Override
    public BuilderBase load(Properties prop) {
        this.caveBlock = HelperReadConfig.getBlock(prop, "caveBlock", this.caveBlock);
        this.initChance = HelperReadConfig.getIntegerProperty(prop, "initChance", 50);
        this.size = HelperReadConfig.getIntegerProperty(prop, "size", 32);
        this.height = HelperReadConfig.getIntegerProperty(prop, "height", 28);
        this.posY = HelperReadConfig.getIntegerProperty(prop, "posY", 20);
        this.boss = HelperReadConfig.getIntegerProperty(prop, "boss", 3);
        this.spawnBoss = HelperReadConfig.getBooleanProperty(prop, "spawnBoss", false);
        return this;
    }

    @Override
    public void generate(Random random, World world, int i, int j, int mob) {
        this.generate(random, world, i, this.posY, j, mob);
    }

    public void generateWithSize(Random random, World world, int i, int j, int k, int size) {
        this.size = size;
        this.generate(random, world, i, j, k, 1);
    }

    @Override
    public String getName() {
        return "emptyCave";
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        int width = 32;
        int rooms = Math.max(1, width / 8);
        int[][] roomsDecoration = new int[rooms][rooms];
        boolean wallBlock = true;
        int wallX = random.nextInt(width / rooms - 1) + 4;
        boolean currentWallX = false;
        int roomWidth = width / rooms;
        boolean doorX = false;
        boolean doorZ = false;
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int wallSize = Math.max(1, width / 15);
        int freq = 2;
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.size; ++z) {
                    float noiseVar = Math.max(0.0f, 2.0f - (float)y / 2.0f);
                    noiseVar += Math.max(0.0f, 3.0f - (float)(this.height - y) / 2.0f);
                    noiseVar += (float)Math.max(0, wallSize - x / freq);
                    noiseVar += (float)Math.max(0, wallSize - (this.size - x - 1) / freq);
                    noiseVar += (float)Math.max(0, wallSize - z / freq);
                    noiseVar += (float)Math.max(0, wallSize - (this.size - z - 1) / freq);
                    if (!(p.getNoiseAt(x + i, y + j, z + k) * p2.getNoiseAt(x + i, y + j, z + k) * (double)noiseVar < 0.5)) continue;
                    world.func_147449_b(i + x, j + y, k + z, this.caveBlock.id);
                }
            }
        }
        int y = 0;
        int half = this.size / 2;
        while (world.func_147439_a(i + half, j + y, k + half) != Blocks.field_150350_a && world.func_147439_a(i + half, j + y, k + half).func_149688_o() != Material.field_151586_h) {
            ++y;
        }
    }
}

