/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.decorator;

import com.chocolate.chocolateQuest.builder.decorator.BuildingProperties;
import com.chocolate.chocolateQuest.builder.decorator.TowerSquare;
import com.chocolate.chocolateQuest.builder.decorator.rooms.RoomStairs;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TowerRound
extends TowerSquare {
    public TowerRound(BuildingProperties properties) {
        super(properties);
    }

    @Override
    public void buildTower(Random random, World world, int x, int y, int z, ForgeDirection direction) {
        int h;
        int floors = Math.max(1, this.floors - 1 + random.nextInt(5));
        int radioExtended = this.radio + 1;
        int radioDecreased = this.radio - 1;
        RoomStairs stairs = new RoomStairs();
        stairs.configure(this.radio * 2 - 2, this.radio * 2 - 2, this.properties);
        stairs.clearWalls();
        int currentY = y + floors * (this.properties.floorHeight + 1);
        this.buildRoof(random, world, x += this.radio * direction.offsetX, y, z += this.radio * direction.offsetZ, floors);
        for (h = 0; h <= floors; ++h) {
            for (int px = -radioExtended; px < radioExtended; ++px) {
                for (int pz = -radioExtended; pz < radioExtended; ++pz) {
                    int i;
                    int dist = px * px + pz * pz;
                    int blockX = x + px;
                    int blockY = currentY;
                    int blockZ = z + pz;
                    if (dist < this.radio * this.radio) {
                        this.properties.floor.generateFloor(world, blockX, blockY, blockZ);
                        world.func_147449_b(blockX, blockY + this.properties.floorHeight, blockZ, this.properties.wallBlock.id);
                        for (i = 1; i < this.properties.floorHeight - 1; ++i) {
                            world.func_147449_b(blockX, blockY + i, blockZ, Blocks.field_150350_a);
                        }
                        if (dist < radioDecreased * radioDecreased) continue;
                        stairs.placeRandomDecorationBlock(random, world, blockX, blockY + 1, blockZ, 0);
                        continue;
                    }
                    if (dist >= radioExtended * radioExtended) continue;
                    for (i = 0; i <= this.properties.floorHeight; ++i) {
                        world.func_147449_b(blockX, blockY + i, blockZ, this.properties.wallBlock.id);
                    }
                    this.properties.window.generateWindowX(world, blockX, blockY + 1, blockZ);
                }
            }
            stairs.addRoomDecoration(random, world, x - this.radio, currentY + 1, z - this.radio + 1);
            currentY -= this.properties.floorHeight + 1;
        }
        x -= this.radio * direction.offsetX;
        z -= this.radio * direction.offsetZ;
        for (h = 0; h < this.floors + 1; ++h) {
            int posY = y + 1 + h * (this.properties.floorHeight + 1);
            this.properties.doors.generate(random, world, x, posY, z, direction);
        }
    }

    public void buildRoof(Random random, World world, int x, int y, int z, int floors) {
        int currentY = y + floors * this.properties.floorHeight + 1;
        int radioExtended = this.radio + 1;
        if (this.properties.roof.floorType == this.properties.roof.PYRAMID || this.properties.roof.floorType == this.properties.roof.TRIANGLE) {
            int texasRadio = this.radio;
            int texasRadioExtended = texasRadio + 1;
            int steps = 2;
            for (int h = 0; h <= this.radio * steps; ++h) {
                for (int px = -texasRadioExtended; px < texasRadioExtended; ++px) {
                    for (int pz = -texasRadioExtended; pz < texasRadioExtended; ++pz) {
                        int dist = px * px + pz * pz;
                        int blockX = x + px;
                        int blockY = currentY + (this.properties.floorHeight + 1) + h;
                        int blockZ = z + pz;
                        if (dist < texasRadio * texasRadio || dist >= texasRadioExtended * texasRadioExtended) continue;
                        world.func_147449_b(blockX, blockY, blockZ, this.properties.roof.roofBlock);
                    }
                }
                if (h % steps != 0) continue;
                texasRadioExtended = --texasRadio + 1;
            }
        } else {
            for (int px = -radioExtended; px < radioExtended; ++px) {
                for (int pz = -radioExtended; pz < radioExtended; ++pz) {
                    int dist = px * px + pz * pz;
                    int blockX = x + px;
                    int blockY = currentY + (this.properties.floorHeight + 1);
                    int blockZ = z + pz;
                    if (dist < this.radio * this.radio) {
                        world.func_147449_b(blockX, blockY, blockZ, this.properties.wallBlock.id);
                        continue;
                    }
                    if (dist >= radioExtended * radioExtended) continue;
                    world.func_147449_b(blockX, blockY, blockZ, this.properties.wallBlock.id);
                    this.properties.roof.setRoofBlock(world, blockX, blockY + 1, blockZ);
                }
            }
        }
    }
}

