/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.ai.AIBossAttack;
import com.chocolate.chocolateQuest.entity.ai.AITargetHurtBy;
import com.chocolate.chocolateQuest.entity.boss.AttackPunch;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.EntityHookShoot;
import com.chocolate.chocolateQuest.packets.PacketAttackToXYZ;
import com.chocolate.chocolateQuest.particles.EffectManager;
import com.chocolate.chocolateQuest.utils.BDHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySpiderBoss
extends EntityBaseBoss {
    public AttackPunch rightHand;
    public AttackPunch leftHand;
    public int attackTimeLeft = 0;
    public int attackTimeRight = 0;
    public int attackSpeed = 10;
    int projectileCoolDown;
    EntityHookShoot web;
    EntityHookShoot escapeWeb;

    public EntitySpiderBoss(World par1World) {
        super(par1World);
        this.ridableBB = false;
        this.leftHand = new AttackPunch(this, 5, 0.2f, 2.0f);
        this.leftHand.setAngle(-55, 2, 0.4f);
        this.rightHand = new AttackPunch(this, 6, 0.2f, 2.0f);
        this.rightHand.setAngle(55, 2, 0.4f);
        this.projectileDefense = 10;
        this.magicDefense = -20;
        this.limitRotation = true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(46.0);
    }

    @Override
    protected void scaleAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2 + (double)this.lvl * 0.02);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(14.0 + (double)this.lvl * 0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0 + (double)this.lvl * 250.0);
    }

    @Override
    public void addAITasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBossAttack(this, 1.0f, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AITargetHurtBy(this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
    }

    @Override
    public float getMinSize() {
        return 0.6f;
    }

    @Override
    public float getSizeVariation() {
        return 0.4f;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f) {
                float rot = this.field_70177_z * 3.1416f / 180.0f;
                double scale = this.field_70130_N / 2.0f;
                double posX = this.field_70165_t - (double)MathHelper.func_76126_a((float)rot) * scale;
                double posY = this.field_70163_u + (double)this.field_70131_O * 0.3;
                double posZ = this.field_70161_v + (double)MathHelper.func_76134_b((float)rot) * scale;
                float desp = this.field_70130_N * 0.05f;
                EffectManager.spawnParticle(2, this.field_70170_p, posX + this.field_70146_Z.nextGaussian() * (double)desp, posY + 0.2, posZ + this.field_70146_Z.nextGaussian() * (double)desp, 0.0 + (double)(this.field_70146_Z.nextFloat() / 8.0f), 0.3 + (double)(this.field_70146_Z.nextFloat() / 4.0f), 0.0 + (double)(this.field_70146_Z.nextFloat() / 8.0f));
            }
        } else if (this.func_70638_az() == null && this.escapeWeb == null && !this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
            this.escapeWeb = new EntityHookShoot(this.field_70170_p, (EntityLivingBase)this, 3);
            this.escapeWeb.field_70181_x = 2.6;
            this.escapeWeb.field_70159_w = 0.0;
            this.escapeWeb.field_70179_y = 0.0;
            this.field_70170_p.func_72838_d((Entity)this.escapeWeb);
        }
        if (this.web != null && this.web.isReeling()) {
            boolean setHookDead = false;
            if (this.web.hookedEntity != null) {
                if (this.func_70638_az() != this.web.hookedEntity && this.web.hookedEntity instanceof EntityLivingBase) {
                    this.func_70624_b((EntityLivingBase)this.web.hookedEntity);
                }
            } else if (this.func_70638_az() != null && this.func_70068_e((Entity)this.web) < this.func_70068_e((Entity)this.func_70638_az())) {
                setHookDead = true;
            }
            if (this.web.field_70173_aa > 100 || setHookDead) {
                this.web.func_70106_y();
                this.web = null;
            }
        }
        if (this.escapeWeb != null) {
            if (!this.escapeWeb.isReeling()) {
                this.escapeWeb.field_70181_x -= 0.2;
            }
            if (this.escapeWeb.radio > (double)this.size) {
                this.escapeWeb.radio -= 1.0;
            }
            if (this.escapeWeb.field_70173_aa > 100 && this.field_70122_E || this.escapeWeb.hookedEntity != null || this.escapeWeb.field_70173_aa > 300) {
                this.escapeWeb.func_70106_y();
            }
            if (!this.escapeWeb.func_70089_S()) {
                this.escapeWeb = null;
            }
            if (this.field_70123_F || this.field_70124_G) {
                this.field_70181_x = 0.0;
            }
        }
        if (!this.field_70128_L) {
            this.rightHand.onUpdate();
            this.leftHand.onUpdate();
        }
        super.func_70071_h_();
    }

    @Override
    public void attackToXYZ(byte arm, double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K) {
            PacketAttackToXYZ packet = new PacketAttackToXYZ(this.func_145782_y(), arm, x, y, z);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
        }
        if (arm == 5) {
            this.leftHand.swingArmTo(x, y, z);
        } else {
            this.rightHand.swingArmTo(x, y, z);
        }
    }

    @Override
    public void func_70785_a(Entity target, float par2) {
        if (!this.attackInProgress()) {
            if (this.projectileCoolDown < 60) {
                ++this.projectileCoolDown;
                if (this.projectileCoolDown == 54) {
                    this.func_71038_i();
                }
            } else {
                this.projectileCoolDown = this.field_70146_Z.nextInt(30);
                if (this.field_70146_Z.nextInt(3) == 0 && this.web == null) {
                    this.shootWeb();
                } else if (!this.field_70170_p.field_72995_K) {
                    EntityBaseBall ball = new EntityBaseBall(this.field_70170_p, (EntityLivingBase)this, 0, 0);
                    ball.func_70186_c(target.field_70165_t - this.field_70165_t, target.field_70163_u - this.field_70163_u, target.field_70161_v - this.field_70161_v, 1.0f, 0.0f);
                    ball.field_70163_u -= (double)(this.field_70131_O / 2.0f);
                    this.field_70170_p.func_72838_d((Entity)ball);
                }
            }
        }
        if (!(this.field_70173_aa % (this.attackSpeed + 1) != 0 || this.field_70170_p.field_72995_K || this.leftHand.attackInProgress() && this.rightHand.attackInProgress())) {
            double posY = this.field_70163_u + (double)this.size;
            int angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this, target) - (double)this.field_70177_z));
            double dx = this.field_70165_t - target.field_70165_t;
            double targetY = target.field_70163_u + (double)target.field_70131_O;
            double dy = this.field_70163_u + (double)this.size - targetY;
            double dz = this.field_70161_v - target.field_70161_v;
            double distToHead = dx * dx + dy * dy + dz * dz - (double)(this.field_70130_N * this.field_70130_N);
            if (distToHead < (this.rightHand.getArmLength() + 1.0) * (this.rightHand.getArmLength() + 1.0)) {
                boolean targetDown = this.field_70163_u - target.field_70163_u - (double)target.field_70131_O > 0.0;
                boolean handFlag = this.field_70146_Z.nextBoolean();
                boolean ARM_LEFT = false;
                boolean ARM_RIGHT = true;
                handFlag = this.field_70146_Z.nextBoolean();
                if (!targetDown) {
                    if (!handFlag) {
                        if (this.leftHand.attackInProgress() || angle > 20) {
                            handFlag = true;
                        }
                    } else if (this.rightHand.attackInProgress() || angle < -20) {
                        handFlag = false;
                    }
                }
                if (angle > -110 && angle < 110 || targetDown) {
                    if (!handFlag && !this.leftHand.attackInProgress()) {
                        this.leftHand.attackTarget(target);
                    } else if (handFlag && !this.rightHand.attackInProgress()) {
                        this.rightHand.attackTarget(target);
                    }
                }
            }
        }
        super.func_70785_a(target, par2);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.escapeWeb == null && this.field_70146_Z.nextInt(10) == 0) {
            this.shootEscapeWeb();
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void shootWeb() {
        if (!this.field_70170_p.field_72995_K) {
            boolean pos = false;
            if (this.web != null) {
                this.web.func_70106_y();
                this.web = null;
            }
            EntityLivingBase t = this.func_70638_az();
            this.web = new EntityHookShoot(this.field_70170_p, (EntityLivingBase)this, 3);
            this.web.func_70186_c(t.field_70165_t - this.field_70165_t, t.field_70163_u - this.field_70163_u - (double)(this.field_70131_O / 2.0f), t.field_70161_v - this.field_70161_v, 1.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)this.web);
        }
    }

    public void shootEscapeWeb() {
        if (!this.field_70170_p.field_72995_K) {
            boolean pos = false;
            if (this.escapeWeb != null) {
                this.escapeWeb.func_70106_y();
                this.escapeWeb = null;
            }
            this.escapeWeb = new EntityHookShoot(this.field_70170_p, (EntityLivingBase)this, 5);
            this.escapeWeb.field_70181_x = 2.5;
            this.escapeWeb.field_70159_w = this.field_70146_Z.nextGaussian();
            this.escapeWeb.field_70179_y = this.field_70146_Z.nextGaussian();
            this.field_70170_p.func_72838_d((Entity)this.escapeWeb);
        }
    }

    public void func_70110_aj() {
    }

    @Override
    public boolean attackInProgress() {
        return this.leftHand.isAttacking || this.rightHand.isAttacking || this.field_82175_bq;
    }

    public boolean func_70093_af() {
        return true;
    }

    public double getArmLength() {
        return this.size;
    }

    @Override
    protected void resize() {
        this.func_70105_a(this.size * 1.4f, this.size);
    }

    protected void func_70069_a(float par1) {
    }

    protected String func_70639_aQ() {
        return "mob.spider.say";
    }

    protected String func_70621_aR() {
        return "mob.spider.say";
    }

    protected String func_70673_aS() {
        return "mob.spider.death";
    }
}

