/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.magic;

import com.chocolate.chocolateQuest.magic.ElementDamageSource;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceBlast;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceDark;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceFire;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceLight;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceMagic;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceNature;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;

public enum Elements {
    physic("physic", new ElementDamageSourceNature(), 1.0, "2", "physic", 0x88AA88),
    magic("magic", new ElementDamageSourceMagic(), 1.0, "3", "magic", 0x33CCFF),
    blast("blast", new ElementDamageSourceBlast(), 1.0, "5", "blast", 0x9999CC),
    fire("fire", new ElementDamageSourceFire(), 1.0, "6", "fire", 0xFF9900),
    light("light", new ElementDamageSourceLight(), 1.0, "e", "light", 0xFFFF99),
    darkness("darkness", new ElementDamageSourceDark(), 1.0, "8", "dark", 0x440044);

    String name;
    public ElementDamageSource damageSource;
    public double ammountMultiplier;
    public String stringColor;
    public String particle;
    int color;

    private Elements(String s, ElementDamageSource ds, double dmgMultiplier, String stringColor, String particle, int color) {
        this.name = s;
        this.damageSource = ds;
        this.ammountMultiplier = dmgMultiplier;
        this.stringColor = stringColor;
        this.particle = particle;
        this.color = color;
    }

    public DamageSource getDamageSource(Entity shooter) {
        return this.damageSource.getDamageSource(shooter, this.name);
    }

    public DamageSource getDamageSourceIndirect(Entity shooter, Entity projectile) {
        return this.damageSource.getIndirectDamage(projectile, shooter, this.name);
    }

    public DamageSource getDamageSource() {
        return this.damageSource.getDamageSource(this.name);
    }

    public float onHitEntity(Entity source, Entity entityHit, float damage) {
        return this.damageSource.onHitEntity(source, entityHit, damage);
    }

    public String getTranslatedName() {
        return StatCollector.func_74838_a((String)("element." + this.name + ".name"));
    }

    public String getName() {
        return this.name;
    }

    public String getStringColor() {
        return this.stringColor;
    }

    public String getParticle() {
        return this.particle;
    }

    public float getColorX() {
        return (float)(this.color >> 16 & 0xFF) / 256.0f;
    }

    public float getColorY() {
        return (float)(this.color >> 8 & 0xFF) / 256.0f;
    }

    public float getColorZ() {
        return (float)(this.color >> 0 & 0xFF) / 256.0f;
    }
}

