/*
 * Decompiled with CFR 0.152.
 */
package com.fluffy.amnesia.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayerPropertiesHandler
implements IExtendedEntityProperties {
    public static final String PropName = "Amnesia.Player_Properties";
    private int lastPlayerX;
    private int lastPlayerY;
    private int lastPlayerZ;
    private int rayTraceX;
    private int rayTraceY;
    private int rayTraceZ;
    private int lastPlayerX2;
    private int lastPlayerY2;
    private int lastPlayerZ2;
    private boolean lanternEquipped;
    private boolean candleEquipped;
    private boolean flashlightEquipped;
    private boolean bullseyeEquipped;
    private boolean quickEquipped;
    private boolean quick2Equipped;
    private boolean isMusicPlaying;
    public static final int HOTBAR_WATCHER = 20;
    private int hotbarLantern;
    private final EntityPlayer player;

    public ExtendedPlayerPropertiesHandler(EntityPlayer player) {
        this.player = player;
        this.lastPlayerX = 0;
        this.lastPlayerY = 0;
        this.lastPlayerZ = 0;
        this.rayTraceX = 0;
        this.rayTraceY = 0;
        this.rayTraceZ = 0;
        this.lastPlayerX2 = 0;
        this.lastPlayerY2 = 0;
        this.lastPlayerZ2 = 0;
        this.lanternEquipped = false;
        this.bullseyeEquipped = false;
        this.candleEquipped = false;
        this.flashlightEquipped = false;
        this.quickEquipped = false;
        this.quick2Equipped = false;
        this.isMusicPlaying = false;
        this.hotbarLantern = 0;
        this.player.func_70096_w().func_75682_a(20, (Object)this.hotbarLantern);
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(PropName, (IExtendedEntityProperties)new ExtendedPlayerPropertiesHandler(player));
    }

    public static final ExtendedPlayerPropertiesHandler get(EntityPlayer player) {
        return (ExtendedPlayerPropertiesHandler)player.getExtendedProperties(PropName);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound props = new NBTTagCompound();
        compound.func_74782_a(PropName, (NBTBase)props);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound props = (NBTTagCompound)compound.func_74781_a(PropName);
    }

    public void init(Entity entity, World world) {
    }

    public int getPlayerPosX() {
        return (int)Math.floor(this.player.field_70165_t);
    }

    public int getPlayerPosY() {
        return (int)Math.floor(this.player.field_70163_u);
    }

    public int getPlayerPosZ() {
        return (int)Math.floor(this.player.field_70161_v);
    }

    public int getLastPosX() {
        return this.lastPlayerX;
    }

    public int getLastPosY() {
        return this.lastPlayerY;
    }

    public int getLastPosZ() {
        return this.lastPlayerZ;
    }

    public int getRayTraceX() {
        return this.rayTraceX;
    }

    public int getRayTraceY() {
        return this.rayTraceY;
    }

    public int getRayTraceZ() {
        return this.rayTraceZ;
    }

    public int getLastPosX2() {
        return this.lastPlayerX2;
    }

    public int getLastPosY2() {
        return this.lastPlayerY2;
    }

    public int getLastPosZ2() {
        return this.lastPlayerZ2;
    }

    public boolean isLanternEquipped() {
        return this.lanternEquipped;
    }

    public boolean isBullseyeEquipped() {
        return this.bullseyeEquipped;
    }

    public boolean isCandleEquipped() {
        return this.candleEquipped;
    }

    public boolean isFlashlightEquipped() {
        return this.flashlightEquipped;
    }

    public boolean isQuickEquipped() {
        return this.quickEquipped;
    }

    public boolean isQuick2Equipped() {
        return this.quick2Equipped;
    }

    public boolean isMusicPlaying() {
        return this.isMusicPlaying;
    }

    public void setLastPos(int x, int y, int z) {
        this.lastPlayerX = x;
        this.lastPlayerY = y;
        this.lastPlayerZ = z;
    }

    public void setRayTrace(double distance) {
        Vec3 look = this.player.func_70040_Z();
        Vec3 pos = Vec3.func_72443_a((double)this.player.field_70165_t, (double)this.player.field_70163_u, (double)this.player.field_70161_v);
        pos.field_72448_b += (double)this.player.func_70047_e();
        Vec3 addedlook = pos.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        MovingObjectPosition mop = this.player.field_70170_p.func_72933_a(pos, addedlook);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.rayTraceX = mop.field_72311_b;
            this.rayTraceY = mop.field_72312_c;
            this.rayTraceZ = mop.field_72309_d;
        } else {
            this.rayTraceX = (int)Math.floor(addedlook.field_72450_a);
            this.rayTraceY = (int)Math.floor(addedlook.field_72448_b);
            this.rayTraceZ = (int)Math.floor(addedlook.field_72449_c);
        }
    }

    public void setLastPos2(int x, int y, int z) {
        this.lastPlayerX2 = x;
        this.lastPlayerY2 = y;
        this.lastPlayerZ2 = z;
    }

    public void setLanternEquipped(boolean state) {
        this.lanternEquipped = state;
    }

    public void setBullseyeEquipped(boolean state) {
        this.bullseyeEquipped = state;
    }

    public void setCandleEquipped(boolean state) {
        this.candleEquipped = state;
    }

    public void setFlashlightEquipped(boolean state) {
        this.flashlightEquipped = state;
    }

    public void setQuickEquipped(boolean state) {
        this.quickEquipped = state;
    }

    public void setQuick2Equipped(boolean state) {
        this.quick2Equipped = state;
    }

    public void setMusicPlaying(boolean state) {
        this.isMusicPlaying = state;
    }

    public int hotbarLantern() {
        return this.player.func_70096_w().func_75679_c(20);
    }
}

