/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world;

import CoroUtil.event.WorldEvent;
import CoroUtil.pathfinding.PathPointEx;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import CoroUtil.world.grid.chunk.PlayerDataGrid;
import CoroUtil.world.location.ManagedLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class WorldDirector {
    public int dimID = -1;
    public String modID = "modID";
    public String type = "default";
    public int cachedTopBlockHome = -1;
    private NBTTagCompound extraData = new NBTTagCompound();
    public List<WorldEvent> worldEvents = new ArrayList<WorldEvent>();
    public ConcurrentHashMap<Integer, ManagedLocation> lookupTickingManagedLocations = new ConcurrentHashMap();

    public void initData(String parModID, World parWorld) {
        this.dimID = parWorld.field_73011_w.field_76574_g;
        this.modID = parModID;
    }

    public World getWorld() {
        WorldServer world = DimensionManager.getWorld((int)this.dimID);
        return world;
    }

    public NBTTagCompound getExtraData() {
        return this.extraData;
    }

    public void reset() {
        this.extraData = new NBTTagCompound();
        this.cachedTopBlockHome = -1;
        this.worldEvents.clear();
    }

    public void addEvent(WorldEvent event) {
        this.worldEvents.add(event);
        event.init();
    }

    public void addTickingLocation(ManagedLocation location) {
        Integer hash = PathPointEx.makeHash(location.spawn.field_71574_a, location.spawn.field_71572_b, location.spawn.field_71573_c);
        if (!this.lookupTickingManagedLocations.containsKey(hash)) {
            this.lookupTickingManagedLocations.put(hash, location);
        } else {
            System.out.println("epoch error: location already exists at these coords: " + location.spawn);
        }
    }

    public void removeTickingLocation(ManagedLocation location) {
        Integer hash = PathPointEx.makeHash(location.spawn.field_71574_a, location.spawn.field_71572_b, location.spawn.field_71573_c);
        if (this.lookupTickingManagedLocations.containsKey(hash)) {
            this.lookupTickingManagedLocations.remove(hash);
        } else {
            System.out.println("Error, couldnt find location for removal");
        }
    }

    public ManagedLocation getTickingLocation(ChunkCoordinates parCoords) {
        Integer hash = PathPointEx.makeHash(parCoords.field_71574_a, parCoords.field_71572_b, parCoords.field_71573_c);
        return this.lookupTickingManagedLocations.get(hash);
    }

    public void tick() {
        for (int i = 0; i < this.worldEvents.size(); ++i) {
            WorldEvent event = this.worldEvents.get(i);
            if (!event.isComplete()) continue;
            event.cleanup();
            this.worldEvents.remove(i--);
        }
        for (ManagedLocation ml : this.lookupTickingManagedLocations.values()) {
            ml.tickUpdate();
        }
        World world = this.getWorld();
        if (world.func_82737_E() % PlayerDataGrid.playerTimeSpentUpdateInterval == 0L) {
            for (int i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer entP = (EntityPlayer)world.field_73010_i.get(i);
                ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(MathHelper.func_76128_c((double)entP.field_70165_t) / 16, MathHelper.func_76128_c((double)entP.field_70161_v) / 16);
                cdp.addToPlayerActivityTime(entP.func_146103_bH().getId(), PlayerDataGrid.playerTimeSpentUpdateInterval);
            }
        }
    }

    public boolean isCoordAndNearAreaNaturalBlocks(World parWorld, int x, int y, int z, int range) {
        return this.isNaturalSurfaceBlock(parWorld.func_147439_a(x, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x + range, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x - range, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x, y, z + range)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x, y, z - range));
    }

    public boolean isNaturalSurfaceBlock(Block id) {
        if (id == Blocks.field_150433_aE || id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == Blocks.field_150354_m || id == Blocks.field_150348_b || id == Blocks.field_150351_n || id == Blocks.field_150329_H) {
            return true;
        }
        return this.isLogOrLeafBlock(id);
    }

    public boolean isLogOrLeafBlock(Block id) {
        Block block = id;
        if (block == null) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151584_j) {
            return true;
        }
        if (block.func_149688_o() == Material.field_151585_k) {
            return true;
        }
        return block.func_149688_o() == Material.field_151575_d;
    }

    public int getTopGroundBlock(World world, int x, int startY, int z) {
        int safetyCount = 0;
        for (int curY = startY; curY > 0 && safetyCount++ < 300; --curY) {
            Block id = world.func_147439_a(x, curY, z);
            if (!this.isNaturalSurfaceBlock(id)) continue;
            return curY;
        }
        return 1;
    }

    public void tryReadFromFile() {
        this.readFromFile();
    }

    private void readFromFile() {
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "World" + File.separator;
            String fullPath = saveFolder + "WorldData_" + this.modID + "_" + this.dimID + "_" + this.type + ".dat";
            if (new File(fullPath).exists()) {
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fullPath)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToFile(boolean unloadInstances) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            boolean bool = false;
            if (this.extraData != null) {
                bool = this.extraData.func_74767_n("generatedTown");
            }
            System.out.println("writing nbt, generatedTown: " + bool);
            this.writeToNBT(nbt);
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "World" + File.separator;
            System.out.println("saveFolder: " + saveFolder);
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "WorldData_" + this.modID + "_" + this.dimID + "_" + this.type + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readFromNBT(NBTTagCompound parData) {
        this.extraData = parData.func_74775_l("extraData");
        NBTTagCompound dungeonEntrances = parData.func_74775_l("tickingLocations");
        for (String keyName : dungeonEntrances.func_150296_c()) {
            NBTTagCompound nbt = dungeonEntrances.func_74775_l(keyName);
            String classname = nbt.func_74779_i("classname");
            ClassLoader classLoader = WorldDirector.class.getClassLoader();
            Class<?> aClass = null;
            try {
                aClass = classLoader.loadClass(classname);
                System.out.println("aClass.getName() = " + aClass.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ManagedLocation entrance = null;
            if (aClass != null) {
                try {
                    entrance = (ManagedLocation)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (entrance == null) continue;
            entrance.readFromNBT(nbt);
            this.addTickingLocation(entrance);
            System.out.println("reading in ticking location: " + nbt.toString() + " - " + entrance.spawn.field_71574_a + " - " + entrance.spawn.field_71573_c);
        }
    }

    public void writeToNBT(NBTTagCompound parData) {
        NBTTagCompound nbtSet = new NBTTagCompound();
        int index = 0;
        for (Map.Entry<Integer, ManagedLocation> entry : this.lookupTickingManagedLocations.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            entry.getValue().writeToNBT(nbt);
            nbtSet.func_74782_a("" + index++, (NBTBase)nbt);
        }
        parData.func_74782_a("tickingLocations", (NBTBase)nbtSet);
        parData.func_74778_a("classname", this.getClass().getCanonicalName());
        parData.func_74782_a("extraData", (NBTBase)this.extraData);
    }
}

