/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.grid.block;

import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.grid.block.BlockDataPoint;
import CoroUtil.world.grid.block.BlockStaticDataMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BlockDataGrid {
    public World world;
    public HashMap<Integer, BlockDataPoint> grid;

    public BlockDataGrid(World parWorld) {
        this.world = parWorld;
        this.grid = new HashMap();
    }

    public int getHash(int i, int j, int k) {
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public float getBlockStrength(int x, int y, int z) {
        Block blockID = this.world.func_147439_a(x, y, z);
        int blockMeta = this.world.func_72805_g(x, y, z);
        return BlockStaticDataMap.getBlockStength(blockID);
    }

    public BlockDataPoint getBlockData(int i, int j, int k) {
        return this.getBlockData(i, j, k, false, false);
    }

    public BlockDataPoint getBlockDataIfExists(int i, int j, int k) {
        return this.getBlockData(i, j, k, false, true);
    }

    public BlockDataPoint getBlockData(int i, int j, int k, boolean skipAirCheckOnCreate, boolean onlyIfExists) {
        int hash = this.getHash(i, j, k);
        if (!this.grid.containsKey(hash)) {
            if (!onlyIfExists) {
                if (skipAirCheckOnCreate || !CoroUtilBlock.isAir(this.world.func_147439_a(i, j, k))) {
                    BlockDataPoint newVec = new BlockDataPoint(this, i, j, k);
                    this.grid.put(newVec.hash, newVec);
                    return newVec;
                }
                System.out.println("Epoch BlockDataGrid detected air block load, skipping");
                return null;
            }
            return null;
        }
        return this.grid.get(hash);
    }

    public void removeBlockData(int i, int j, int k) {
        int hash = this.getHash(i, j, k);
        if (this.grid.containsKey(hash)) {
            BlockDataPoint bdp = this.grid.get(hash);
            bdp.cleanup();
            this.grid.remove(hash);
        }
    }

    public void readFromFile() {
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "epoch" + File.separator;
            if (new File(saveFolder + "EpochBlockDataDim_" + this.world.field_73011_w.field_76574_g + ".dat").exists()) {
                NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "EpochBlockDataDim_" + this.world.field_73011_w.field_76574_g + ".dat"));
                for (String keyName : data.func_150296_c()) {
                    NBTTagCompound nbt = data.func_74775_l(keyName);
                    BlockDataPoint bdp = this.getBlockData(nbt.func_74762_e("xCoord"), nbt.func_74762_e("yCoord"), nbt.func_74762_e("zCoord"));
                    if (bdp == null) continue;
                    bdp.readFromNBT(nbt);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToFile(boolean unloadInstances) {
        try {
            NBTTagCompound data = new NBTTagCompound();
            Collection<BlockDataPoint> playerDataCl = this.grid.values();
            for (BlockDataPoint bdp : playerDataCl) {
                data.func_74782_a("" + bdp.hash, (NBTBase)bdp.writeToNBT());
            }
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "epoch" + File.separator;
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "EpochBlockDataDim_" + this.world.field_73011_w.field_76574_g + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void tick() {
    }
}

