/*
 * Decompiled with CFR 0.152.
 */
package particleman.entities;

import CoroUtil.util.CoroUtilEntity;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import particleman.element.Element;
import particleman.forge.ParticleMan;
import particleman.items.ItemParticleGlove;

public class EntityParticleControllable
extends Entity
implements IEntityAdditionalSpawnData {
    public String owner = "";
    public int ownerEntityID = -1;
    public int type = 0;
    public int state = 0;
    public int lastMode = 0;
    public int moveMode = 0;
    public int health = 0;
    public int index = 0;
    public int decayTime = 0;
    public int decayTimeMax = 300;
    public int regrabDelay = 0;
    public int regrabDelayMax = 20;
    public int awayFromOwnerTicks = 0;
    @SideOnly(value=Side.CLIENT)
    public List<EntityFX> particles;

    public EntityParticleControllable(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityParticleControllable(World par1World, String parOwner, int parType) {
        super(par1World);
        this.type = parType;
        this.owner = parOwner;
        this.health = this.type == 0 ? 2 : 3;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)((byte)this.state));
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void influenceParticle(float parMotionX, float parMotionY, float parMotionZ) {
        this.decayTime = 0;
        this.field_70159_w += (double)parMotionX;
        this.field_70181_x += (double)parMotionY;
        this.field_70179_y += (double)parMotionZ;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70178_ae = true;
        if (!this.field_70170_p.field_72995_K) {
            ++this.decayTime;
            this.decayTimeMax = this.type == 2 ? 40 : 300;
            if (this.decayTime > this.decayTimeMax) {
                this.func_70106_y();
            }
        } else {
            this.manageParticles();
        }
        if (this.field_70170_p.field_72995_K) {
            this.state = this.field_70180_af.func_75683_a(16);
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)this.state));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.state == 0) {
                Entity ent;
                EntityPlayer player = null;
                if (this.field_70170_p.field_73010_i.size() > 0) {
                    player = this.field_70170_p.func_72924_a(this.owner);
                }
                if (player != null) {
                    this.lastMode = player.getEntityData().func_74762_e("particleMode");
                    ParticleMan.spinAround(this, (Entity)player, 10.0f, 0.5f, 2.0f, this.index, 0.02f, 1, this.moveMode);
                    this.awayFromOwnerTicks = player.func_70032_d((Entity)this) > 15.0f ? ++this.awayFromOwnerTicks : 0;
                    if (this.awayFromOwnerTicks > 100) {
                        this.awayFromOwnerTicks = 0;
                        this.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    }
                } else if (this.ownerEntityID != -1 && (ent = this.field_70170_p.func_73045_a(this.ownerEntityID)) != null) {
                    ParticleMan.spinAround(this, ent, 10.0f, 0.5f, 2.0f, this.index, 0.02f, 1, 1);
                }
            } else if (!this.field_70170_p.field_72995_K && this.regrabDelay++ > this.regrabDelayMax) {
                this.regrabDelay = 0;
                this.state = 0;
            }
        }
        float speedSlowing = 0.98f;
        float gravity = 0.0f;
        if (this.func_70090_H()) {
            speedSlowing *= 0.8f;
        }
        this.field_70159_w *= (double)speedSlowing;
        this.field_70181_x *= (double)speedSlowing;
        this.field_70179_y *= (double)speedSlowing;
        this.field_70181_x -= (double)gravity;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H() && this.type == 0) {
                this.func_70106_y();
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.fizz", 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
            }
            Block id = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            if (this.type == 2 && id == Blocks.field_150480_ab) {
                this.field_70170_p.func_147449_b((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, Blocks.field_150350_a);
                --this.health;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            double size = 0.5;
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(size, size, size));
            for (int i = 0; entities != null && i < entities.size(); ++i) {
                Entity var10 = (Entity)entities.get(i);
                if (var10 != null && !var10.field_70128_L && this.field_70170_p.func_73045_a(this.ownerEntityID) != var10 && (var10 instanceof EntityPlayer && !CoroUtilEntity.getName((Entity)var10).equals(this.owner) && MinecraftServer.func_71276_C().func_71219_W() || var10 instanceof EntityLivingBase && ((EntityLivingBase)var10).func_110143_aJ() > 0.0f && !(var10 instanceof EntityPlayer) && !this.owner.equals(""))) {
                    Random rand = new Random();
                    if (var10 instanceof EntityAnimal && !ParticleMan.hurtAnimals) continue;
                    Element.affectEntity(var10, this, this.type);
                    --this.health;
                    continue;
                }
                if (var10 instanceof EntityParticleControllable) {
                    float speed2 = 0.003f;
                    double vecX = this.field_70165_t - var10.field_70165_t;
                    double vecY = this.field_70163_u - var10.field_70163_u;
                    double vecZ = this.field_70161_v - var10.field_70161_v;
                    double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
                    if (this.lastMode != 1 || !(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) < 0.2)) continue;
                    this.field_70159_w += vecX / dist2 * (double)speed2;
                    this.field_70179_y += vecZ / dist2 * (double)speed2;
                    continue;
                }
                if (var10 instanceof EntityPlayer && CoroUtilEntity.getName((Entity)var10).equals(this.owner)) {
                    int curAmount;
                    ItemStack is;
                    EntityPlayer entP = (EntityPlayer)var10;
                    if (this.type == 2) {
                        var10.func_70066_B();
                    }
                    if (this.state != 0 || this.moveMode != 0 || (is = entP.func_71045_bC()) == null || !(is.func_77973_b() instanceof ItemParticleGlove)) continue;
                    if (is.field_77990_d == null) {
                        is.field_77990_d = new NBTTagCompound();
                    }
                    if ((curAmount = is.field_77990_d.func_74762_e("pm_storage_" + this.type)) < ItemParticleGlove.maxStorage) {
                        is.field_77990_d.func_74768_a("pm_storage_" + this.type, Math.min(curAmount + ItemParticleGlove.depleteRate, ItemParticleGlove.maxStorage));
                    }
                    this.func_70106_y();
                    continue;
                }
                if (!(var10 instanceof EntityLivingBase) || this.type != 2) continue;
                var10.func_70066_B();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.health <= 0) {
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void manageParticles() {
        Random rand = new Random();
        float speed = 0.05f;
        EntityReddustFX entFX = null;
        if (this.particles == null) {
            this.particles = new LinkedList<EntityFX>();
        }
        if (this.particles.size() < 15) {
            if (this.type == 0) {
                entFX = new EntityFlameFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)((rand.nextFloat() - rand.nextFloat()) * speed), (double)((rand.nextFloat() - rand.nextFloat()) * speed), (double)((rand.nextFloat() - rand.nextFloat()) * speed));
            } else if (this.type == 1) {
                entFX = new EntityReddustFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f, 0.0f, 0.0f);
            } else if (this.type == 2) {
                entFX = new EntityReddustFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f, 0.0f, 0.0f);
                entFX.func_70538_b(0.0f, 0.0f, 0.5f + (float)(Math.random() * 0.5));
            }
        }
        if (entFX != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entFX);
            this.particles.add((EntityFX)entFX);
        }
        for (int i = 0; i < this.particles.size(); ++i) {
            EntityFX particle = this.particles.get(i);
            if (particle == null || particle.field_70128_L) {
                this.particles.remove(particle);
                continue;
            }
            ParticleMan.spinAround((Entity)particle, this, 10.0f, 0.2f, 0.0f, i, 0.01f, 0, 0);
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.type);
        data.writeInt(this.index);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.owner);
    }

    public void readSpawnData(ByteBuf data) {
        this.type = data.readInt();
        this.index = data.readInt();
        this.owner = ByteBufUtils.readUTF8String((ByteBuf)data);
    }
}

